/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import me.sirrus86.s86powers.utils.IOHelper;

public class PowerClassLoader
extends ClassLoader {
    private final URL base;

    public PowerClassLoader(URL url) {
        this.base = url;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        block15: {
            clazz = this.findLoadedClass(name);
            if (clazz == null) {
                try {
                    clazz = Class.forName(name);
                    return clazz;
                }
                catch (Throwable e) {
                    clazz = null;
                }
            }
            if (clazz == null) {
                try {
                    int len;
                    InputStream in = this.getResourceAsStream(name.replace('.', '/') + ".class");
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[IOHelper.BYTE_BUFFER];
                    while ((len = in.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    byte[] bytes = out.toByteArray();
                    try {
                        clazz = this.defineClass(name, bytes, 0, bytes.length);
                    }
                    catch (Throwable e) {
                        clazz = null;
                    }
                    if (clazz != null && resolve) {
                        this.resolveClass(clazz);
                    }
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    if (clazz == null) {
                        try {
                            clazz = this.findSystemClass(name);
                        }
                        catch (ClassNotFoundException ex) {
                            clazz = null;
                        }
                    }
                    if (clazz != null) break block15;
                    try {
                        super.loadClass(name, resolve);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        try {
            return new URL(this.base, name);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            return new URL(this.base, name).openStream();
        }
        catch (IOException e) {
            return null;
        }
    }
}

