/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.users;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.config.ConfigOption;
import me.sirrus86.s86powers.events.PowerDamageEvent;
import me.sirrus86.s86powers.events.UserMaxedStatEvent;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.permissions.S86Permission;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerFire;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.powers.internal.utility.NeutralizerBeacon;
import me.sirrus86.s86powers.regions.NeutralRegion;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerGroup;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public final class PowerUser
implements Comparable<PowerUser> {
    private Set<NeutralizerBeacon.Beacon> beacons = new HashSet<NeutralizerBeacon.Beacon>();
    private Map<Power, Long> cooldowns = new HashMap<Power, Long>();
    private Set<PowerGroup> groups = new HashSet<PowerGroup>();
    private Map<PowerOption<?>, Object> options = new HashMap();
    private Map<Power, Boolean> powers = new HashMap<Power, Boolean>();
    private Set<NeutralRegion> regions = new HashSet<NeutralRegion>();
    private Map<PowerStat, Integer> stats = new HashMap<PowerStat, Integer>();
    private final File cFile;
    private YamlConfiguration config;
    private boolean enabled = true;
    private String name;
    private int nTask = -1;
    private long nTimer = 0L;
    private OfflinePlayer oPlayer;
    private long saveTimer = 0L;
    private final UUID uuid;
    private static final S86Powers plugin = (S86Powers)JavaPlugin.getPlugin(S86Powers.class);

    public PowerUser(UUID uuid) {
        this.uuid = uuid;
        this.name = this.getOfflinePlayer().getName();
        String filename = this.uuid.toString();
        if (!plugin.getServer().getOnlineMode() || ConfigOption.Users.SAVE_FILES_BY_NAME) {
            filename = this.name;
        }
        this.cFile = new File(plugin.getUserDirectory(), filename + ".yml");
        if (!this.cFile.exists()) {
            try {
                this.cFile.createNewFile();
            }
            catch (IOException e) {
                plugin.getLogger().severe(LocaleString.FILE_CREATE_FAIL.build(this.cFile));
                e.printStackTrace();
            }
        }
    }

    public void addBeacon(NeutralizerBeacon.Beacon beacon) {
        if (this.beacons.isEmpty()) {
            this.neutralize(LocaleString.NEUTRALIZED_BY_BEACON.toString());
        }
        this.beacons.add(beacon);
        if (ConfigOption.Powers.SHOW_NEUTRALIZING_BEACON) {
            PowerTools.addSpectralBlock(this.getPlayer(), beacon.getBlock(), ChatColor.BLUE);
        }
    }

    void addGroup(PowerGroup group) {
        this.groups.add(group);
        if (!group.hasMember(this)) {
            group.addMember(this);
        }
        this.autosave();
    }

    private void addGroupWithoutSaving(PowerGroup group) {
        this.groups.add(group);
        if (!group.hasMember(this)) {
            group.addMember(this);
        }
    }

    public void addItems(ItemStack ... items) {
        HashMap added;
        if (this.isOnline() && !(added = this.getPlayer().getInventory().addItem(items)).isEmpty()) {
            for (ItemStack stack : added.values()) {
                this.getPlayer().getWorld().dropItemNaturally(this.getPlayer().getLocation(), stack);
            }
        }
    }

    public boolean addPotionEffect(PotionEffect effect) {
        if (this.isOnline()) {
            return this.getPlayer().addPotionEffect(effect);
        }
        return false;
    }

    public void addPotionEffects(Collection<PotionEffect> effects) {
        if (this.isOnline() && effects != null && !effects.isEmpty()) {
            this.getPlayer().addPotionEffects(effects);
        }
    }

    public void addPower(Power power) {
        this.addPower(power, true);
    }

    public void addPower(Power power, boolean enable) {
        if (power != null && !this.powers.containsKey(power)) {
            this.powers.put(power, enable);
            power.addUser(this);
            power.enable(this);
        }
    }

    private void addPowerWithoutSaving(Power power, boolean enable) {
        if (!this.powers.containsKey(power)) {
            this.powers.put(power, enable);
        }
        power.addUser(this);
        power.enable(this);
    }

    public void addRegion(NeutralRegion region) {
        if (this.regions.isEmpty()) {
            this.neutralize(LocaleString.NEUTRALIZED_BY_REGION.toString());
        }
        this.regions.add(region);
    }

    public boolean allowPower(Power power) {
        if (power.getType() == PowerType.UTILITY) {
            return true;
        }
        if (this.getPlayer() != null && this.getPlayer().isOnline() && this.hasEnablePermission() && this.hasPowersEnabled() && !this.isNeutralized()) {
            return this.hasPower(power) && this.hasPowerEnabled(power) || this.getPlayer().hasPermission(power.getUsePermission());
        }
        return false;
    }

    private void autosave() {
        if (ConfigOption.Plugin.AUTO_SAVE && System.currentTimeMillis() >= this.saveTimer) {
            this.save();
        }
    }

    public void causeDamage(Power power, EntityDamageByEntityEvent event) {
        this.causeDamage(power, event, Double.MAX_VALUE);
    }

    public void causeDamage(Power power, EntityDamageByEntityEvent event, double cap) {
        plugin.getServer().getPluginManager().callEvent((Event)new PowerDamageEvent(power, event, cap));
    }

    public void causeDamage(Power power, Damageable target, EntityDamageEvent.DamageCause cause, double damage) {
        this.causeDamage(power, target, cause, damage, Double.MAX_VALUE);
    }

    public void causeDamage(Power power, Damageable target, EntityDamageEvent.DamageCause cause, double damage, double cap) {
        plugin.getServer().getPluginManager().callEvent((Event)new PowerDamageEvent(power, this, target, cause, damage, cap));
    }

    public void causeIgnite(Power power, Entity target, int duration) {
        target.setFireTicks(duration);
        if (target instanceof LivingEntity) {
            plugin.getBlockListener().addIgnite((Entity)((LivingEntity)target), new PowerFire(power, this));
        }
    }

    public void clearStat(PowerStat stat) {
        if (this.stats.containsKey(stat)) {
            this.stats.remove(stat);
        }
        if (ConfigOption.Plugin.AUTO_SAVE && System.currentTimeMillis() >= this.saveTimer) {
            this.save();
        }
    }

    @Override
    public int compareTo(PowerUser user) {
        String o1Str = this.getName();
        String o2Str = user.getName();
        if (o1Str != null && o2Str != null) {
            List<String> tmp = Arrays.asList(o1Str, o2Str);
            Collections.sort(tmp);
            return tmp.get(0).equalsIgnoreCase(this.getName()) ? -1 : 1;
        }
        return -1;
    }

    void deneutralize(boolean force) {
        if (!this.isNeutralized() || force) {
            if (this.isOnline()) {
                this.sendMessage(ChatColor.GREEN + LocaleString.POWERS_RETURN.toString());
            }
            if (this.nTask != -1 && plugin.getServer().getScheduler().isQueued(this.nTask)) {
                plugin.getServer().getScheduler().cancelTask(this.nTask);
                this.nTask = -1;
            }
            this.beacons.clear();
            this.regions.clear();
        }
    }

    void neutralize(String message) {
        if (!this.isNeutralized()) {
            this.getPlayer().getWorld().playEffect(this.getPlayer().getEyeLocation(), Effect.STEP_SOUND, (Object)Material.BLUE_STAINED_GLASS);
            this.sendMessage(ChatColor.BLUE + message);
            for (Power power : this.powers.keySet()) {
                power.disable(this);
            }
            if (S86Powers.getProtocolLib() != null) {
                PowerTools.removeDisguise((Entity)this.getPlayer());
                PowerTools.removeGhost(this.getPlayer());
            }
        }
    }

    public Set<Power> getAllUsablePowers() {
        return Sets.union(this.getPowers(true), this.getPermissiblePowers());
    }

    public Set<PowerGroup> getAssignedGroups() {
        return this.groups;
    }

    public Set<Power> getAssignedPowers() {
        return this.powers.keySet();
    }

    public Set<Power> getAssignedPowersByType(PowerType type) {
        HashSet<Power> tmp = new HashSet<Power>();
        for (Power power : this.powers.keySet()) {
            if (power.getType() != type) continue;
            tmp.add(power);
        }
        return tmp;
    }

    Set<NeutralizerBeacon.Beacon> getBeaconsInhabited() {
        return this.beacons;
    }

    public long getCooldown(Power power) {
        if (this.cooldowns.containsKey(power) && this.cooldowns.get(power) > System.currentTimeMillis()) {
            return this.cooldowns.get(power) - System.currentTimeMillis();
        }
        return 0L;
    }

    public ItemStack getEquipment(EquipmentSlot slot) {
        return PowerTools.getEquipment((LivingEntity)this.getPlayer(), slot);
    }

    public Set<Power> getGroupPowers() {
        HashSet<Power> tmp = new HashSet<Power>();
        for (PowerGroup group : this.getGroups()) {
            tmp.addAll(group.getPowers());
        }
        return tmp;
    }

    public Set<PowerGroup> getGroups() {
        HashSet<PowerGroup> tmp = new HashSet<PowerGroup>();
        tmp.addAll(this.getAssignedGroups());
        tmp.addAll(this.getPermissibleGroups());
        return tmp;
    }

    public String getName() {
        if (this.getOfflinePlayer().getName() != null) {
            this.name = this.getOfflinePlayer().getName();
        }
        return this.name;
    }

    public OfflinePlayer getOfflinePlayer() {
        if (this.oPlayer == null || this.oPlayer.getUniqueId() != this.uuid) {
            this.oPlayer = plugin.getServer().getOfflinePlayer(this.uuid);
        }
        return this.oPlayer;
    }

    public <O> O getOption(PowerOption<O> option) {
        assert (option != null);
        Power power = option.getPower();
        return (O)(this.options.containsKey(option) ? this.options.get(option) : power.getOption(option));
    }

    public Map<PowerOption<?>, Object> getOptions() {
        return this.options;
    }

    public Object getOptionValue(PowerOption<?> option) {
        return this.options.containsKey(option) ? this.options.get(option) : null;
    }

    Set<PowerGroup> getPermissibleGroups() {
        HashSet<PowerGroup> tmp = new HashSet<PowerGroup>();
        if (this.isOnline() && ConfigOption.Plugin.ENABLE_PERMISSION_ASSIGNMENTS) {
            for (PowerGroup group : S86Powers.getConfigManager().getGroups()) {
                if (!this.getPlayer().hasPermission(group.getRequiredPermission())) continue;
                tmp.add(group);
            }
        }
        return tmp;
    }

    public Set<Power> getPermissiblePowers() {
        HashSet<Power> tmp = new HashSet<Power>();
        if (this.isOnline() && ConfigOption.Plugin.ENABLE_PERMISSION_ASSIGNMENTS) {
            for (Power power : S86Powers.getConfigManager().getPowers()) {
                if (!this.getPlayer().hasPermission(power.getUsePermission())) continue;
                tmp.add(power);
            }
        }
        return tmp;
    }

    public Player getPlayer() {
        return this.getOfflinePlayer().getPlayer();
    }

    public Set<Power> getPowers() {
        return this.getPowers(false);
    }

    public Set<Power> getPowers(boolean includeUtility) {
        HashSet<Power> tmp = new HashSet<Power>();
        if (includeUtility) {
            tmp.addAll(S86Powers.getConfigManager().getPowersByType(PowerType.UTILITY));
        }
        tmp.addAll(this.getAssignedPowers());
        tmp.addAll(this.getGroupPowers());
        tmp.addAll(this.getPermissiblePowers());
        return tmp;
    }

    Set<NeutralRegion> getRegionsInhabited() {
        return this.regions;
    }

    public int getStatCount(PowerStat stat) {
        return this.stats.containsKey(stat) ? this.stats.get(stat) : 0;
    }

    public Entity getTargetEntity(double range) {
        return this.getTargetEntity(Entity.class, range);
    }

    public <E extends Entity> E getTargetEntity(Class<E> clazz, double range) {
        if (this.isOnline()) {
            Predicate<Entity> pred = entity -> entity != this.getPlayer() && clazz.isInstance(entity);
            return PowerTools.getTargetEntity(clazz, this.getPlayer().getEyeLocation(), this.getPlayer().getEyeLocation().getDirection(), range, pred);
        }
        return null;
    }

    public Location getTargetLocation(double range) {
        if (this.isOnline()) {
            Vector dir = this.getPlayer().getLocation().getDirection();
            Location loc = this.getPlayer().getEyeLocation().clone();
            while (this.getPlayer().getEyeLocation().distanceSquared(loc) <= range * range) {
                if (loc.getBlock().getType().isOccluding()) {
                    return loc;
                }
                loc.add(dir);
            }
        }
        return null;
    }

    public final UUID getUUID() {
        return this.uuid;
    }

    boolean hasEnablePermission() {
        return this.isAdmin() && ConfigOption.Admin.BYPASS_PERMISSION || this.getPlayer() != null && this.getPlayer().hasPermission(S86Permission.ENABLE);
    }

    public boolean hasPower(Power power) {
        return this.getPowers(true).contains(power);
    }

    public boolean hasPower(String name) {
        for (Power power : this.getPowers(true)) {
            if (!power.getClass().getSimpleName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPowerAssigned(Power power) {
        return this.powers.containsKey(power);
    }

    public boolean hasPowerEnabled(Power power) {
        return this.powers.containsKey(power) ? this.powers.get(power) : this.isOnline() && this.getPlayer().hasPermission(power.getAssignPermission());
    }

    public boolean hasPowersEnabled() {
        return this.enabled;
    }

    public boolean hasStatMaxed(PowerStat stat) {
        return this.stats.containsKey(stat) && this.stats.get(stat) >= stat.getPower().getStatValue(stat);
    }

    public void heal(double amt) {
        if (this.isOnline()) {
            amt = this.getPlayer().getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() - this.getPlayer().getHealth() < amt ? this.getPlayer().getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() - this.getPlayer().getHealth() : amt;
            this.getPlayer().setHealth(this.getPlayer().getHealth() + amt);
        }
    }

    public void increaseStat(PowerStat stat, int amount) {
        Power power = stat.getPower();
        if (!this.stats.containsKey(stat)) {
            this.stats.put(stat, 0);
        }
        if (this.stats.get(stat) < power.getStatValue(stat) || amount < 0) {
            int newStat = this.stats.get(stat) + amount;
            this.stats.put(stat, newStat > power.getStatValue(stat) ? power.getStatValue(stat) : newStat);
            if (this.isOnline()) {
                this.sendMessage(power.getType().getColor() + power.getName() + ChatColor.RESET + " > " + ChatColor.YELLOW + stat.getDescription() + ChatColor.RESET + ": " + (this.stats.get(stat) < power.getStatValue(stat) + 1 ? this.stats.get(stat).intValue() : power.getStatValue(stat)) + "/" + power.getStatValue(stat));
                if (this.hasStatMaxed(stat)) {
                    UserMaxedStatEvent event = new UserMaxedStatEvent(this, stat);
                    plugin.getServer().getPluginManager().callEvent((Event)event);
                    this.sendMessage(power.getType().getColor() + power.getName() + ChatColor.RESET + " > " + ChatColor.YELLOW + PowerTools.getFilteredText(power, stat.getReward()));
                }
            }
            if (ConfigOption.Plugin.AUTO_SAVE && System.currentTimeMillis() >= this.saveTimer) {
                this.save();
                this.saveTimer = System.currentTimeMillis() + ConfigOption.Plugin.AUTO_SAVE_COOLDOWN;
            }
        }
    }

    boolean inGroup(PowerGroup group) {
        return this.groups.contains(group);
    }

    public boolean isAdmin() {
        return this.isOnline() && this.getPlayer().hasPermission(S86Permission.ADMIN);
    }

    public boolean isHoldingItem(ItemStack item) {
        return this.isOnline() && this.getPlayer().getInventory().getItemInMainHand() != null && this.getPlayer().getInventory().getItemInMainHand().getType() == item.getType() || this.isOnline() && this.getPlayer().getInventory().getItemInOffHand() != null && this.getPlayer().getInventory().getItemInOffHand().getType() == item.getType();
    }

    public boolean isOnline() {
        return this.getOfflinePlayer().isOnline();
    }

    public boolean isNeutralized() {
        return !this.beacons.isEmpty() || !this.regions.isEmpty() || this.nTask > -1;
    }

    public void load() {
        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
            plugin.getLogger().info(LocaleString.LOAD_ATTEMPT.build(this.cFile));
        }
        if (this.cFile != null) {
            this.config = YamlConfiguration.loadConfiguration((File)this.cFile);
            if (this.config.contains("powers")) {
                for (String pwr : this.config.getConfigurationSection("powers").getKeys(false)) {
                    Power power = S86Powers.getConfigManager().getPower(pwr);
                    if (power == null) continue;
                    if (this.config.contains("powers." + pwr + ".active", false)) {
                        this.addPowerWithoutSaving(power, this.config.getBoolean("powers." + pwr + ".active", false));
                    }
                    if (this.config.contains("powers." + pwr + ".options")) {
                        for (String optName : this.config.getConfigurationSection("powers." + pwr + ".options").getKeys(false)) {
                            PowerOption<?> option = power.getOptionByName(optName);
                            if (option == null) continue;
                            this.options.put(option, this.config.get("powers." + pwr + ".options." + optName, power.getOption(option)));
                        }
                    }
                    if (!this.config.contains("powers." + pwr + ".stats")) continue;
                    for (String statName : this.config.getConfigurationSection("powers." + pwr + ".stats").getKeys(false)) {
                        PowerStat stat = power.getStat(statName);
                        if (stat == null) continue;
                        this.stats.put(stat, this.config.getInt("powers." + pwr + ".stats." + statName, 0));
                    }
                }
            }
            if (this.config.contains("groups")) {
                for (String grp : this.config.getStringList("groups")) {
                    PowerGroup group = S86Powers.getConfigManager().getGroup(grp);
                    if (group == null) continue;
                    this.addGroupWithoutSaving(group);
                }
            }
            if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                plugin.getLogger().info(LocaleString.LOAD_SUCCESS.build(this.cFile));
            }
        } else {
            if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                plugin.getLogger().info(LocaleString.LOAD_FAIL.build(this.cFile));
            }
            throw new NullPointerException();
        }
    }

    void purge() {
        this.beacons = new HashSet<NeutralizerBeacon.Beacon>();
        this.cooldowns = new HashMap<Power, Long>();
        this.groups = new HashSet<PowerGroup>();
        this.powers = new HashMap<Power, Boolean>();
        this.regions = new HashSet<NeutralRegion>();
        this.stats = new HashMap<PowerStat, Integer>();
    }

    public void regenHunger(int amt) {
        if (this.isOnline()) {
            amt = 20 - this.getPlayer().getFoodLevel() < amt ? 20 - this.getPlayer().getFoodLevel() : amt;
            this.getPlayer().setFoodLevel(this.getPlayer().getFoodLevel() + amt);
        }
    }

    public void removeBeacon(NeutralizerBeacon.Beacon beacon) {
        if (this.beacons.contains(beacon)) {
            this.beacons.remove(beacon);
            this.deneutralize(false);
        }
        PowerTools.removeSpectralBlock(this.getPlayer(), beacon.getBlock());
    }

    void removeGroup(PowerGroup group) {
        this.groups.remove(group);
        if (group.hasMember(this)) {
            group.removeMember(this);
        }
        this.autosave();
    }

    public void removeOption(PowerOption<?> option) {
        if (this.options.containsKey(option)) {
            this.options.remove(option);
        }
    }

    public void removePotionEffect(PotionEffectType effect) {
        if (this.isOnline()) {
            this.getPlayer().removePotionEffect(effect);
        }
    }

    public void removePotionEffects(Collection<PotionEffect> effects) {
        if (this.isOnline() && effects != null && !effects.isEmpty()) {
            for (PotionEffect effect : effects) {
                this.getPlayer().removePotionEffect(effect.getType());
            }
        }
    }

    public void removePower(Power power) {
        if (this.powers.containsKey(power)) {
            this.powers.remove(power);
        }
        power.removeUser(this);
        power.disable(this);
        this.autosave();
    }

    public void removeRegion(NeutralRegion region) {
        if (this.regions.contains(region)) {
            this.regions.remove(region);
            this.deneutralize(false);
        }
    }

    public void save() {
        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
            plugin.getLogger().info(LocaleString.SAVE_ATTEMPT.build(this.cFile));
        }
        if (this.cFile != null) {
            if (this.config == null) {
                this.config = YamlConfiguration.loadConfiguration((File)this.cFile);
            }
            this.config.set("groups", null);
            if (!this.getAssignedGroups().isEmpty()) {
                Iterator<Comparable<PowerOption<?>>> gList = new ArrayList();
                for (PowerGroup group : this.getAssignedGroups()) {
                    gList.add((Comparable<PowerOption<?>>)((Object)group.getName()));
                }
                this.config.set("groups", (Object)gList);
            }
            this.config.set("powers", null);
            if (!this.getAssignedPowers().isEmpty()) {
                for (Power power : this.getAssignedPowers()) {
                    this.config.set("powers." + power.getClass().getSimpleName() + ".active", (Object)this.hasPowerEnabled(power));
                }
            }
            if (!this.options.isEmpty()) {
                for (PowerOption<?> option : this.options.keySet()) {
                    this.config.set("powers." + option.getPower().getClass().getSimpleName() + ".options." + option.getPath(), this.options.get(option));
                }
            }
            if (!this.stats.isEmpty()) {
                for (PowerStat stat : this.stats.keySet()) {
                    this.config.set("powers." + stat.getPower().getClass().getSimpleName() + ".stats." + stat.getPath(), (Object)this.stats.get(stat));
                }
            }
            try {
                this.config.save(this.cFile);
                if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                    plugin.getLogger().info(LocaleString.SAVE_SUCCESS.build(this.cFile));
                }
                this.saveTimer = System.currentTimeMillis() + ConfigOption.Plugin.AUTO_SAVE_COOLDOWN;
            }
            catch (IOException e) {
                if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                    plugin.getLogger().info(LocaleString.SAVE_FAIL.build(this.cFile));
                }
                e.printStackTrace();
            }
        } else {
            if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                plugin.getLogger().info(LocaleString.SAVE_FAIL.build(this.cFile));
            }
            throw new NullPointerException();
        }
    }

    public void sendMessage(String message) {
        if (ConfigOption.Users.SHOW_MESSAGES_IN_ACTION_BAR && S86Powers.getProtocolLib() != null) {
            PowerTools.showActionBarMessage(this.getPlayer(), message);
        } else {
            this.getPlayer().sendMessage(message);
        }
    }

    public void setAllowFlight(boolean allow) {
        if (this.isOnline() && (this.getPlayer().getGameMode() == GameMode.ADVENTURE || this.getPlayer().getGameMode() == GameMode.SURVIVAL)) {
            this.getPlayer().setAllowFlight(allow);
        }
    }

    public void setCooldown(Power power, long time) {
        if (!this.isAdmin() || !ConfigOption.Admin.BYPASS_COOLDOWN) {
            this.cooldowns.put(power, System.currentTimeMillis() + time);
            if (ConfigOption.Powers.SHOW_COOLDOWN_ON_ITEM && power.getRequiredItem() != null && S86Powers.getProtocolLib() != null) {
                PowerTools.showItemCooldown(this.getPlayer(), power.getRequiredItem(), time);
            }
        }
    }

    public void setNeutralizedByPower(Power power, long duration) {
        if (System.currentTimeMillis() + duration > this.nTimer) {
            this.neutralize(LocaleString.NEUTRALIZED_BY_POWER.build(power, duration));
            if (plugin.getServer().getScheduler().isQueued(this.nTask)) {
                plugin.getServer().getScheduler().cancelTask(this.nTask);
            }
            BukkitTask task = plugin.getServer().getScheduler().runTaskLater((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    PowerUser.this.nTask = -1;
                    PowerUser.this.deneutralize(false);
                }
            }, PowerTime.toTicks(duration));
            this.nTask = task.getTaskId();
            this.nTimer = System.currentTimeMillis() + duration;
        }
    }

    public void setOption(PowerOption<?> option, Object value) {
        this.options.put(option, value);
    }

    public void setPowerEnabled(Power power, boolean newState) {
        if (this.powers.containsKey(power)) {
            this.powers.put(power, newState);
            if (!newState) {
                power.disable(this);
            }
        }
        if (ConfigOption.Plugin.AUTO_SAVE && System.currentTimeMillis() >= this.saveTimer) {
            this.save();
        }
    }

    public void setPowersEnabled(boolean newState) {
        this.enabled = newState;
    }

    public void showCooldown(Power power) {
        if (this.isOnline()) {
            this.sendMessage(ChatColor.RED + LocaleString.POWER_ON_COOLDOWN.build(this.getCooldown(power), power));
        }
    }

    public void supply(Power power) {
        if (this.isOnline()) {
            for (int i = 0; i < power.getSupplies().size(); ++i) {
                ItemStack item = power.getSupplies().get(i);
                boolean filled = false;
                for (ItemStack stack : this.getPlayer().getInventory().getContents()) {
                    if (stack == null || item == null) continue;
                    if (PowerTools.usesDurability(item) && item.getType() == stack.getType()) {
                        stack.setDurability((short)0);
                        filled = true;
                        break;
                    }
                    if (item.getType() != stack.getType() || item.getDurability() != stack.getDurability()) continue;
                    if (stack.getAmount() < item.getAmount()) {
                        stack.setAmount(item.getAmount());
                    }
                    filled = true;
                    break;
                }
                if (filled) continue;
                int j = this.getPlayer().getInventory().firstEmpty();
                if (j > -1) {
                    this.getPlayer().getInventory().setItem(j, item);
                    continue;
                }
                this.getPlayer().getWorld().dropItem(this.getPlayer().getLocation(), item);
            }
        }
    }
}

