/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.users;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.config.ConfigOption;
import me.sirrus86.s86powers.localization.LocaleString;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.java.JavaPlugin;

public class PowerGroup
implements Comparable<PowerGroup> {
    private Set<PowerUser> members = new HashSet<PowerUser>();
    private Set<Power> powers = new HashSet<Power>();
    private final File cFile;
    private YamlConfiguration config;
    private final String name;
    private final Permission perm;
    private static final S86Powers plugin = (S86Powers)JavaPlugin.getPlugin(S86Powers.class);

    public PowerGroup(String name) {
        this.name = name;
        this.cFile = new File(plugin.getGroupDirectory(), name + ".yml");
        this.perm = new Permission("s86powers.group." + name, "Allows player to use powers assigned to group '" + name + "'.", PermissionDefault.FALSE);
        if (!plugin.getServer().getPluginManager().getPermissions().contains(this.perm)) {
            plugin.getServer().getPluginManager().addPermission(this.perm);
        }
    }

    public void addMember(PowerUser user) {
        this.members.add(user);
        if (!user.inGroup(this)) {
            user.addGroup(this);
        }
    }

    public void addPower(Power power) {
        this.powers.add(power);
    }

    @Override
    public int compareTo(PowerGroup g) {
        String o1Str = this.getName();
        String o2Str = g.getName();
        List<String> tmp = Arrays.asList(o1Str, o2Str);
        Collections.sort(tmp);
        if (tmp.get(0).equalsIgnoreCase(this.getName())) {
            return -1;
        }
        return 1;
    }

    public void disband() {
        ArrayList members = Lists.newArrayList(this.getMembers());
        for (int i = 0; i < members.size(); ++i) {
            ((PowerUser)members.get(i)).removeGroup(this);
        }
        this.cFile.delete();
    }

    public Set<PowerUser> getMembers() {
        return this.members;
    }

    public final String getName() {
        return this.name;
    }

    public Set<Power> getPowers() {
        return this.powers;
    }

    public final Permission getRequiredPermission() {
        return this.perm;
    }

    public boolean hasMember(PowerUser user) {
        return this.members.contains(user);
    }

    public boolean hasPower(Power power) {
        return this.powers.contains(power);
    }

    public void load() {
        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
            plugin.getLogger().info(LocaleString.LOAD_ATTEMPT.build(this.cFile));
        }
        if (this.cFile != null) {
            this.config = YamlConfiguration.loadConfiguration((File)this.cFile);
            if (this.config.contains("players")) {
                for (String uName : this.config.getStringList("players")) {
                    PowerUser user = S86Powers.getConfigManager().getUser(UUID.fromString(uName));
                    if (user == null) continue;
                    this.addMember(user);
                }
            }
            if (this.config.contains("powers")) {
                for (String pwr : this.config.getStringList("powers")) {
                    Power power = S86Powers.getConfigManager().getPower(pwr);
                    if (power == null) continue;
                    this.addPower(power);
                }
            }
            if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                plugin.getLogger().info(LocaleString.LOAD_SUCCESS.build(this.cFile));
            }
        } else {
            if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                plugin.getLogger().severe(LocaleString.LOAD_FAIL.build(this.cFile));
            }
            throw new NullPointerException();
        }
    }

    public void removeMember(PowerUser user) {
        this.members.remove(user);
        if (user.inGroup(this)) {
            user.removeGroup(this);
        }
        for (Power power : this.powers) {
            if (user.hasPowerAssigned(power)) continue;
            power.disable(user);
        }
    }

    public void removePower(Power power) {
        this.powers.remove(power);
        for (PowerUser user : this.members) {
            if (user.hasPowerAssigned(power)) continue;
            power.disable(user);
        }
    }

    public void save() {
        if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
            plugin.getLogger().info(LocaleString.SAVE_ATTEMPT.build(this.cFile));
        }
        if (this.cFile != null) {
            if (this.config == null) {
                this.config = YamlConfiguration.loadConfiguration((File)this.cFile);
            }
            this.config.set("players", null);
            if (!this.members.isEmpty()) {
                ArrayList<String> uList = new ArrayList<String>();
                for (PowerUser user : this.members) {
                    uList.add(user.getUUID().toString());
                }
                this.config.set("players", uList);
            }
            this.config.set("powers", null);
            if (!this.powers.isEmpty()) {
                ArrayList<String> pList = new ArrayList<String>();
                for (Power power : this.powers) {
                    pList.add(power.getTag());
                }
                this.config.set("powers", pList);
            }
            try {
                this.config.save(this.cFile);
                if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                    plugin.getLogger().info(LocaleString.SAVE_SUCCESS.build(this.cFile));
                }
            }
            catch (IOException e) {
                if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                    plugin.getLogger().severe(LocaleString.SAVE_FAIL.build(this.cFile));
                }
                e.printStackTrace();
            }
        } else {
            if (ConfigOption.Plugin.SHOW_CONFIG_STATUS) {
                plugin.getLogger().severe(LocaleString.SAVE_FAIL.build(this.cFile));
            }
            throw new NullPointerException();
        }
    }
}

