/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.tools.version;

import org.bukkit.Bukkit;

public enum MCVersion {
    v1_13("v1_13_R1", 4.4),
    v1_13_1("v1_13_R2", 4.4),
    v1_13_2("v1_13_R2", 4.4),
    v1_14("v1_14_R1", 4.5),
    v1_14_1("v1_14_R1", 4.5),
    v1_14_2("v1_14_R1", 4.5),
    v1_14_3("v1_14_R1", 4.5),
    v1_14_4("v1_14_R1", 4.5),
    v1_15("v1_15_R1", 4.5),
    v1_15_1("v1_15_R1", 4.5),
    v1_15_2("v1_15_R1", 4.5),
    v1_16_1("v1_16_R1", 4.6),
    v1_16_2("v1_16_R2", 4.6),
    v1_16_3("v1_16_R2", 4.6),
    v1_16_4("v1_16_R3", 4.6),
    v1_16_5("v1_16_R3", 4.6),
    v1_17("v1_17", 4.7),
    v1_17_1("v1_17_1", 4.7),
    v1_18("v1_18", 4.8),
    v1_18_1("v1_18_1", 4.8),
    v1_18_2("v1_18_2", 4.8),
    v1_19("v1_19", 5.0),
    v1_19_1("v1_19_1", 5.0),
    v1_19_2("v1_19_2", 5.0),
    v1_19_3("v1_19_3", 5.0),
    UNSUPPORTED("unsupported", 0.0);

    public static final MCVersion CURRENT_VERSION;
    private final String path;
    private final double pLibVer;

    private MCVersion(String path, double pLibVer) {
        this.path = path;
        this.pLibVer = pLibVer;
    }

    private static MCVersion getCurrentVersion() {
        String version = "v" + Bukkit.getVersion().substring(Bukkit.getVersion().indexOf("(MC:") + 5, Bukkit.getVersion().indexOf(")")).replaceAll("\\.", "_");
        try {
            return MCVersion.valueOf(version);
        }
        catch (IllegalArgumentException e) {
            return UNSUPPORTED;
        }
    }

    public String getPath() {
        return this.path;
    }

    public double getRequiredProtocolLib() {
        return this.pLibVer;
    }

    public static final boolean isLessThan(MCVersion version) {
        return CURRENT_VERSION.ordinal() < version.ordinal();
    }

    public static final boolean isVersion(MCVersion ... versions) {
        for (int i = 0; i < versions.length; ++i) {
            if (!CURRENT_VERSION.equals((Object)versions[i])) continue;
            return true;
        }
        return false;
    }

    static {
        CURRENT_VERSION = MCVersion.getCurrentVersion();
    }
}

