/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.tools.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.InternalStructure;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.ChunkCoordIntPair;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.MultiBlockChangeInfo;
import com.comphenix.protocol.wrappers.Pair;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.sirrus86.s86powers.config.ConfigOption;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.tools.packets.PacketManager;
import me.sirrus86.s86powers.tools.version.MCMetadata;
import me.sirrus86.s86powers.tools.version.MCVersion;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public final class PacketManagerPLib
extends PacketManager {
    private Map<BlockPosition, PacketContainer> blocks = new HashMap<BlockPosition, PacketContainer>();
    private Map<UUID, PacketContainer> disguises = new HashMap<UUID, PacketContainer>();
    private Map<UUID, PacketContainer> metadata = new HashMap<UUID, PacketContainer>();
    private Map<UUID, Set<PacketContainer>> equipment = new HashMap<UUID, Set<PacketContainer>>();
    private final ProtocolManager pm = ProtocolLibrary.getProtocolManager();

    public PacketManagerPLib() {
        this.pm.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, new PacketType[]{PacketType.Play.Server.ENTITY_METADATA, PacketType.Play.Server.SPAWN_ENTITY, PacketType.Play.Server.NAMED_ENTITY_SPAWN, PacketType.Play.Server.BLOCK_CHANGE, PacketType.Play.Client.STEER_VEHICLE, PacketType.Play.Client.USE_ENTITY, PacketType.Play.Client.BLOCK_DIG}){

            public void onPacketSending(PacketEvent event) {
                Entity entity;
                Player viewer;
                block21: {
                    viewer = event.getPlayer();
                    entity = null;
                    try {
                        entity = (Entity)event.getPacket().getEntityModifier(event).readSafely(0);
                    }
                    catch (Exception e) {
                        if (!ConfigOption.Plugin.SHOW_PACKET_ERRORS) break block21;
                        e.printStackTrace();
                    }
                }
                if (event.getPacketType() == PacketType.Play.Server.BLOCK_CHANGE) {
                    BlockPosition bPos = (BlockPosition)event.getPacket().getBlockPositionModifier().readSafely(0);
                    if (bPos != null && PacketManagerPLib.this.blocks.containsKey(bPos)) {
                        event.setPacket((PacketContainer)PacketManagerPLib.this.blocks.get(bPos));
                    }
                } else if (event.getPacketType() == PacketType.Play.Server.SPAWN_ENTITY || event.getPacketType() == PacketType.Play.Server.NAMED_ENTITY_SPAWN) {
                    if (entity != null) {
                        if (PacketManagerPLib.this.disguises.containsKey(entity.getUniqueId())) {
                            PacketContainer packet = (PacketContainer)PacketManagerPLib.this.disguises.get(entity.getUniqueId());
                            if (packet.getType() == event.getPacketType()) {
                                event.setPacket(packet);
                            } else {
                                event.setCancelled(true);
                                PacketManagerPLib.this.sendServerPacket(viewer, packet);
                            }
                            if (PacketManagerPLib.this.equipment.containsKey(entity.getUniqueId())) {
                                for (PacketContainer eqPacket : (Set)PacketManagerPLib.this.equipment.get(entity.getUniqueId())) {
                                    PacketManagerPLib.this.sendServerPacket(viewer, eqPacket);
                                }
                            }
                        }
                        if (PacketManagerPLib.this.ghosts.contains(entity.getUniqueId()) && entity instanceof Player) {
                            PacketManagerPLib.this.showAsGhost(event.getPlayer(), (Player)entity);
                        }
                        if (PacketManagerPLib.this.hidden.contains(entity.getUniqueId())) {
                            event.setCancelled(true);
                        }
                    }
                } else if (event.getPacketType() == PacketType.Play.Server.ENTITY_METADATA && entity != null) {
                    Player owner;
                    if (PacketManagerPLib.this.metadata.containsKey(entity.getUniqueId()) && entity != viewer) {
                        event.setPacket((PacketContainer)PacketManagerPLib.this.metadata.get(entity.getUniqueId()));
                    }
                    if (PowerTools.isTamed(entity) && ConfigOption.Powers.SHOW_HEARTS_ON_TAMED && entity instanceof LivingEntity && viewer == (owner = PowerTools.getTamedOwner(entity).getPlayer())) {
                        double i = ((LivingEntity)entity).getHealth() / 2.0;
                        double j = ((LivingEntity)entity).getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 2.0;
                        String health = "";
                        int k = 0;
                        while ((double)k < j) {
                            if (i > 0.0) {
                                health = health + ChatColor.RED + "\u2665";
                                i -= 1.0;
                            } else {
                                health = health + ChatColor.GRAY + "\u2665";
                            }
                            ++k;
                        }
                        PacketContainer packet = PacketManagerPLib.this.pm.createPacket(PacketType.Play.Server.ENTITY_METADATA, true);
                        WrappedDataWatcher watcher = WrappedDataWatcher.getEntityWatcher((Entity)entity);
                        watcher.setObject(MCMetadata.EntityMeta.ENTITY_CUSTOM_NAME.getIndex(), WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)true), Optional.of(WrappedChatComponent.fromText((String)health).getHandle()));
                        watcher.setObject(MCMetadata.EntityMeta.ENTITY_IS_CUSTOM_NAME_VISIBLE.getIndex(), WrappedDataWatcher.Registry.get(Boolean.class), (Object)true);
                        packet.getIntegers().write(0, (Object)entity.getEntityId());
                        packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
                        event.setPacket(packet);
                    }
                }
            }

            public void onPacketReceiving(final PacketEvent event) {
                if (event.getPacketType() == PacketType.Play.Client.USE_ENTITY && event.getPlayer().getEntityId() == ((Integer)event.getPacket().getIntegers().read(0)).intValue() && PacketManagerPLib.this.control.containsKey(event.getPlayer().getUniqueId())) {
                    event.setCancelled(true);
                }
                if (event.getPacketType() == PacketType.Play.Client.STEER_VEHICLE && PacketManagerPLib.this.control.containsKey(event.getPlayer().getUniqueId())) {
                    if (((Boolean)event.getPacket().getBooleans().read(1)).booleanValue()) {
                        event.setCancelled(true);
                    }
                    this.plugin.getServer().getScheduler().runTask(this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            Player controller = event.getPlayer();
                            if (PacketManagerPLib.this.control.containsKey(controller.getUniqueId()) && PacketManagerPLib.this.control.get(controller.getUniqueId()) != null) {
                                float forward = 0.0f;
                                if (((Boolean)event.getPacket().getBooleans().read(1)).booleanValue()) {
                                    forward = 1.0f;
                                }
                                LivingEntity entity = (LivingEntity)PacketManagerPLib.this.control.get(controller.getUniqueId());
                                PacketManagerPLib.this.nms.controlWASD(controller, entity, forward, 0.0f, false);
                            }
                        }
                    });
                }
                this.plugin.getServer().getScheduler().runTask(this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Player player;
                        if (event.getPacketType() == PacketType.Play.Client.BLOCK_DIG && event.getPacket().getPlayerDigTypes().read(0) == EnumWrappers.PlayerDigType.DROP_ITEM && (player = event.getPlayer()).isInsideVehicle() && player.getVehicle() instanceof Creature && PacketManagerPLib.this.control.containsKey(player.getUniqueId())) {
                            Creature vehicle = (Creature)player.getVehicle();
                            PacketManagerPLib.this.control.remove(player.getUniqueId());
                            PowerTools.removeControl(player, vehicle);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void addDisguise(Entity entity, EntityType type) {
        this.createEntityPacket(entity, type, null, null);
    }

    @Override
    public void addDisguise(Entity entity, EntityType type, Map<Integer, Object> meta) {
        this.createEntityPacket(entity, type, meta != null ? this.createWrappedDataWatcher(null, meta) : null, null);
    }

    @Override
    public void addDisguise(Entity entity, EntityType type, Map<Integer, Object> meta, Object data) {
        this.createEntityPacket(entity.getEntityId(), entity.getUniqueId(), entity.getLocation(), entity.getVelocity(), type, meta != null ? this.createWrappedDataWatcher(null, meta) : null, data, null);
    }

    private void createEntityPacket(Entity entity, EntityType type, WrappedDataWatcher watcher, Object data) {
        this.createEntityPacket(entity.getEntityId(), entity.getUniqueId(), entity.getLocation(), entity.getVelocity(), type, watcher, data, null);
    }

    private void createEntityPacket(int id, UUID uuid, Location loc, Vector velocity, EntityType type, WrappedDataWatcher watcher, Object data, Player viewer) {
        PacketContainer entityPacket = null;
        PacketContainer metaPacket = null;
        if (type == EntityType.PLAYER) {
            entityPacket = this.pm.createPacket(PacketType.Play.Server.NAMED_ENTITY_SPAWN, true);
            entityPacket.getIntegers().write(0, (Object)id);
            entityPacket.getUUIDs().write(0, (Object)((UUID)data));
            entityPacket.getDoubles().write(0, (Object)loc.getX());
            entityPacket.getDoubles().write(1, (Object)loc.getY());
            entityPacket.getDoubles().write(2, (Object)loc.getZ());
            entityPacket.getBytes().write(0, (Object)((byte)(loc.getYaw() * 256.0f / 360.0f)));
            entityPacket.getBytes().write(1, (Object)((byte)(loc.getPitch() * 256.0f / 360.0f)));
        } else if (type == EntityType.EXPERIENCE_ORB) {
            entityPacket = this.pm.createPacket(PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB, true);
            entityPacket.getIntegers().write(0, (Object)id);
            entityPacket.getDoubles().write(0, (Object)loc.getX());
            entityPacket.getDoubles().write(1, (Object)loc.getY());
            entityPacket.getDoubles().write(2, (Object)loc.getZ());
            entityPacket.getIntegers().write(1, (Object)0);
        } else {
            entityPacket = this.pm.createPacket(PacketType.Play.Server.SPAWN_ENTITY, true);
            entityPacket.getIntegers().write(0, (Object)id);
            entityPacket.getUUIDs().write(0, (Object)uuid);
            entityPacket.getDoubles().write(0, (Object)loc.getX());
            entityPacket.getDoubles().write(1, (Object)loc.getY());
            entityPacket.getDoubles().write(2, (Object)loc.getZ());
            entityPacket.getIntegers().write(1, (Object)velocity.getBlockX());
            entityPacket.getIntegers().write(2, (Object)velocity.getBlockY());
            entityPacket.getIntegers().write(3, (Object)velocity.getBlockZ());
            if (MCVersion.isLessThan(MCVersion.v1_19)) {
                entityPacket.getIntegers().write(4, (Object)((int)(loc.getYaw() * 256.0f / 360.0f)));
                entityPacket.getIntegers().write(5, (Object)((int)(loc.getPitch() * 256.0f / 360.0f)));
                if (data != null && data instanceof Integer) {
                    entityPacket.getIntegers().write(6, (Object)((Integer)data));
                }
            } else {
                entityPacket.getBytes().write(0, (Object)((byte)(loc.getYaw() * 256.0f / 360.0f)));
                entityPacket.getBytes().write(1, (Object)((byte)(loc.getPitch() * 256.0f / 360.0f)));
                entityPacket.getBytes().write(2, (Object)((byte)(loc.getYaw() * 256.0f / 360.0f)));
                if (data != null && data instanceof Integer) {
                    entityPacket.getIntegers().write(4, (Object)((Integer)data));
                }
            }
            entityPacket.getEntityTypeModifier().write(0, (Object)type);
        }
        Entity entity = Bukkit.getEntity((UUID)uuid);
        if (entityPacket != null) {
            if (viewer != null) {
                this.sendServerPacket(viewer, entityPacket);
            }
            if (entity != null) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    PacketContainer infoPacket = this.pm.createPacket(PacketType.Play.Server.PLAYER_INFO);
                    infoPacket.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                    ArrayList<PlayerInfoData> pInfo = new ArrayList<PlayerInfoData>();
                    WrappedGameProfile profile = WrappedGameProfile.fromPlayer((Player)player).withId(Integer.toString(id));
                    EnumWrappers.NativeGameMode mode = EnumWrappers.NativeGameMode.fromBukkit((GameMode)player.getGameMode());
                    WrappedChatComponent name = WrappedChatComponent.fromText((String)player.getDisplayName());
                    pInfo.add(new PlayerInfoData(profile, 0, mode, name));
                    infoPacket.getPlayerInfoDataLists().write(0, pInfo);
                    this.pm.broadcastServerPacket(infoPacket, entity, false);
                }
                this.pm.broadcastServerPacket(entityPacket, entity, false);
            }
            this.disguises.put(uuid, entityPacket);
        }
        if (watcher != null) {
            metaPacket = this.pm.createPacket(PacketType.Play.Server.ENTITY_METADATA, true);
            metaPacket.getIntegers().write(0, (Object)id);
            metaPacket.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
            if (viewer != null) {
                this.sendServerPacket(viewer, metaPacket);
            } else if (entity != null) {
                this.pm.broadcastServerPacket(metaPacket, entity, false);
            }
            this.metadata.put(uuid, metaPacket);
        }
    }

    @Override
    public void addDisguise(Entity entity, ItemStack item) {
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        watcher.setObject(MCMetadata.EntityMeta.THROWABLE_ITEM.getIndex(), WrappedDataWatcher.Registry.getItemStackSerializer((boolean)false), (Object)item, true);
        this.createEntityPacket(entity, EntityType.SNOWBALL, watcher, 1);
    }

    @Override
    public void addDisguise(Entity entity, Entity target) {
        UUID data = null;
        switch (target.getType()) {
            case PAINTING: {
                data = ((Painting)target).getArt();
                break;
            }
            case PLAYER: {
                data = target.getUniqueId();
                break;
            }
        }
        this.createEntityPacket(entity, target.getType(), WrappedDataWatcher.getEntityWatcher((Entity)target), data);
        if (target instanceof LivingEntity) {
            this.addEquipmentDisguise(entity, (LivingEntity)target);
        }
    }

    @Override
    public void addEquipmentDisguise(Entity entity, LivingEntity target) {
        if (this.equipment != null) {
            Set<PacketContainer> eqPackets = this.createEquipmentPackets(entity.getEntityId(), target);
            for (PacketContainer eqPacket : eqPackets) {
                this.pm.broadcastServerPacket(eqPacket, entity, false);
            }
            this.equipment.put(entity.getUniqueId(), eqPackets);
        }
    }

    @Override
    public void addGhost(Player player) {
        if (this.ghosts.add(player.getUniqueId())) {
            this.showAsGhost(player, player);
            for (Player viewer : this.pm.getEntityTrackers((Entity)player)) {
                this.showAsGhost(viewer, player);
            }
            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false, false));
        }
    }

    @Override
    public void addSpectralBlock(Player viewer, Block block, ChatColor color) {
        if (!this.spectralBlocks.containsKey(viewer.getUniqueId())) {
            this.spectralBlocks.put(viewer.getUniqueId(), new HashMap());
        }
        if (((Map)this.spectralBlocks.get(viewer.getUniqueId())).containsKey(block)) {
            this.removeSpectralBlock(viewer, block);
        }
        int id = this.nms.generateEntityID();
        UUID uuid = UUID.randomUUID();
        Location loc = block.getLocation().clone().add(0.5, 0.0, 0.5);
        WrappedDataWatcher watcher = new WrappedDataWatcher();
        watcher.setObject(MCMetadata.EntityMeta.ENTITY_STATE.getIndex(), WrappedDataWatcher.Registry.get(Byte.class), (Object)96);
        watcher.setObject(MCMetadata.EntityMeta.ENTITY_IS_SILENT.getIndex(), WrappedDataWatcher.Registry.get(Boolean.class), (Object)true);
        watcher.setObject(MCMetadata.EntityMeta.ENTITY_NO_GRAVITY.getIndex(), WrappedDataWatcher.Registry.get(Boolean.class), (Object)true);
        watcher.setObject(MCMetadata.EntityMeta.MOB_STATE.getIndex(), WrappedDataWatcher.Registry.get(Byte.class), (Object)1);
        this.createEntityPacket(id, uuid, loc, new Vector(), EntityType.SHULKER, watcher, null, viewer);
        PacketContainer teamPacket = this.pm.createPacket(PacketType.Play.Server.SCOREBOARD_TEAM, true);
        teamPacket.getStrings().write(0, (Object)(viewer.getEntityId() + "." + id));
        teamPacket.getIntegers().write(0, (Object)0);
        if (MCVersion.isLessThan(MCVersion.v1_17)) {
            teamPacket.getIntegers().write(1, (Object)2);
            teamPacket.getEnumModifier(ChatColor.class, MinecraftReflection.getMinecraftClass((String)"EnumChatFormat")).write(0, (Object)color);
            teamPacket.getModifier().write(7, (Object)Lists.newArrayList((Object[])new String[]{viewer.getName(), uuid.toString()}));
        } else {
            Optional optStruct = (Optional)teamPacket.getOptionalStructures().read(0);
            if (optStruct.isPresent()) {
                InternalStructure struct = (InternalStructure)optStruct.get();
                struct.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)""));
                struct.getEnumModifier(ChatColor.class, MinecraftReflection.getMinecraftClass((String)"EnumChatFormat")).write(0, (Object)color);
                teamPacket.getOptionalStructures().write(0, Optional.of(struct));
            }
            teamPacket.getModifier().write(2, (Object)Lists.newArrayList((Object[])new String[]{viewer.getName(), uuid.toString()}));
        }
        this.sendServerPacket(viewer, teamPacket);
        ((Map)this.spectralBlocks.get(viewer.getUniqueId())).put(block, id);
    }

    @Override
    public void addSpectralEntity(Player viewer, Entity entity, ChatColor color) {
        PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.ENTITY_METADATA, true);
        WrappedDataWatcher watcher = WrappedDataWatcher.getEntityWatcher((Entity)entity).deepClone();
        watcher.setObject(MCMetadata.EntityMeta.ENTITY_STATE.getIndex(), WrappedDataWatcher.Registry.get(Byte.class), (Object)((byte)(watcher.getByte(0) + 64)));
        packet.getIntegers().write(0, (Object)entity.getEntityId());
        packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
        this.sendServerPacket(viewer, packet);
        PacketContainer teamPacket = this.pm.createPacket(PacketType.Play.Server.SCOREBOARD_TEAM, true);
        teamPacket.getStrings().write(0, (Object)(viewer.getEntityId() + "." + entity.getEntityId()));
        teamPacket.getIntegers().write(0, (Object)0);
        if (MCVersion.isLessThan(MCVersion.v1_17)) {
            teamPacket.getIntegers().write(1, (Object)2);
            teamPacket.getEnumModifier(ChatColor.class, MinecraftReflection.getMinecraftClass((String)"EnumChatFormat")).write(0, (Object)color);
            teamPacket.getModifier().write(7, (Object)Lists.newArrayList((Object[])new String[]{viewer.getName(), entity.getUniqueId().toString()}));
        } else {
            Optional optStruct = (Optional)teamPacket.getOptionalStructures().read(0);
            if (optStruct != null) {
                InternalStructure struct = (InternalStructure)optStruct.get();
                struct.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)""));
                struct.getEnumModifier(ChatColor.class, MinecraftReflection.getMinecraftClass((String)"EnumChatFormat")).write(0, (Object)color);
                teamPacket.getOptionalStructures().write(0, Optional.of(struct));
            }
            teamPacket.getModifier().write(2, (Object)Lists.newArrayList((Object[])new String[]{viewer.getName(), entity.getUniqueId().toString()}));
        }
        this.sendServerPacket(viewer, teamPacket);
    }

    @Override
    public void blockDisguise(Block block, Material material) {
        BlockPosition bPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.BLOCK_CHANGE, true);
        packet.getBlockPositionModifier().write(0, (Object)bPos);
        packet.getBlockData().write(0, (Object)WrappedBlockData.createData((Material)material));
        this.pm.broadcastServerPacket(packet);
        this.blocks.put(bPos, packet);
    }

    @Override
    public void blockDisguise(Collection<Block> blocks, Material material, BlockData data) {
        if (MCVersion.isLessThan(MCVersion.v1_16_2)) {
            HashMap chunks = new HashMap();
            for (Block block : blocks) {
                this.blockTemporary(block, material);
                if (!chunks.containsKey(block.getChunk())) {
                    chunks.put(block.getChunk(), new ArrayList());
                }
                ((List)chunks.get(block.getChunk())).add(block);
            }
            for (Chunk chunk : chunks.keySet()) {
                PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.MULTI_BLOCK_CHANGE, true);
                Block[] cBlocks = ((List)chunks.get(chunk)).toArray(new Block[((List)chunks.get(chunk)).size()]);
                packet.getChunkCoordIntPairs().write(0, (Object)new ChunkCoordIntPair(chunk.getX(), chunk.getZ()));
                MultiBlockChangeInfo[] changes = new MultiBlockChangeInfo[cBlocks.length];
                for (int i = 0; i < cBlocks.length; ++i) {
                    changes[i] = new MultiBlockChangeInfo(cBlocks[i].getLocation(), WrappedBlockData.createData((Object)data));
                }
                packet.getMultiBlockChangeInfoArrays().write(0, (Object)changes);
                this.pm.broadcastServerPacket(packet);
            }
        } else {
            HashMap bPosMap = new HashMap();
            for (Block block : blocks) {
                this.blockTemporary(block, material);
                int x = block.getX() >> 4;
                int y = block.getY() >> 4;
                int z = block.getZ() >> 4;
                BlockPosition bPos = null;
                for (BlockPosition bPosEntry : bPosMap.keySet()) {
                    if (bPosEntry.getX() != x || bPosEntry.getY() != y || bPosEntry.getZ() != z) continue;
                    bPos = bPosEntry;
                }
                if (bPos == null) {
                    bPos = new BlockPosition(x, y, z);
                    bPosMap.put(bPos, new ArrayList());
                }
                List bList = (List)bPosMap.get(bPos);
                bList.add(block);
            }
            for (BlockPosition bPos : bPosMap.keySet()) {
                PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.MULTI_BLOCK_CHANGE, true);
                packet.getSectionPositions().write(0, (Object)bPos);
                Block[] cBlocks = ((List)bPosMap.get(bPos)).toArray(new Block[((List)bPosMap.get(bPos)).size()]);
                short[] locs = new short[cBlocks.length];
                WrappedBlockData[] bDatas = new WrappedBlockData[cBlocks.length];
                for (int i = 0; i < cBlocks.length; ++i) {
                    int x = cBlocks[i].getX() & 0xF;
                    int y = cBlocks[i].getY() & 0xF;
                    int z = cBlocks[i].getZ() & 0xF;
                    locs[i] = (short)(x << 8 | z << 4 | y << 0);
                    bDatas[i] = WrappedBlockData.createData((Object)data);
                }
                packet.getShortArrays().write(0, (Object)locs);
                packet.getBlockDataArrays().write(0, (Object)bDatas);
                this.pm.broadcastServerPacket(packet);
            }
        }
    }

    private void blockTemporary(Block block, Material material) {
        BlockPosition bPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.BLOCK_CHANGE, true);
        packet.getBlockPositionModifier().write(0, (Object)bPos);
        packet.getBlockData().write(0, (Object)WrappedBlockData.createData((Material)material));
        this.blocks.put(bPos, packet);
    }

    @Override
    public void blockUpdate(Block block) {
        BlockPosition bPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.BLOCK_CHANGE, true);
        packet.getBlockPositionModifier().write(0, (Object)bPos);
        packet.getBlockData().write(0, (Object)WrappedBlockData.createData((Material)block.getType()));
        this.pm.broadcastServerPacket(packet);
        this.blocks.remove(bPos);
    }

    @Override
    public void blockUpdate(Collection<Block> blocks) {
        if (MCVersion.isLessThan(MCVersion.v1_16_2)) {
            HashMap chunks = new HashMap();
            for (Block block : blocks) {
                if (!chunks.containsKey(block.getChunk())) {
                    chunks.put(block.getChunk(), new ArrayList());
                }
                ((List)chunks.get(block.getChunk())).add(block);
            }
            for (Chunk chunk : chunks.keySet()) {
                Block[] cBlocks = ((List)chunks.get(chunk)).toArray(new Block[((List)chunks.get(chunk)).size()]);
                PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.MULTI_BLOCK_CHANGE, true);
                packet.getChunkCoordIntPairs().write(0, (Object)new ChunkCoordIntPair(chunk.getX(), chunk.getZ()));
                MultiBlockChangeInfo[] changes = new MultiBlockChangeInfo[cBlocks.length];
                for (int i = 0; i < cBlocks.length; ++i) {
                    changes[i] = new MultiBlockChangeInfo(cBlocks[i].getLocation(), WrappedBlockData.createData((Material)cBlocks[i].getType()));
                }
                packet.getMultiBlockChangeInfoArrays().write(0, (Object)changes);
                this.pm.broadcastServerPacket(packet);
            }
        } else {
            HashMap bPosMap = new HashMap();
            for (Block block : blocks) {
                int x = block.getX() >> 4;
                int y = block.getY() >> 4;
                int z = block.getZ() >> 4;
                BlockPosition bPos = null;
                for (BlockPosition bPosEntry : bPosMap.keySet()) {
                    if (bPosEntry.getX() != x || bPosEntry.getY() != y || bPosEntry.getZ() != z) continue;
                    bPos = bPosEntry;
                }
                if (bPos == null) {
                    bPos = new BlockPosition(x, y, z);
                    bPosMap.put(bPos, new ArrayList());
                }
                List bList = (List)bPosMap.get(bPos);
                bList.add(block);
            }
            for (BlockPosition bPos : bPosMap.keySet()) {
                PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.MULTI_BLOCK_CHANGE, true);
                packet.getSectionPositions().write(0, (Object)bPos);
                Block[] cBlocks = ((List)bPosMap.get(bPos)).toArray(new Block[((List)bPosMap.get(bPos)).size()]);
                short[] locs = new short[cBlocks.length];
                WrappedBlockData[] bDatas = new WrappedBlockData[cBlocks.length];
                for (int i = 0; i < cBlocks.length; ++i) {
                    int x = cBlocks[i].getX() & 0xF;
                    int y = cBlocks[i].getY() & 0xF;
                    int z = cBlocks[i].getZ() & 0xF;
                    locs[i] = (short)(x << 8 | z << 4 | y << 0);
                    bDatas[i] = WrappedBlockData.createData((Material)cBlocks[i].getType());
                }
                packet.getShortArrays().write(0, (Object)locs);
                packet.getBlockDataArrays().write(0, (Object)bDatas);
                this.pm.broadcastServerPacket(packet);
            }
        }
    }

    private Set<PacketContainer> createEquipmentPackets(int id, LivingEntity entity) {
        Set<PacketContainer> packets = new HashSet<PacketContainer>();
        if (MCVersion.isLessThan(MCVersion.v1_16_1)) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT, true);
                packet.getIntegers().write(0, (Object)id);
                packet.getItemSlots().write(0, (Object)this.getItemSlot(slot));
                packet.getItemModifier().write(0, (Object)PowerTools.getEquipment(entity, slot));
                packets.add(packet);
            }
        } else {
            EntityEquipment equip = entity.getEquipment();
            if (equip != null) {
                PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT, true);
                packet.getIntegers().write(0, (Object)id);
                ArrayList<Pair> slotList = new ArrayList<Pair>();
                slotList.add(new Pair((Object)EnumWrappers.ItemSlot.CHEST, (Object)equip.getChestplate()));
                slotList.add(new Pair((Object)EnumWrappers.ItemSlot.FEET, (Object)equip.getBoots()));
                slotList.add(new Pair((Object)EnumWrappers.ItemSlot.HEAD, (Object)equip.getHelmet()));
                slotList.add(new Pair((Object)EnumWrappers.ItemSlot.LEGS, (Object)equip.getLeggings()));
                slotList.add(new Pair((Object)EnumWrappers.ItemSlot.MAINHAND, (Object)equip.getItemInMainHand()));
                slotList.add(new Pair((Object)EnumWrappers.ItemSlot.OFFHAND, (Object)equip.getItemInOffHand()));
                packet.getSlotStackPairLists().write(0, slotList);
                packets = Set.of(packet);
            }
        }
        return packets;
    }

    private WrappedDataWatcher createWrappedDataWatcher(Entity entity, Map<Integer, Object> map) {
        WrappedDataWatcher watcher = entity != null ? WrappedDataWatcher.getEntityWatcher((Entity)entity) : new WrappedDataWatcher();
        for (Integer i : map.keySet()) {
            if (watcher.hasIndex(i.intValue()) && watcher.getObject(i.intValue()) instanceof Byte) {
                watcher.setObject(i.intValue(), WrappedDataWatcher.Registry.get(Byte.class), (Object)((byte)(watcher.getByte(i.intValue()) + (Byte)map.get(i))), true);
                continue;
            }
            watcher.setObject(i.intValue(), WrappedDataWatcher.Registry.get(map.get(i).getClass()), map.get(i), true);
        }
        return watcher;
    }

    @Override
    public void fakeCollect(Entity entity, Item item) {
        PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.COLLECT);
        packet.getIntegers().write(0, (Object)item.getEntityId());
        packet.getIntegers().write(1, (Object)entity.getEntityId());
        packet.getIntegers().write(2, (Object)item.getItemStack().getAmount());
        this.pm.broadcastServerPacket(packet, entity, true);
    }

    @Override
    public void fakeExplosion(Location loc, float radius) {
        loc.getWorld().playSound(loc, Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
        PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.EXPLOSION);
        packet.getDoubles().write(0, (Object)loc.getX());
        packet.getDoubles().write(1, (Object)loc.getY());
        packet.getDoubles().write(2, (Object)loc.getZ());
        packet.getFloat().write(0, (Object)Float.valueOf(radius));
        packet.getBlockPositionCollectionModifier().writeDefaults();
        packet.getFloat().write(1, (Object)Float.valueOf(0.0f));
        packet.getFloat().write(2, (Object)Float.valueOf(0.0f));
        packet.getFloat().write(3, (Object)Float.valueOf(0.0f));
        this.pm.broadcastServerPacket(packet, loc, this.plugin.getServer().getViewDistance());
    }

    private EnumWrappers.ItemSlot getItemSlot(EquipmentSlot slot) {
        switch (slot) {
            case HAND: {
                return EnumWrappers.ItemSlot.MAINHAND;
            }
            case OFF_HAND: {
                return EnumWrappers.ItemSlot.OFFHAND;
            }
        }
        return EnumWrappers.ItemSlot.valueOf((String)slot.name());
    }

    @Override
    public boolean hasDisguise(Block block) {
        BlockPosition bPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        return this.blocks.containsKey(bPos);
    }

    @Override
    public boolean hasDisguise(Entity entity) {
        return this.disguises.containsKey(entity.getUniqueId());
    }

    @Override
    public void hide(Entity entity) {
        PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.ENTITY_DESTROY, true);
        if (MCVersion.isLessThan(MCVersion.v1_17)) {
            packet.getIntegerArrays().write(0, (Object)new int[]{entity.getEntityId()});
        } else if (MCVersion.isLessThan(MCVersion.v1_17_1)) {
            packet.getIntegers().write(0, (Object)entity.getEntityId());
        } else {
            packet.getIntLists().write(0, (Object)Lists.newArrayList((Object[])new Integer[]{entity.getEntityId()}));
        }
        for (Player player : this.pm.getEntityTrackers(entity)) {
            this.sendServerPacket(player, packet);
        }
        this.hidden.add(entity.getUniqueId());
    }

    @Override
    public void removeDisguise(Entity entity) {
        if (this.disguises.containsKey(entity.getUniqueId()) || this.metadata.containsKey(entity.getUniqueId()) || this.equipment.containsKey(entity.getUniqueId())) {
            this.disguises.remove(entity.getUniqueId());
            this.equipment.remove(entity.getUniqueId());
            this.metadata.remove(entity.getUniqueId());
            this.updateEntity(entity);
        }
    }

    @Override
    public void removeGhost(Player player) {
        if (this.ghosts.remove(player.getUniqueId())) {
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
            for (Player players : this.pm.getEntityTrackers((Entity)player)) {
                PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.SCOREBOARD_TEAM, true);
                packet.getStrings().write(0, (Object)(players.getEntityId() + "." + player.getEntityId()));
                packet.getIntegers().write(0, (Object)1);
                this.sendServerPacket(players, packet);
            }
            this.ghosts.remove(player.getUniqueId());
        }
    }

    @Override
    public void removeSpectralBlock(Player viewer, Block block) {
        Map map;
        if (this.spectralBlocks.containsKey(viewer.getUniqueId()) && (map = (Map)this.spectralBlocks.get(viewer.getUniqueId())).containsKey(block)) {
            int id = (Integer)map.get(block);
            PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.ENTITY_DESTROY, true);
            if (MCVersion.isLessThan(MCVersion.v1_17)) {
                packet.getIntegerArrays().write(0, (Object)new int[]{id});
            } else if (MCVersion.isLessThan(MCVersion.v1_17_1)) {
                packet.getIntegers().write(0, (Object)id);
            } else {
                packet.getIntLists().write(0, (Object)Lists.newArrayList((Object[])new Integer[]{id}));
            }
            this.sendServerPacket(viewer, packet);
            map.remove(block);
        }
    }

    @Override
    public void removeSpectralEntity(Player viewer, Entity entity) {
        PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.ENTITY_METADATA);
        packet.getIntegers().write(0, (Object)entity.getEntityId());
        packet.getWatchableCollectionModifier().write(0, (Object)WrappedDataWatcher.getEntityWatcher((Entity)entity).getWatchableObjects());
        this.sendServerPacket(viewer, packet);
    }

    private void sendServerPacket(Player player, PacketContainer packet) {
        if (player != null && packet != null) {
            this.pm.sendServerPacket(player, packet);
        }
    }

    @Override
    public void setCamera(Player player, Entity entity) {
        PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.CAMERA);
        packet.getIntegers().write(0, (Object)entity.getEntityId());
        this.sendServerPacket(player, packet);
    }

    @Override
    public void setLook(Player player, Location loc) {
        PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.LOOK_AT);
        packet.getEnumModifier(Anchor.class, 4).write(0, (Object)Anchor.EYES);
        packet.getDoubles().write(0, (Object)loc.getX());
        packet.getDoubles().write(1, (Object)loc.getY());
        packet.getDoubles().write(2, (Object)loc.getZ());
        this.sendServerPacket(player, packet);
    }

    @Override
    public void showActionBarMessage(Player player, String message) {
        PacketContainer packet;
        if (MCVersion.isLessThan(MCVersion.v1_17)) {
            packet = this.pm.createPacket(PacketType.Play.Server.CHAT);
            packet.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)message));
            packet.getChatTypes().write(0, (Object)EnumWrappers.ChatType.GAME_INFO);
        } else {
            packet = this.pm.createPacket(PacketType.Play.Server.SET_ACTION_BAR_TEXT);
            packet.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)message));
        }
        this.sendServerPacket(player, packet);
    }

    private void showAsGhost(Player viewer, Player player) {
        PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.SCOREBOARD_TEAM, true);
        packet.getStrings().write(0, (Object)(viewer.getEntityId() + "." + player.getEntityId()));
        packet.getIntegers().write(0, (Object)0);
        if (MCVersion.isLessThan(MCVersion.v1_17)) {
            packet.getStrings().write(1, (Object)"hideForOwnTeam");
            packet.getIntegers().write(1, (Object)2);
            packet.getModifier().write(7, (Object)Lists.newArrayList((Object[])new String[]{viewer.getName(), player.getName()}));
        } else {
            packet.getModifier().write(2, (Object)Lists.newArrayList((Object[])new String[]{viewer.getName(), player.getName()}));
            Optional optStruct = (Optional)packet.getOptionalStructures().read(0);
            if (optStruct.isPresent()) {
                InternalStructure struct = (InternalStructure)optStruct.get();
                struct.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)""));
                struct.getIntegers().write(0, (Object)2);
                struct.getStrings().write(0, (Object)"hideForOwnTeam");
                packet.getOptionalStructures().write(0, Optional.of(struct));
            }
        }
        this.sendServerPacket(viewer, packet);
    }

    @Override
    public void showHearts(LivingEntity entity, Player player) {
        PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.ENTITY_METADATA, true);
        WrappedDataWatcher watcher = WrappedDataWatcher.getEntityWatcher((Entity)entity);
        double i = entity.getHealth() / 2.0;
        double j = entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() / 2.0;
        String health = "";
        int k = 0;
        while ((double)k < j) {
            if (i > 0.0) {
                health = health + ChatColor.RED + "\u2665";
                i -= 1.0;
            } else {
                health = health + ChatColor.GRAY + "\u2665";
            }
            ++k;
        }
        watcher.setObject(MCMetadata.EntityMeta.ENTITY_CUSTOM_NAME.getIndex(), WrappedDataWatcher.Registry.getChatComponentSerializer((boolean)true), Optional.of(WrappedChatComponent.fromText((String)health).getHandle()));
        watcher.setObject(MCMetadata.EntityMeta.ENTITY_IS_CUSTOM_NAME_VISIBLE.getIndex(), WrappedDataWatcher.Registry.get(Boolean.class), (Object)true);
        packet.getIntegers().write(0, (Object)entity.getEntityId());
        packet.getWatchableCollectionModifier().write(0, (Object)watcher.getWatchableObjects());
        this.sendServerPacket(player, packet);
    }

    @Override
    public void showItemCooldown(Player player, ItemStack item, long cooldown) {
        PacketContainer packet = this.pm.createPacket(PacketType.Play.Server.SET_COOLDOWN);
        packet.getModifier().write(0, this.nms.getNMSItem(item));
        packet.getIntegers().write(0, (Object)((int)PowerTime.toTicks(cooldown)));
        this.sendServerPacket(player, packet);
    }

    private void updateEntity(Entity entity) {
        this.updateEntity(entity, false);
    }

    private void updateEntity(Entity entity, boolean sendToEntity) {
        try {
            this.pm.updateEntity(entity, this.pm.getEntityTrackers(entity));
        }
        catch (Exception e) {
            PacketContainer packet1 = null;
            PacketContainer packet2 = null;
            if (entity instanceof Player) {
                packet1 = this.pm.createPacketConstructor(PacketType.Play.Server.NAMED_ENTITY_SPAWN, new Object[]{(Player)entity}).createPacket(new Object[]{entity});
                Player player = (Player)entity;
                packet2 = this.pm.createPacket(PacketType.Play.Server.PLAYER_INFO);
                packet2.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
                ArrayList<PlayerInfoData> pInfo = new ArrayList<PlayerInfoData>();
                WrappedGameProfile profile = WrappedGameProfile.fromPlayer((Player)player).withId(Integer.toString(entity.getEntityId()));
                EnumWrappers.NativeGameMode mode = EnumWrappers.NativeGameMode.fromBukkit((GameMode)player.getGameMode());
                WrappedChatComponent name = WrappedChatComponent.fromText((String)player.getDisplayName());
                pInfo.add(new PlayerInfoData(profile, 0, mode, name));
                packet2.getPlayerInfoDataLists().write(0, pInfo);
            } else {
                packet1 = entity instanceof ExperienceOrb ? this.pm.createPacketConstructor(PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB, new Object[]{(ExperienceOrb)entity}).createPacket(new Object[]{entity}) : this.pm.createPacketConstructor(PacketType.Play.Server.SPAWN_ENTITY, new Object[]{entity}).createPacket(new Object[]{entity});
            }
            PacketContainer packet3 = this.pm.createPacket(PacketType.Play.Server.ENTITY_METADATA);
            packet3.getIntegers().write(0, (Object)entity.getEntityId());
            packet3.getWatchableCollectionModifier().write(0, (Object)WrappedDataWatcher.getEntityWatcher((Entity)entity).getWatchableObjects());
            if (packet2 != null) {
                this.pm.broadcastServerPacket(packet2, entity, sendToEntity);
            }
            this.pm.broadcastServerPacket(packet1, entity, sendToEntity);
            this.pm.broadcastServerPacket(packet3, entity, sendToEntity);
        }
    }

    private static enum Anchor {
        FEET,
        EYES;

    }
}

