/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Predicate;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.config.ConfigOption;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.tools.PacketManaged;
import me.sirrus86.s86powers.tools.nms.NMSLibrary;
import me.sirrus86.s86powers.tools.packets.PacketManager;
import me.sirrus86.s86powers.tools.packets.PacketManagerNull;
import me.sirrus86.s86powers.tools.packets.PacketManagerPLib;
import me.sirrus86.s86powers.tools.version.MCMetadata;
import me.sirrus86.s86powers.tools.version.MCVersion;
import me.sirrus86.s86powers.tools.version.VersionTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public final class PowerTools {
    private static final Map<UUID, UUID> tamed = new HashMap<UUID, UUID>();
    private static final Map<Double, Set<Vector>> auraCoords = new HashMap<Double, Set<Vector>>();
    private static final Map<Integer, Set<Vector>> fibCoords = new HashMap<Integer, Set<Vector>>();
    private static final TreeMap<Integer, String> romanNums = new TreeMap();
    private static final BlockFace[] axis = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    private static final BlockFace[] radial = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    private static final NMSLibrary nms = PowerTools.resolveNMS();
    private static final PacketManager pm = S86Powers.getProtocolLib() != null ? new PacketManagerPLib() : new PacketManagerNull();
    private static final Random random = new Random();
    private static final VersionTools vTools = PowerTools.resolveVTools();
    private static final double phi = Math.PI * (3.0 - Math.sqrt(5.0));

    @PacketManaged
    public static void addDisguise(Entity entity, EntityType type) {
        pm.addDisguise(entity, type);
    }

    @PacketManaged
    public static void addDisguise(Entity entity, EntityType type, MCMetadata meta) {
        pm.addDisguise(entity, type, meta.getMap());
    }

    @PacketManaged
    public static void addDisguise(Entity entity, EntityType type, Map<Integer, Object> meta) {
        pm.addDisguise(entity, type, meta);
    }

    @PacketManaged
    public static void addDisguise(Entity entity, EntityType type, Map<Integer, Object> meta, Object data) {
        pm.addDisguise(entity, type, meta, data);
    }

    @PacketManaged
    public static void addDisguise(Entity entity, ItemStack item) {
        pm.addDisguise(entity, item);
    }

    @PacketManaged
    public static void addDisguise(Entity entity, Entity target) {
        pm.addDisguise(entity, target);
    }

    @PacketManaged
    public static void addEquipmentDisguise(Entity entity, LivingEntity target) {
        pm.addEquipmentDisguise(entity, target);
    }

    @PacketManaged
    public static void addGhost(Player player) {
        pm.addGhost(player);
    }

    @PacketManaged
    public static void addSpectralBlock(Player viewer, Block block, ChatColor color) {
        if (pm != null) {
            pm.addSpectralBlock(viewer, block, color);
        }
    }

    @PacketManaged
    public static void blockDisguise(Block block, Material material) {
        pm.blockDisguise(block, material);
    }

    @PacketManaged
    public static void blockDisguise(Collection<Block> blocks, Material material, BlockData data) {
        pm.blockDisguise(blocks, material, data);
    }

    @PacketManaged
    public static void blockUpdate(Block block) {
        pm.blockUpdate(block);
    }

    @PacketManaged
    public static void blockUpdate(Collection<Block> blocks) {
        pm.blockUpdate(blocks);
    }

    public static String capitalize(String line) {
        if (line != null) {
            return line.length() > 1 ? line.substring(0, 1).toUpperCase() + line.substring(1).toLowerCase() : line.toUpperCase();
        }
        return "";
    }

    public static void copyEquipment(LivingEntity from, LivingEntity to) {
        to.getEquipment().setArmorContents(from.getEquipment().getArmorContents());
        to.getEquipment().setItemInMainHand(from.getEquipment().getItemInMainHand());
        to.getEquipment().setItemInOffHand(from.getEquipment().getItemInOffHand());
    }

    @PacketManaged
    @Deprecated
    public static void createBeam(Location from, Location to) {
        if (from.getWorld() == to.getWorld()) {
            EnderCrystal crystal = (EnderCrystal)from.getWorld().spawn(from, EnderCrystal.class);
            pm.hide((Entity)crystal);
            crystal.setBeamTarget(to);
        }
    }

    public static ItemStack createPowerBook(Power power) {
        ItemStack stack = new ItemStack(Material.ENCHANTED_BOOK, 1);
        ItemMeta meta = stack.hasItemMeta() ? stack.getItemMeta() : Bukkit.getItemFactory().getItemMeta(Material.ENCHANTED_BOOK);
        meta.setDisplayName(ChatColor.RESET.toString() + power.getType().getColor() + power.getName());
        meta.getPersistentDataContainer().set(Power.getCollectorKey(), PersistentDataType.STRING, (Object)power.getClass().getSimpleName());
        String powerDesc = PowerTools.getFilteredText(power, power.getDescription());
        List<String> lore = PowerTools.wordSplit(ChatColor.RESET + ChatColor.GRAY.toString(), powerDesc, 30);
        meta.setLore(lore);
        stack.setItemMeta(meta);
        return stack;
    }

    @PacketManaged
    public static void fakeCollect(Entity entity, Item item) {
        pm.fakeCollect(entity, item);
    }

    @PacketManaged
    public static void fakeExplosion(Location loc, float radius) {
        pm.fakeExplosion(loc, radius);
    }

    public static String getActionString(ItemStack item) {
        if (item.getType() != Material.AIR && (item.getType().isBlock() || item.getType().isEdible() || item.getType().isRecord() || item.getType().isInteractable())) {
            return "left-click";
        }
        return "right-click";
    }

    public static Axis getAxis(BlockFace face) {
        switch (face) {
            case NORTH: 
            case SOUTH: {
                return Axis.X;
            }
            case UP: 
            case DOWN: {
                return Axis.Y;
            }
            case EAST: 
            case WEST: {
                return Axis.Z;
            }
        }
        return null;
    }

    public static Block getClosestBlock(Location loc, Vector vector) {
        Location newLoc = loc.clone();
        while (newLoc.getBlockY() > 0 && newLoc.getBlockY() <= loc.getWorld().getMaxHeight()) {
            if (newLoc.getBlock() != null && newLoc.getBlock().getType().isSolid()) {
                return newLoc.getBlock();
            }
            newLoc.add(vector);
        }
        return null;
    }

    public static BlockFace getDirection(Location loc) {
        return PowerTools.getDirection(loc, true);
    }

    public static BlockFace getDirection(Location loc, boolean useSubCardinalDirections) {
        float yaw = loc.getYaw();
        if (useSubCardinalDirections) {
            return radial[Math.round(yaw / 45.0f) & 7];
        }
        return axis[Math.round(yaw / 90.0f) & 3];
    }

    public static Vector getDirection(Location loc1, Location loc2) {
        if (loc1.getWorld() == loc2.getWorld()) {
            return loc2.toVector().subtract(loc1.toVector()).normalize();
        }
        return null;
    }

    public static LivingEntity getEntitySource(Entity entity) {
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        if (entity instanceof Projectile && ((Projectile)entity).getShooter() instanceof LivingEntity) {
            return (LivingEntity)((Projectile)entity).getShooter();
        }
        if (entity instanceof AreaEffectCloud && ((AreaEffectCloud)entity).getSource() instanceof LivingEntity) {
            return (LivingEntity)((AreaEffectCloud)entity).getSource();
        }
        if (entity instanceof EvokerFangs) {
            return ((EvokerFangs)entity).getOwner();
        }
        return null;
    }

    public static String getEntityType(Entity entity) {
        return entity.getType().name();
    }

    public static ItemStack getEquipment(LivingEntity entity, EquipmentSlot slot) {
        switch (slot) {
            case CHEST: {
                return entity.getEquipment().getChestplate();
            }
            case FEET: {
                return entity.getEquipment().getBoots();
            }
            case HAND: {
                return entity.getEquipment().getItemInMainHand();
            }
            case HEAD: {
                return entity.getEquipment().getHelmet();
            }
            case LEGS: {
                return entity.getEquipment().getLeggings();
            }
            case OFF_HAND: {
                return entity.getEquipment().getItemInOffHand();
            }
        }
        return null;
    }

    public static String getFilteredText(Power power, String text) {
        String tmp = text;
        while (tmp.indexOf("[") != -1 && tmp.indexOf("]") != -1) {
            Object object;
            int i = tmp.indexOf("[");
            int j = tmp.indexOf("]");
            String tag = tmp.substring(i, j + 1);
            String field = tmp.substring(i + 1, j);
            PowerOption<?> option = power.getOptionByName(field);
            if (field.startsWith("act:")) {
                option = power.getOptionByName(field.substring(4));
                object = null;
                object = option != null ? power.getOption(option) : power.getFieldValue(field.substring(4));
                ItemStack item = (ItemStack)object;
                if (item == null) continue;
                tmp = tmp.replace(tag, PowerTools.getActionString(item));
                continue;
            }
            object = null;
            object = option != null ? (Object)power.getOption(option) : power.getFieldValue(field);
            if (object != null) {
                if (object instanceof Boolean) {
                    String endTag = "[/" + field + "]";
                    if (!Boolean.parseBoolean(object.toString())) {
                        tmp = tmp.substring(0, tmp.indexOf(tag)) + tmp.substring(tmp.indexOf(endTag) + endTag.length());
                        continue;
                    }
                    tmp = tmp.replace(tag, "").replace(endTag, "");
                    continue;
                }
                if (object instanceof ItemStack) {
                    tmp = tmp.replace(tag, PowerTools.getItemName((ItemStack)object));
                    continue;
                }
                if (object instanceof Long) {
                    tmp = tmp.replace(tag, PowerTime.asLongString((Long)object));
                    continue;
                }
                tmp = tmp.replace(tag, object.toString());
                continue;
            }
            tmp = tmp.replace(tag, "NULL");
        }
        char[] chars = tmp.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        for (int i = 2; i < chars.length; ++i) {
            if (chars[i - 2] != '.') continue;
            Character.toUpperCase(chars[i]);
        }
        tmp = new String(chars);
        return tmp;
    }

    public static String getFriendlyName(Entity entity) {
        String name = entity.getClass().getSimpleName().replace("Craft", "");
        if (entity instanceof Player) {
            name = ((Player)entity).getDisplayName();
        } else if (entity.getCustomName() != null) {
            name = entity.getCustomName();
        }
        return name;
    }

    public static Block getHighestAirBlock(Location loc, int range) {
        Location newLoc = loc.clone();
        newLoc = loc.clone();
        while (newLoc.distanceSquared(loc) < (double)(range * range)) {
            if (!newLoc.getBlock().getType().isSolid() && newLoc.getBlock().getRelative(BlockFace.UP).getType().isSolid()) {
                return newLoc.getBlock();
            }
            newLoc.add(0.0, 1.0, 0.0);
        }
        return newLoc.getBlock();
    }

    public static String getItemName(ItemStack item) {
        ItemMeta meta = item.hasItemMeta() ? item.getItemMeta() : Bukkit.getServer().getItemFactory().getItemMeta(item.getType());
        return WordUtils.capitalize((String)(meta.hasLocalizedName() ? meta.getLocalizedName() : item.getType().toString().replace('_', ' ').toLowerCase()));
    }

    public static Set<Block> getNearbyBlocks(Block block, BlockFace ... faces) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (BlockFace face : faces) {
            blocks.add(block.getRelative(face));
        }
        return blocks;
    }

    public static Set<Block> getNearbyBlocks(Location loc, double radius) {
        return PowerTools.getNearbyBlocks(loc, radius, EnumSet.allOf(Material.class));
    }

    public static Set<Block> getNearbyBlocks(Location loc, double radius, Collection<Material> materials) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (double x = -radius; x < radius; x += 1.0) {
            for (double y = -radius; y < radius; y += 1.0) {
                for (double z = -radius; z < radius; z += 1.0) {
                    loc.add(x, y, z);
                    Block block = loc.getWorld().getBlockAt(loc);
                    loc.subtract(x, y, z);
                    if (!(loc.distanceSquared(block.getLocation()) <= radius * radius) || !materials.contains(block.getType())) continue;
                    blocks.add(block);
                }
            }
        }
        return blocks;
    }

    public static <E extends Entity> Set<E> getNearbyEntities(Class<E> clazz, Location loc, double radius) {
        return PowerTools.getNearbyEntities(clazz, loc, radius, null);
    }

    public static <E extends Entity> Set<E> getNearbyEntities(Class<E> clazz, Location loc, double radius, Entity ignore) {
        HashSet<Entity> tmp = new HashSet<Entity>();
        int cRad = radius < 16.0 ? 1 : (int)((radius - radius % 16.0) / 16.0);
        for (int x = -cRad; x < cRad; ++x) {
            for (int z = -cRad; z < cRad; ++z) {
                for (Entity entity : new Location(loc.getWorld(), loc.getX() + (double)(x * 16), loc.getY(), loc.getZ() + (double)(z * 16)).getChunk().getEntities()) {
                    if (!(entity.getLocation().distanceSquared(loc) <= radius * radius) || !clazz.isInstance(entity) || entity == ignore) continue;
                    tmp.add(entity);
                }
            }
        }
        return tmp;
    }

    public static Set<Material> getNearbyMaterials(Block block, BlockFace ... faces) {
        HashSet<Material> mats = new HashSet<Material>();
        for (BlockFace face : faces) {
            mats.add(block.getRelative(face).getType());
        }
        return mats;
    }

    public static final NMSLibrary getNMSLibrary() {
        return nms != null ? nms : PowerTools.resolveNMS();
    }

    public static final PotionEffect getPotionEffect(PotionData data) {
        PotionEffectType type = data.getType().getEffectType();
        int amp = data.isUpgraded() ? 1 : 0;
        int dur = 0;
        switch (data.getType()) {
            case FIRE_RESISTANCE: 
            case INVISIBILITY: 
            case JUMP: 
            case NIGHT_VISION: 
            case SPEED: 
            case STRENGTH: 
            case WATER_BREATHING: {
                dur = data.isExtended() ? PowerTime.toTicks(8, 0, 0) : (data.isUpgraded() ? PowerTime.toTicks(1, 30, 0) : PowerTime.toTicks(3, 0, 0));
                break;
            }
            case POISON: 
            case REGEN: {
                dur = data.isExtended() ? PowerTime.toTicks(1, 30, 0) : (data.isUpgraded() ? PowerTime.toTicks(22, 0) : PowerTime.toTicks(45, 0));
                break;
            }
            case SLOW_FALLING: 
            case SLOWNESS: 
            case WEAKNESS: {
                dur = data.isExtended() ? PowerTime.toTicks(4, 0, 0) : (data.isUpgraded() ? PowerTime.toTicks(20, 0) : PowerTime.toTicks(1, 30, 0));
                break;
            }
            case TURTLE_MASTER: {
                dur = data.isExtended() ? PowerTime.toTicks(40, 0) : PowerTime.toTicks(20, 0);
                break;
            }
        }
        return new PotionEffect(type, dur, amp);
    }

    public static final String getPotionEffectName(PotionEffectType type) {
        return WordUtils.capitalizeFully((String)type.getName().replace("_", " "));
    }

    public static final PotionEffectType getPotionEffectType(String type) {
        switch (type) {
            case "slowness": {
                return PotionEffectType.SLOW;
            }
            case "haste": {
                return PotionEffectType.FAST_DIGGING;
            }
            case "mining_fatigue": {
                return PotionEffectType.SLOW_DIGGING;
            }
            case "strength": {
                return PotionEffectType.INCREASE_DAMAGE;
            }
            case "instant_health": {
                return PotionEffectType.HEAL;
            }
            case "instant_damage": {
                return PotionEffectType.HARM;
            }
            case "jump_boost": {
                return PotionEffectType.JUMP;
            }
            case "nausea": {
                return PotionEffectType.CONFUSION;
            }
            case "resistance": {
                return PotionEffectType.DAMAGE_RESISTANCE;
            }
        }
        return PotionEffectType.getByName((String)type.toUpperCase());
    }

    public static LivingEntity getRandomEntity(Entity entity, double radius, LivingEntity ... ignore) {
        return PowerTools.getRandomEntity(entity, radius, ignore != null ? Sets.newHashSet((Object[])ignore) : null);
    }

    public static LivingEntity getRandomEntity(Entity entity, double radius, Set<LivingEntity> ignore) {
        List eList = entity.getNearbyEntities(radius, radius, radius);
        Collections.shuffle(eList);
        for (int i = 0; i < eList.size(); ++i) {
            if (!(eList.get(i) instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)eList.get(i);
            if (ignore != null && ignore.contains(target)) continue;
            return target;
        }
        return null;
    }

    public static String getRomanNumeral(int number) {
        int i;
        if (romanNums.isEmpty()) {
            romanNums.put(1000, "M");
            romanNums.put(900, "CM");
            romanNums.put(500, "D");
            romanNums.put(400, "CD");
            romanNums.put(100, "C");
            romanNums.put(90, "XC");
            romanNums.put(50, "L");
            romanNums.put(40, "XL");
            romanNums.put(10, "X");
            romanNums.put(9, "IX");
            romanNums.put(5, "V");
            romanNums.put(4, "IV");
            romanNums.put(1, "I");
        }
        if (number == (i = romanNums.floorKey(number).intValue())) {
            return romanNums.get(number);
        }
        return romanNums.get(i) + PowerTools.getRomanNumeral(number - i);
    }

    public static Material getSpawnEgg(EntityType type) {
        return Material.getMaterial((String)(type.toString() + "_SPAWN_EGG"));
    }

    private static Set<Vector> getFibCoords(int samples) {
        if (!fibCoords.containsKey(samples) || fibCoords.get(samples) == null || fibCoords.get(samples).isEmpty()) {
            HashSet<Vector> coords = new HashSet<Vector>();
            for (int i = 1; i < samples; ++i) {
                float y = 1 - i / (samples - 1) * 2;
                double rad = Math.sqrt(1.0f - y * y);
                double theta = phi * (double)i;
                double x = Math.cos(theta) * rad;
                double z = Math.sin(theta) * rad;
                coords.add(new Vector(x, (double)y, z));
            }
            fibCoords.put(samples, coords);
        }
        return fibCoords.get(samples);
    }

    public static Set<Vector> getSphereCoords(double radius) {
        if (!auraCoords.containsKey(radius) || auraCoords.get(radius) == null || auraCoords.get(radius).isEmpty()) {
            HashSet<Vector> coords = new HashSet<Vector>();
            for (double phi = 0.0; phi <= Math.PI; phi += Math.PI / (radius * 2.0)) {
                double rad = Math.sin(phi) * radius;
                double y = Math.cos(phi) * radius;
                for (double theta = 0.0; theta < Math.PI * 2; theta += Math.PI / Math.abs(rad)) {
                    double x = Math.cos(theta) * rad;
                    double z = Math.sin(theta) * rad;
                    coords.add(new Vector(x, y, z));
                }
            }
            auraCoords.put(radius, coords);
        }
        return auraCoords.get(radius);
    }

    public static Set<Vector> getSphereCoords(int samples, double radius) {
        Set<Vector> coords = PowerTools.getFibCoords(samples);
        HashSet<Vector> newCoords = new HashSet<Vector>();
        for (Vector coord : coords) {
            newCoords.add(new Vector(coord.getX() * radius, coord.getY() * radius, coord.getZ() * radius));
        }
        return newCoords;
    }

    public static PowerUser getTamedOwner(Entity entity) {
        return tamed.containsKey(entity.getUniqueId()) ? S86Powers.getConfigManager().getUser(tamed.get(entity.getUniqueId())) : null;
    }

    public static <T extends Entity> T getTargetEntity(Class<T> clazz, Location location, Vector direction, double maxDistance, Predicate<Entity> filter) {
        return vTools.getTargetEntity(clazz, location, direction, maxDistance, filter);
    }

    @PacketManaged
    public static boolean hasDisguise(Block block) {
        return pm.hasDisguise(block);
    }

    @PacketManaged
    public static boolean hasDisguise(Entity entity) {
        return pm.hasDisguise(entity);
    }

    public static boolean hasDurability(ItemStack item) {
        return PowerTools.isSword(item) || PowerTools.isTool(item);
    }

    @PacketManaged
    public static void hide(Entity entity) {
        pm.hide(entity);
    }

    public static boolean inSunlight(Location loc) {
        return loc.getBlock().getLightFromSky() == 15 && loc.getBlock().getLightLevel() > loc.getBlock().getLightFromBlocks() && loc.getBlock().getLightLevel() > 10;
    }

    public static final boolean isArmor(ItemStack item) {
        return PowerTools.isBoots(item) || PowerTools.isChestplate(item) || PowerTools.isHelmet(item) || PowerTools.isLeggings(item);
    }

    public static final boolean isAxe(ItemStack item) {
        return item != null && item.getType().name().endsWith("_AXE");
    }

    public static final boolean isBoots(ItemStack item) {
        return item != null && item.getType().name().endsWith("_BOOTS");
    }

    public static final boolean isChestplate(ItemStack item) {
        return item != null && item.getType().name().endsWith("_CHESTPLATE");
    }

    @PacketManaged
    public static boolean isGhost(Player player) {
        return pm.isGhost(player);
    }

    public static final boolean isHelmet(ItemStack item) {
        return item != null && item.getType().name().endsWith("_HELMET");
    }

    public static final boolean isHoe(ItemStack item) {
        return item != null && item.getType().name().endsWith("_HOE");
    }

    public static final boolean isLeggings(ItemStack item) {
        return item != null && item.getType().name().endsWith("_LEGGINGS");
    }

    public static boolean isOutside(Location loc) {
        return loc.getBlockY() > loc.getWorld().getHighestBlockYAt(loc);
    }

    public static final boolean isPickaxe(ItemStack item) {
        return item != null && item.getType().name().endsWith("_PICKAXE");
    }

    public static final boolean isPotion(ItemStack item) {
        return item.getType().name().contains("POTION") && item.hasItemMeta() && item.getItemMeta() instanceof PotionMeta;
    }

    public static final boolean isProjectile(ItemStack item) {
        return item.getType() == Material.ENDER_PEARL || item.getType() == Material.EGG || item.getType() == Material.SNOWBALL;
    }

    public static final boolean isShovel(ItemStack item) {
        return item != null && item.getType().name().endsWith("_SPADE");
    }

    public static final boolean isSword(ItemStack item) {
        return item != null && item.getType().name().endsWith("_SWORD");
    }

    public static boolean isTamed(Entity entity) {
        return tamed.containsKey(entity.getUniqueId());
    }

    public static final boolean isTool(ItemStack item) {
        return item != null && (item.getType() == Material.BOW || item.getType() == Material.FISHING_ROD || item.getType() == Material.FLINT_AND_STEEL || item.getType() == Material.SHEARS || PowerTools.isAxe(item) || PowerTools.isHoe(item) || PowerTools.isPickaxe(item) || PowerTools.isShovel(item));
    }

    public static void playParticleEffect(Location loc, Particle particle) {
        PowerTools.playParticleEffect(loc, particle, random.nextInt(6));
    }

    public static void playParticleEffect(Location loc, Particle particle, int count) {
        PowerTools.playParticleEffect(loc, particle, Vector.getRandom(), count);
    }

    public static void playParticleEffect(Location loc, Particle particle, Vector offset, int count) {
        loc.getWorld().spawnParticle(particle, loc.getX(), loc.getY(), loc.getZ(), count, offset.getX(), offset.getY(), offset.getZ());
    }

    public static void playRedstoneEffect(Location loc, Vector offset, int count, Particle.DustOptions dustOptions) {
        loc.getWorld().spawnParticle(Particle.REDSTONE, loc.getX(), loc.getY(), loc.getZ(), count, offset.getX(), offset.getY(), offset.getZ(), 1.0, (Object)dustOptions);
    }

    public static void removeControl(Player player, Creature creature) {
        creature.eject();
        nms.unTame(creature);
        PowerTools.setCamera(player, (Entity)player);
    }

    @PacketManaged
    public static void removeDisguise(Entity entity) {
        pm.removeDisguise(entity);
    }

    @PacketManaged
    public static void removeGhost(Player player) {
        pm.removeGhost(player);
    }

    @PacketManaged
    public static void removeSpectralBlock(Player player, Block block) {
        if (pm != null) {
            pm.removeSpectralBlock(player, block);
        }
    }

    public static EntityType resolveEntityType(String name) {
        return vTools.resolveEntityType(name);
    }

    public static EntityType resolveEntityTypeByName(String typeString) {
        for (EntityType type : EntityType.values()) {
            if (!type.getName().equalsIgnoreCase(typeString)) continue;
            return type;
        }
        return null;
    }

    private static NMSLibrary resolveNMS() {
        try {
            return nms != null ? nms : (NMSLibrary)Class.forName("me.sirrus86.s86powers.tools.nms." + MCVersion.CURRENT_VERSION.getPath() + ".NMSLibrary").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static VersionTools resolveVTools() {
        if (vTools == null) {
            try {
                switch (MCVersion.CURRENT_VERSION) {
                    case v1_13: 
                    case v1_13_1: 
                    case v1_13_2: {
                        return (VersionTools)Class.forName("me.sirrus86.s86powers.tools.version.v1_13.VersionTools").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    case v1_14: 
                    case v1_14_1: 
                    case v1_14_2: 
                    case v1_14_3: 
                    case v1_14_4: 
                    case v1_15: 
                    case v1_15_1: 
                    case v1_15_2: {
                        return (VersionTools)Class.forName("me.sirrus86.s86powers.tools.version.v1_14.VersionTools").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                }
                return (VersionTools)Class.forName("me.sirrus86.s86powers.tools.version.v1_16.VersionTools").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return vTools;
    }

    @PacketManaged
    public static void setCamera(Player player, Entity entity) {
        pm.setCamera(player, entity);
    }

    @PacketManaged
    public static void setControlling(Player player, LivingEntity entity) {
        pm.setControlling(player, entity);
    }

    public static void setDirection(Fireball entity, Vector dir) {
        nms.setDirection(entity, dir);
    }

    public static ItemStack setItemGlow(ItemStack item) {
        return nms.setItemGlow(item);
    }

    @PacketManaged
    public static void setLook(Player player, Location loc) {
        pm.setLook(player, loc);
    }

    public static void setRotation(Entity entity, float yaw, float pitch) {
        nms.setRotation(entity, yaw, pitch);
    }

    @PacketManaged
    public static void setTamed(Creature entity, PowerUser owner) {
        if (owner != null) {
            nms.setTamed(entity, owner.getPlayer());
            tamed.put(entity.getUniqueId(), owner.getUUID());
            if (ConfigOption.Powers.SHOW_HEARTS_ON_TAMED) {
                pm.showHearts((LivingEntity)entity, owner.getPlayer());
            }
        } else {
            nms.unTame(entity);
            if (tamed.containsKey(entity.getUniqueId())) {
                tamed.remove(entity.getUniqueId());
            }
        }
    }

    @PacketManaged
    public static void showActionBarMessage(Player player, String message) {
        pm.showActionBarMessage(player, message);
    }

    @PacketManaged
    public static void showAsSpectral(Player player, Entity entity, ChatColor color, boolean spectral) {
        if (spectral) {
            pm.addSpectralEntity(player, entity, color);
        } else {
            pm.removeSpectralEntity(player, entity);
        }
    }

    @PacketManaged
    public static void showItemCooldown(Player player, ItemStack item, long cooldown) {
        pm.showItemCooldown(player, item, cooldown);
    }

    public static void spawnEntity(Entity entity, Location loc) {
        nms.spawnEntity(entity, loc);
    }

    public static void takeControl(Player player, Creature creature) {
        creature.addPassenger((Entity)player);
        nms.removePathfinding(creature);
        PowerTools.setControlling(player, (LivingEntity)creature);
        PowerTools.setCamera(player, (Entity)creature);
    }

    public static final boolean usesDurability(ItemStack item) {
        return item != null && (item.getType() == Material.BOW || PowerTools.isArmor(item) || PowerTools.isSword(item) || PowerTools.isTool(item));
    }

    public static List<String> wordSplit(String text, int wrapLength) {
        return PowerTools.wordSplit("", text, wrapLength);
    }

    public static List<String> wordSplit(String prefix, String text, int wrapLength) {
        String wrapped = PowerTools.wordWrap(text, wrapLength);
        Object[] split = wrapped.split("\n");
        for (int i = 0; i < split.length; ++i) {
            split[i] = prefix + (String)split[i];
        }
        return Lists.newArrayList((Object[])split);
    }

    public static String wordWrap(String text, int wrapLength) {
        return WordUtils.wrap((String)text, (int)wrapLength, (String)"\n", (boolean)false);
    }
}

