/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.regions;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.sirrus86.s86powers.S86Powers;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class NeutralRegion
implements Comparable<NeutralRegion>,
ConfigurationSerializable,
Listener {
    private static final S86Powers plugin = (S86Powers)JavaPlugin.getPlugin(S86Powers.class);
    private Vector vec1 = new Vector(0, 0, 0);
    private Vector vec2 = new Vector(0, 0, 0);
    private String name;
    private boolean active = false;
    private final World world;

    public NeutralRegion(String name, World world) {
        this.name = name;
        this.world = world;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public NeutralRegion(Map<String, Object> args) {
        this.name = (String)args.get("name");
        this.active = (Boolean)args.get("neutral");
        this.world = plugin.getServer().getWorld(UUID.fromString((String)args.get("world")));
        this.vec1 = (Vector)args.get("vector-1");
        this.vec2 = (Vector)args.get("vector-2");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public int compareTo(NeutralRegion o) {
        String o1Str = this.getName();
        String o2Str = o.getName();
        List<String> tmp = Arrays.asList(o1Str, o2Str);
        Collections.sort(tmp);
        return tmp.get(0).equalsIgnoreCase(this.getName()) ? -1 : 1;
    }

    public void deactivate() {
        HandlerList.unregisterAll((Listener)this);
        this.vec1 = new Vector(0, 0, 0);
        this.vec2 = new Vector(0, 0, 0);
        this.name = null;
    }

    public Vector getMaxCoords() {
        return Vector.getMaximum((Vector)this.vec1, (Vector)this.vec2);
    }

    public Vector getMinCoords() {
        return Vector.getMinimum((Vector)this.vec1, (Vector)this.vec2);
    }

    public String getName() {
        return this.name;
    }

    public final World getWorld() {
        return this.world;
    }

    public boolean isActive() {
        return this.active;
    }

    private boolean isInside(Location loc) {
        return loc.getX() > this.getMinCoords().getX() && loc.getX() < this.getMaxCoords().getX() && loc.getY() > this.getMinCoords().getY() && loc.getY() < this.getMaxCoords().getY() && loc.getZ() > this.getMinCoords().getZ() && loc.getZ() < this.getMaxCoords().getZ();
    }

    @EventHandler(ignoreCancelled=true)
    private void onMove(PlayerMoveEvent event) {
        PowerUser user = S86Powers.getConfigManager().getUser(event.getPlayer().getUniqueId());
        if (event.getPlayer().getWorld() == this.world && this.isInside(event.getPlayer().getLocation().clone().add(0.5, 0.0, 0.5)) && this.active) {
            user.addRegion(this);
        } else {
            user.removeRegion(this);
        }
    }

    public void resize(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.vec1.setX(x1).setY(y1).setZ(z1);
        this.vec2.setX(x2).setY(y2).setZ(z2);
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("neutral", this.active);
        map.put("world", this.world.getUID().toString());
        map.put("vector-1", this.vec1.clone());
        map.put("vector-2", this.vec2.clone());
        return map;
    }

    public void setNeutral(boolean neutral) {
        this.active = neutral;
    }
}

