/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.utility;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

@PowerManifest(name="Neutralizer Beacon", type=PowerType.UTILITY, author="sirrus86", concept="sirrus86", icon=Material.LAPIS_BLOCK, description="Neutralizer beacons can be created by applying a redstone current to a Lapis Lazuli block. While active, all players who come within up to [radius] meters of the beacon are unable to use powers.")
public class NeutralizerBeacon
extends Power {
    private final Set<BlockFace> adjacent = EnumSet.of(BlockFace.DOWN, new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.SELF, BlockFace.SOUTH, BlockFace.UP, BlockFace.WEST});
    private Map<Block, Beacon> beacons;
    private PowerOption<Long> auraBlinkFrq;
    private PowerOption<Integer> auraFreq;
    private PowerOption<Boolean> canExclude;
    private PowerOption<Boolean> showAura;
    private PowerOption<Double> radius;

    @Override
    protected void onEnable() {
        this.beacons = new HashMap<Block, Beacon>();
    }

    @Override
    protected void onDisable() {
        this.getConfig().createSection("beacons");
        for (Block block : this.beacons.keySet()) {
            this.getConfig().getConfigurationSection("beacons").set(block.getWorld().getName() + "," + block.getX() + "," + block.getY() + "," + block.getZ(), (Object)true);
        }
        this.saveConfig();
    }

    @Override
    protected void config() {
        this.auraBlinkFrq = this.option("aura-blink-frequency", 2L, "How often aura particles are refreshed.");
        this.auraFreq = this.option("aura-particle-density", 2, "Density of how many particles are shown. Higher numbers create less density.");
        this.canExclude = this.option("can-exclude", true, "Allows player names on adjacent signs to be excluded from beacon effects.");
        this.radius = this.option("radius", 50.0, "Maximum radius of the neutralizing field from the beacon.");
        this.showAura = this.option("show-aura", false, "Whether to show the aura of an active beacon.");
        this.loadBeacons();
    }

    private void loadBeacons() {
        if (this.getConfig().contains("beacons")) {
            for (String bLoc : this.getConfig().getConfigurationSection("beacons").getKeys(false)) {
                String[] coords = bLoc.split(",");
                Block lapis = Bukkit.getWorld((String)coords[0]).getBlockAt(Integer.parseInt(coords[1]), Integer.parseInt(coords[2]), Integer.parseInt(coords[3]));
                Beacon beacon = new Beacon(lapis);
                this.beacons.put(lapis, beacon);
                beacon.update();
            }
        }
    }

    private BukkitRunnable checkForBeacon(final Block lapis) {
        return new BukkitRunnable(){

            public void run() {
                if (lapis.getBlockPower() > 0) {
                    if (!NeutralizerBeacon.this.beacons.containsKey(lapis)) {
                        NeutralizerBeacon.this.beacons.put(lapis, new Beacon(lapis));
                    }
                    Beacon beacon = (Beacon)NeutralizerBeacon.this.beacons.get(lapis);
                    beacon.update();
                } else if (NeutralizerBeacon.this.beacons.containsKey(lapis)) {
                    Beacon beacon = (Beacon)NeutralizerBeacon.this.beacons.get(lapis);
                    NeutralizerBeacon.this.beacons.remove(lapis);
                    beacon.terminate();
                }
            }
        };
    }

    @EventHandler(ignoreCancelled=true)
    private void onBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        for (BlockFace face : BlockFace.values()) {
            Block nearby = block.getRelative(face);
            if (nearby.getType() != Material.LAPIS_BLOCK) continue;
            this.runTask((Runnable)this.checkForBeacon(nearby));
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onPhysics(BlockPhysicsEvent event) {
        Block block = event.getBlock();
        for (BlockFace face : this.adjacent) {
            Block nearby = block.getRelative(face);
            if (nearby.getType() != Material.LAPIS_BLOCK) continue;
            this.runTask((Runnable)this.checkForBeacon(nearby));
        }
    }

    @EventHandler
    private void onPower(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        for (BlockFace face : this.adjacent) {
            Block nearby = block.getRelative(face);
            if (nearby.getType() != Material.LAPIS_BLOCK) continue;
            this.runTask((Runnable)this.checkForBeacon(nearby));
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onPlace(BlockPlaceEvent event) {
        Block block = event.getBlock();
        for (BlockFace face : this.adjacent) {
            Block nearby = block.getRelative(face);
            if (nearby.getType() != Material.LAPIS_BLOCK) continue;
            this.runTask((Runnable)this.checkForBeacon(nearby));
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onInteract(PlayerInteractEvent event) {
        if (event.hasBlock()) {
            Block block = event.getClickedBlock();
            for (BlockFace face : this.adjacent) {
                Block nearby = block.getRelative(face);
                if (nearby.getType() != Material.LAPIS_BLOCK) continue;
                this.runTask((Runnable)this.checkForBeacon(nearby));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onSignChange(SignChangeEvent event) {
        Block block = event.getBlock();
        for (BlockFace face : this.adjacent) {
            Block nearby = block.getRelative(face);
            if (nearby.getType() != Material.LAPIS_BLOCK) continue;
            this.runTask((Runnable)this.checkForBeacon(nearby));
        }
    }

    public class Beacon
    implements Listener {
        private Set<Vector> auraCoords;
        private int auraTask = -1;
        private int auraBlink = 0;
        private List<String> excluded = new ArrayList<String>();
        private final Block lapis;
        private double range;
        private Runnable aura = new BukkitRunnable(){

            public void run() {
                Location loc = Beacon.this.lapis.getLocation().clone().add(0.5, 0.5, 0.5);
                for (Vector vec : Beacon.this.auraCoords) {
                    Beacon.this.auraBlink++;
                    if (Beacon.this.auraBlink <= (Integer)NeutralizerBeacon.this.getOption(NeutralizerBeacon.this.auraFreq)) continue;
                    loc.add(vec);
                    loc.getWorld().spawnParticle(Particle.REDSTONE, loc, 1, (Object)new Particle.DustOptions(Color.BLUE, 0.75f));
                    loc.subtract(vec);
                    Beacon.this.auraBlink = 0;
                }
            }
        };

        public Beacon(Block lapis) {
            this.lapis = lapis;
            NeutralizerBeacon.this.registerEvents(this);
        }

        public final Block getBlock() {
            return this.lapis;
        }

        @EventHandler(ignoreCancelled=true)
        private void onMove(PlayerMoveEvent event) {
            if (event.getTo().getWorld() == event.getFrom().getWorld() && event.getTo().distanceSquared(event.getFrom()) > 0.0) {
                PowerUser user = NeutralizerBeacon.this.getUser((OfflinePlayer)event.getPlayer());
                if (event.getTo().getWorld() != this.lapis.getWorld()) {
                    user.removeBeacon(this);
                } else if (this.lapis.getLocation().clone().add(0.5, 0.5, 0.5).distanceSquared(event.getTo()) < this.range * this.range && !this.excluded.contains(user.getName())) {
                    user.addBeacon(this);
                } else if (this.lapis.getLocation().clone().add(0.5, 0.5, 0.5).distanceSquared(event.getTo()) >= this.range * this.range || this.excluded.contains(user.getName())) {
                    user.removeBeacon(this);
                }
            }
        }

        public void terminate() {
            if (this.auraTask > -1) {
                NeutralizerBeacon.this.cancelTask(this.auraTask);
            }
            for (Player player : PowerTools.getNearbyEntities(Player.class, this.lapis.getLocation(), this.range)) {
                PowerUser user = NeutralizerBeacon.this.getUser((OfflinePlayer)player);
                user.removeBeacon(this);
            }
            NeutralizerBeacon.this.unregisterEvents(this);
            NeutralizerBeacon.this.getConfig().set("beacons." + this.lapis.getWorld().getName() + "," + this.lapis.getX() + "," + this.lapis.getY() + "," + this.lapis.getZ(), null);
            NeutralizerBeacon.this.saveConfig();
        }

        public void update() {
            double oldRange = this.range;
            if (this.lapis.getType() != Material.LAPIS_BLOCK || this.lapis.getBlockPower() <= 0) {
                this.terminate();
                return;
            }
            double strength = (double)this.lapis.getBlockPower() / 15.0;
            this.range = (Double)NeutralizerBeacon.this.getInstance().getOption(NeutralizerBeacon.this.radius) * strength;
            this.auraCoords = PowerTools.getSphereCoords(this.range);
            if (((Boolean)NeutralizerBeacon.this.getInstance().getOption(NeutralizerBeacon.this.showAura)).booleanValue()) {
                if (oldRange != this.range && this.auraTask > -1) {
                    NeutralizerBeacon.this.cancelTask(this.auraTask);
                    this.auraTask = -1;
                }
                if (this.auraTask <= -1) {
                    this.auraTask = NeutralizerBeacon.this.runTaskTimer(this.aura, 0L, (Long)NeutralizerBeacon.this.getInstance().getOption(NeutralizerBeacon.this.auraBlinkFrq)).getTaskId();
                }
            } else if (this.auraTask > -1) {
                NeutralizerBeacon.this.cancelTask(this.auraTask);
            }
            this.excluded.clear();
            if (((Boolean)NeutralizerBeacon.this.getInstance().getOption(NeutralizerBeacon.this.canExclude)).booleanValue()) {
                for (BlockFace face : NeutralizerBeacon.this.adjacent) {
                    if (!(this.lapis.getRelative(face).getState() instanceof Sign)) continue;
                    Sign sign = (Sign)this.lapis.getRelative(face).getState();
                    for (String line : sign.getLines()) {
                        this.excluded.add(line);
                    }
                }
            }
            for (Player player : PowerTools.getNearbyEntities(Player.class, this.lapis.getLocation(), this.range)) {
                PowerUser user = NeutralizerBeacon.this.getUser((OfflinePlayer)player);
                if (this.excluded.contains(user.getName())) {
                    user.removeBeacon(this);
                    continue;
                }
                user.addBeacon(this);
            }
        }
    }
}

