/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.passive;

import java.util.HashSet;
import java.util.Set;
import me.sirrus86.s86powers.events.UserMaxedStatEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.tools.version.MCMetadata;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Vampirism", type=PowerType.PASSIVE, author="sirrus86", concept="TheClownOfCrime", icon=Material.FERMENTED_SPIDER_EYE, usesPackets=true, description="You rapidly lose hunger while in direct sunlight, eventually igniting you[helmet-prevents-ignition] unless you are wearing a helmet[/helmet-prevents-ignition]. While sprinting, running speed and jump height increase. Immune to fall damage. Wooden tools do [wood-damage-multiplier]x more damage to you.")
public final class Vampirism
extends Power {
    private Set<PowerUser> sprinting;
    private Set<PowerUser> transformed;
    private final MCMetadata flyingMeta = new MCMetadata();
    private PowerOption<Boolean> helmProt;
    private PowerOption<Boolean> infect;
    private PowerOption<Integer> food;
    private PowerOption<Integer> jmp;
    private PowerOption<Integer> spd;
    private PowerOption<Double> infectChance;
    private PowerOption<Double> wMult;
    private PowerStat kills;
    private String infected;
    private String turnToBat;
    private String turnToHuman;
    private BukkitRunnable manage = new BukkitRunnable(){

        public void run() {
            for (PowerUser user : Vampirism.this.getInstance().getUsers()) {
                if (!user.isOnline() || !user.allowPower(Vampirism.this.getInstance())) continue;
                if (PowerTools.inSunlight(user.getPlayer().getEyeLocation())) {
                    if (Vampirism.this.transformed.contains(user)) {
                        Vampirism.this.transform(user, false);
                    }
                    if (user.getPlayer().getFoodLevel() > 0) {
                        user.getPlayer().setFoodLevel(user.getPlayer().getFoodLevel() - 1);
                        user.getPlayer().getWorld().playEffect(user.getPlayer().getEyeLocation(), Effect.SMOKE, (Object)BlockFace.UP);
                        continue;
                    }
                    if (((Boolean)user.getOption(Vampirism.this.helmProt)).booleanValue() && user.getPlayer().getInventory().getHelmet() != null && user.getPlayer().getInventory().getHelmet().getType() != Material.AIR) continue;
                    user.getPlayer().setFireTicks(20);
                    continue;
                }
                if (!user.hasStatMaxed(Vampirism.this.kills) || user.getCooldown(Vampirism.this.getInstance()) >= 0L) continue;
                user.setAllowFlight(true);
            }
        }
    };

    @Override
    protected void onEnable() {
        this.flyingMeta.setEntry(MCMetadata.EntityMeta.BAT_IS_HANGING, (byte)0);
        this.sprinting = new HashSet<PowerUser>();
        this.transformed = new HashSet<PowerUser>();
        this.runTaskTimer((Runnable)this.manage, 0L, 5L);
    }

    @Override
    protected void onEnable(PowerUser user) {
        if (user.hasStatMaxed(this.kills)) {
            user.setAllowFlight(true);
        }
    }

    @Override
    protected void onDisable(PowerUser user) {
        user.setAllowFlight(false);
        if (this.sprinting.contains(user)) {
            user.removePotionEffect(PotionEffectType.JUMP);
            user.removePotionEffect(PotionEffectType.SPEED);
            this.sprinting.remove(user);
        }
        if (this.transformed.contains(user)) {
            this.transform(user, false);
        }
    }

    @Override
    protected void config() {
        this.food = this.option("food-regen", 7, "Amount of food regeneration granted by killing other entities.");
        this.helmProt = this.option("helmet-prevents-ignition", false, "Whether wearing a helmet will prevent vampires from igniting in sunlight.");
        this.infect = this.option("infect-other-players", false, "Whether attacks from vampires should infect players without the power.");
        this.infectChance = this.option("infect-chance", 15.0, "Percent chance that other players will be infected.");
        this.jmp = this.option("jump-degree", 1, "Jump effect to apply to user while sprinting.");
        this.kills = this.stat("vampire-kills", 100, "Kills as a vampire", "Able to transform into a bat and fly. Exposure to sunlight will end the transformation.");
        this.spd = this.option("speed-degree", 3, "Speed effect to apply to user while sprinting.");
        this.wMult = this.option("wood-damage-multiplier", 3.0, "Amount to multiply damage by when caused by wooden items.");
        this.infected = this.locale("message.been-infected", ChatColor.RED + "You've been infected with [power]!");
        this.turnToHuman = this.locale("message.turn-to-human", ChatColor.YELLOW + "You return to human form.");
        this.turnToBat = this.locale("message.turn-to-bat", ChatColor.GREEN + "You transform into a bat.");
    }

    private void transform(PowerUser user, boolean transform) {
        user.getPlayer().playEffect(EntityEffect.ENTITY_POOF);
        if (transform) {
            PowerTools.addDisguise((Entity)user.getPlayer(), EntityType.BAT, this.flyingMeta);
            this.transformed.add(user);
            user.sendMessage(this.turnToBat);
        } else {
            PowerTools.removeDisguise((Entity)user.getPlayer());
            this.transformed.remove(user);
            user.getPlayer().setFlying(false);
            user.sendMessage(this.turnToHuman);
        }
    }

    @EventHandler
    private void noInteract(PlayerInteractEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this) && this.transformed.contains(user)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onDmg(EntityDamageEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this) && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onDmg(EntityDamageByEntityEvent event) {
        PowerUser user;
        if (event.getDamager() instanceof Player && this.transformed.contains(user = this.getUser((OfflinePlayer)((Player)event.getDamager())))) {
            event.setCancelled(true);
        }
        if (!event.isCancelled() && event.getEntity() instanceof Player && event.getDamager() instanceof LivingEntity) {
            PowerUser pAttacker;
            user = this.getUser((OfflinePlayer)((Player)event.getEntity()));
            LivingEntity attacker = (LivingEntity)event.getDamager();
            if (user.allowPower(this)) {
                ItemStack used = null;
                if (attacker.getEquipment() != null) {
                    used = attacker.getEquipment().getItemInMainHand();
                }
                if (used != null && used.getType().toString().startsWith("WOOD")) {
                    event.setDamage(event.getDamage() * user.getOption(this.wMult));
                }
            } else if (attacker instanceof Player && user.getOption(this.infect).booleanValue() && (pAttacker = this.getUser((OfflinePlayer)((Player)attacker))).allowPower(this) && !user.hasPower(this) && !user.hasPower("Lycanthropy") && random.nextDouble() < user.getOption(this.infectChance) / 100.0) {
                user.sendMessage(this.infected.replace("[power]", this.getName()));
                user.addPower(this, true);
            }
        }
    }

    @EventHandler
    private void onDeath(EntityDeathEvent event) {
        PowerUser user;
        LivingEntity entity = event.getEntity();
        if (entity.getKiller() != null && (user = this.getUser((OfflinePlayer)entity.getKiller())).allowPower(this)) {
            user.increaseStat(this.kills, 1);
            user.regenHunger(user.getOption(this.food));
        }
        if (entity instanceof Player && (user = this.getUser((OfflinePlayer)((Player)entity))).allowPower(this)) {
            this.onDisable(user);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onConsume(PlayerItemConsumeEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this) && event.getItem() != null && event.getItem().getType().isEdible()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onFly(PlayerToggleFlightEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this) && user.hasStatMaxed(this.kills)) {
            this.transform(user, !this.transformed.contains(user));
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onSprint(PlayerToggleSprintEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this)) {
            if (event.isSprinting()) {
                this.sprinting.add(user);
                user.addPotionEffect(new PotionEffect(PotionEffectType.JUMP, Integer.MAX_VALUE, user.getOption(this.jmp).intValue()));
                user.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, user.getOption(this.spd).intValue()));
            } else if (this.sprinting.contains(user)) {
                this.sprinting.remove(user);
                user.removePotionEffect(PotionEffectType.JUMP);
                user.removePotionEffect(PotionEffectType.SPEED);
            }
        }
    }

    @EventHandler
    protected void onStatMax(UserMaxedStatEvent event) {
        PowerUser user = event.getUser();
        if (event.getStat() == this.kills) {
            user.setAllowFlight(true);
        }
    }
}

