/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.passive;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Golem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Raider;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Sonar", type=PowerType.PASSIVE, author="sirrus86", concept="heylookoverthere", icon=Material.COMPASS, incomplete=true, description="...")
public class Sonar
extends Power {
    private PowerOption<String> animalColor;
    private PowerOption<String> golemColor;
    private PowerOption<String> monsterColor;
    private PowerOption<String> playerColor;
    private PowerOption<String> raiderColor;
    private PowerOption<String> villagerColor;
    private PowerOption<Boolean> detectAnimals;
    private PowerOption<Boolean> detectGolems;
    private PowerOption<Boolean> detectMonsters;
    private PowerOption<Boolean> detectPlayers;
    private PowerOption<Boolean> detectRaiders;
    private PowerOption<Boolean> detectVillagers;
    private PowerOption<Integer> detectSteps;
    private PowerOption<Double> maxRange;
    private PowerOption<Long> glowTime;
    private PowerOption<Long> timeBetweenSteps;
    private PowerOption<Float> soundPitch;
    private PowerOption<Float> soundVolume;
    private Map<PowerUser, SonarPulse> pulses;

    @Override
    protected void onEnable() {
        this.pulses = new HashMap<PowerUser, SonarPulse>();
    }

    @Override
    protected void config() {
        this.animalColor = this.option("color.animal", ChatColor.YELLOW.toString(), "Color to use for detected animals.");
        this.cooldown = this.option("cooldown", PowerTime.toMillis(1, 500), "Cooldown between sonar pulses.");
        this.detectAnimals = this.option("detect.animals", true, "Whether animals should be detected.");
        this.detectGolems = this.option("detect.golems", true, "Whether golems should be detected.");
        this.detectMonsters = this.option("detect.monsters", true, "Whether monsters should be detected.");
        this.detectPlayers = this.option("detect.players", true, "Whether players should be detected.");
        this.detectRaiders = this.option("detect.raiders", true, "Whether raiders should be detected.");
        this.detectSteps = this.option("detect-steps", 300, "Number of times between user and max range to detect and highlight entities.");
        this.detectVillagers = this.option("detect.villagers", true, "Whether villagers should be detected.");
        this.glowTime = this.option("glowing-time", PowerTime.toMillis(1, 0), "Amount of time a detected entity should glow.");
        this.golemColor = this.option("color.golem", ChatColor.GRAY.toString(), "Color to use for detected golems.");
        this.item = this.option("item", new ItemStack(Material.COMPASS), "Item used to detect entities.");
        this.maxRange = this.option("max-detect-range", 128.0, "Maximum range to detect entities.");
        this.monsterColor = this.option("color.monster", ChatColor.RED.toString(), "Color to use for detected monsters.");
        this.playerColor = this.option("color.player", ChatColor.DARK_AQUA.toString(), "Color to use for detected players.");
        this.raiderColor = this.option("color.raider", ChatColor.DARK_RED.toString(), "Color to use for detected raiders.");
        this.soundPitch = this.option("pulse-sound-pitch", Float.valueOf(2.0f), "Pitch of the sonar pulse sound.");
        this.soundVolume = this.option("pulse-sound-volume", Float.valueOf(0.25f), "Volume of the sonar pulse sound. Set to 0.0 to mute.");
        this.timeBetweenSteps = this.option("time-between-steps", PowerTime.toMillis(50), "Amount of time between each detect step.");
        this.villagerColor = this.option("color.villager", ChatColor.DARK_GREEN.toString(), "Color to use for detected villagers.");
    }

    @EventHandler(ignoreCancelled=true)
    private void onItemChange(PlayerItemHeldEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this) && user.getCooldown(this) <= 0L && !this.pulses.containsKey(user) && user.getPlayer().getInventory().getItem(event.getNewSlot()) != null && user.getPlayer().getInventory().getItem(event.getNewSlot()).isSimilar((ItemStack)user.getOption(this.item))) {
            user.setCooldown(this, (Long)user.getOption(this.cooldown));
            this.pulses.put(user, new SonarPulse(user));
        }
    }

    private class SonarPulse {
        private final PowerUser user;
        private Set<UUID> detected = new HashSet<UUID>();
        private int detectStep = 1;
        private final int pulseDetectSteps;
        private final Location pulseLoc;
        private final double pulseMaxRange;
        private BukkitRunnable doPulse = new BukkitRunnable(){

            public void run() {
                if (SonarPulse.this.detectStep <= SonarPulse.this.pulseDetectSteps) {
                    for (final LivingEntity entity : PowerTools.getNearbyEntities(LivingEntity.class, SonarPulse.this.pulseLoc, SonarPulse.this.pulseMaxRange * ((double)SonarPulse.this.detectStep / (double)SonarPulse.this.pulseDetectSteps), (Entity)SonarPulse.this.user.getPlayer())) {
                        if (SonarPulse.this.detected.contains(entity.getUniqueId())) continue;
                        String color = "0";
                        boolean doGlow = false;
                        if (entity instanceof Animals && ((Boolean)SonarPulse.this.user.getOption(Sonar.this.detectAnimals)).booleanValue()) {
                            color = (String)SonarPulse.this.user.getOption(Sonar.this.animalColor);
                            doGlow = true;
                        } else if (entity instanceof Golem && ((Boolean)SonarPulse.this.user.getOption(Sonar.this.detectGolems)).booleanValue()) {
                            color = (String)SonarPulse.this.user.getOption(Sonar.this.golemColor);
                            doGlow = true;
                        } else if (entity instanceof Monster && !(entity instanceof Raider) && ((Boolean)SonarPulse.this.user.getOption(Sonar.this.detectMonsters)).booleanValue()) {
                            color = (String)SonarPulse.this.user.getOption(Sonar.this.monsterColor);
                            doGlow = true;
                        } else if (entity instanceof Raider && ((Boolean)SonarPulse.this.user.getOption(Sonar.this.detectRaiders)).booleanValue()) {
                            color = (String)SonarPulse.this.user.getOption(Sonar.this.raiderColor);
                            doGlow = true;
                        } else if (entity instanceof Player && ((Boolean)SonarPulse.this.user.getOption(Sonar.this.detectPlayers)).booleanValue()) {
                            color = (String)SonarPulse.this.user.getOption(Sonar.this.playerColor);
                            doGlow = true;
                        } else if (entity instanceof Merchant && ((Boolean)SonarPulse.this.user.getOption(Sonar.this.detectVillagers)).booleanValue()) {
                            color = (String)SonarPulse.this.user.getOption(Sonar.this.villagerColor);
                            doGlow = true;
                        }
                        if (!doGlow) continue;
                        SonarPulse.this.detected.add(entity.getUniqueId());
                        PowerTools.showAsSpectral(SonarPulse.this.user.getPlayer(), (Entity)entity, ChatColor.getByChar((char)color.charAt(1)), true);
                        Sonar.this.getInstance().runTaskLater((Runnable)new BukkitRunnable(){

                            public void run() {
                                PowerTools.showAsSpectral(SonarPulse.this.user.getPlayer(), (Entity)entity, null, false);
                            }
                        }, PowerTime.toTicks((Long)SonarPulse.this.user.getOption(Sonar.this.glowTime)));
                    }
                    SonarPulse.this.detectStep++;
                    Sonar.this.getInstance().runTaskLater((Runnable)SonarPulse.this.doPulse, PowerTime.toTicks((Long)SonarPulse.this.user.getOption(Sonar.this.timeBetweenSteps)));
                } else {
                    Sonar.this.pulses.remove(SonarPulse.this.user);
                    Sonar.this.getInstance().runTaskLater((Runnable)new BukkitRunnable(){

                        public void run() {
                            if (SonarPulse.this.user.allowPower(Sonar.this.getInstance()) && SonarPulse.this.user.isHoldingItem((ItemStack)SonarPulse.this.user.getOption(Sonar.this.item))) {
                                SonarPulse.this.user.setCooldown(Sonar.this.getInstance(), (Long)SonarPulse.this.user.getOption(Sonar.this.cooldown));
                                Sonar.this.pulses.put(SonarPulse.this.user, new SonarPulse(SonarPulse.this.user));
                            }
                        }
                    }, Math.max(0L, PowerTime.toTicks(SonarPulse.this.user.getCooldown(Sonar.this.getInstance()))));
                }
            }
        };

        public SonarPulse(PowerUser user) {
            this.user = user;
            this.pulseDetectSteps = (Integer)user.getOption(Sonar.this.detectSteps);
            this.pulseLoc = user.getPlayer().getEyeLocation();
            this.pulseMaxRange = (Double)user.getOption(Sonar.this.maxRange);
            user.getPlayer().playSound(this.pulseLoc, Sound.BLOCK_NOTE_BLOCK_PLING, ((Float)user.getOption(Sonar.this.soundVolume)).floatValue(), ((Float)user.getOption(Sonar.this.soundPitch)).floatValue());
            Sonar.this.runTask((Runnable)this.doPulse);
        }
    }
}

