/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.passive;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Rewind", type=PowerType.PASSIVE, author="sirrus86", concept="sirrus86", icon=Material.GOLDEN_BOOTS, description="[act:item]ing while holding [item] allows you to go back in time up to [rewind-time], bringing you to your previous position. [cooldown] cooldown.")
public final class Rewind
extends Power {
    private Map<PowerUser, Long> locCD;
    private Map<PowerUser, TreeMap<Long, Location>> locs;
    private Map<PowerUser, Integer> rewindTask;
    private PowerOption<Long> rewindTime;
    private PowerOption<Long> storeCD;

    @Override
    protected void onEnable() {
        this.locCD = new HashMap<PowerUser, Long>();
        this.locs = new HashMap<PowerUser, TreeMap<Long, Location>>();
        this.rewindTask = new HashMap<PowerUser, Integer>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.rewindTask.containsKey(user)) {
            this.cancelTask(this.rewindTask.get(user));
        }
    }

    @Override
    protected void config() {
        this.cooldown = this.option("cooldown", PowerTime.toMillis(1, 0, 0), "Amount of time before power can be used again.");
        this.item = this.option("item", new ItemStack(Material.CLOCK), "Item used to rewind time.");
        this.rewindTime = this.option("rewind-time", PowerTime.toMillis(5, 0), "Maximum amount of time that can be rewound.");
        this.storeCD = this.option("time-storage-cooldown", PowerTime.toMillis(250), "Minimum time required before storing another location.");
        this.supplies(this.getRequiredItem());
    }

    private void doRewind(final PowerUser user, final TreeMap<Long, Location> locations) {
        long lastKey = locations.lastKey();
        Location loc = locations.get(lastKey);
        if (loc.getWorld() == user.getPlayer().getWorld()) {
            double fall = Math.max(0.0, loc.getY() - user.getPlayer().getLocation().getY());
            user.getPlayer().setFallDistance(Math.max(0.0f, user.getPlayer().getFallDistance() - (float)fall));
        }
        user.getPlayer().teleport(loc);
        locations.remove(lastKey);
        if (!locations.isEmpty()) {
            this.rewindTask.put(user, this.runTaskLater((Runnable)new BukkitRunnable(){

                public void run() {
                    Rewind.this.doRewind(user, locations);
                }
            }, 1L).getTaskId());
        }
    }

    private void trimMap(Map<Long, Location> map, long amt) {
        if (!map.isEmpty()) {
            for (Long time : Set.copyOf(map.keySet())) {
                if (time >= System.currentTimeMillis() - amt) continue;
                map.remove(time);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onMove(PlayerMoveEvent event) {
        PowerUser user;
        if (!(event.getTo().getWorld() == event.getFrom().getWorld() && !(event.getTo().distanceSquared(event.getFrom()) > 0.0) || !(user = this.getUser((OfflinePlayer)event.getPlayer())).allowPower(this) || user.getCooldown(this) > user.getOption(this.rewindTime) || this.locCD.containsKey(user) && this.locCD.get(user) > System.currentTimeMillis())) {
            this.locs.putIfAbsent(user, new TreeMap());
            this.trimMap((Map<Long, Location>)this.locs.get(user), user.getOption(this.rewindTime));
            this.locs.get(user).put(System.currentTimeMillis(), event.getFrom());
            this.locCD.put(user, System.currentTimeMillis() + user.getOption(this.storeCD));
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        if (event.getPower() == this) {
            PowerUser user = event.getUser();
            if (user.getCooldown(this) <= 0L) {
                this.locs.putIfAbsent(user, new TreeMap());
                this.trimMap((Map<Long, Location>)this.locs.get(user), user.getOption(this.rewindTime));
                if (!this.locs.get(user).isEmpty()) {
                    this.doRewind(user, this.locs.get(user));
                    user.setCooldown(this, (Long)user.getOption(this.cooldown));
                }
            } else {
                user.showCooldown(this);
            }
        }
    }
}

