/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.passive;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.ChatColor;
import org.bukkit.EntityEffect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wither;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.Lootable;

@PowerManifest(name="Pickpocket", type=PowerType.PASSIVE, author="sirrus86", concept="grimm294", icon=Material.CHEST, usesPackets=true, description="Sneaking makes you partially invisible. Right-clicking any monster or player while barehanded and sneaking will make you steal a random item from their inventory. Taking items from the target's inventory has a [stealth-break-chance]% chance to break your stealth. Taking damage will also break stealth. Stealing has a [steal-cooldown] cooldown.")
public final class Pickpocket
extends Power {
    private Set<LivingEntity> noDrop;
    private Set<PowerUser> stealth;
    private PowerOption<Double> brChance;
    private PowerOption<Boolean> dontDrop;
    private PowerOption<Boolean> goToInv;
    private PowerOption<Boolean> lookAtThief;
    private PowerOption<Boolean> repeat;
    private PowerStat thefts;
    private String caught;
    private String detected;
    private String failedToSteal;
    private String stealthBroken;
    private String triedToSteal;

    @Override
    protected void onEnable() {
        this.noDrop = new HashSet<LivingEntity>();
        this.stealth = new HashSet<PowerUser>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.stealth.contains(user)) {
            this.removeStealth(user);
        }
    }

    @Override
    protected void config() {
        this.brChance = this.option("stealth-break-chance", 20.0, "Percentage chance that stealth will break when attempting to pickpocket.");
        this.cooldown = this.option("steal-cooldown", PowerTime.toMillis(5, 0), "Amount of time after stealing before you can pickpocket again.");
        this.dontDrop = this.option("no-drops-after-theft", true, "Whether non-player pickpocket victims should no longer be able to drop items on death.");
        this.goToInv = this.option("steal-to-inventory", true, "Whether items stolen should go directly to inventory.");
        this.lookAtThief = this.option("look-at-thief", true, "Whether players should look at thieves when they are detected.");
        this.repeat = this.option("steal-repeatedly", true, "Whether user can attempt to steal from same non-player target repeatedly.");
        this.thefts = this.stat("items-stolen", 50, "Items stolen", "Stealing items can no longer break stealth.");
        this.caught = this.locale("message.caught-stealing", ChatColor.RED + "You were caught pickpocketing.");
        this.detected = this.locale("message.detected", ChatColor.RED + "You've been detected.");
        this.failedToSteal = this.locale("message.failed-to-steal", ChatColor.RED + "Failed to steal anything.");
        this.stealthBroken = this.locale("message.stealth-broken", ChatColor.RED + "Your stealth was broken.");
        this.triedToSteal = this.locale("message.tried-to-steal", ChatColor.RED + "[name] tried to steal from you!");
    }

    private void removeStealth(PowerUser user) {
        user.getPlayer().playEffect(EntityEffect.ENTITY_POOF);
        PowerTools.removeGhost(user.getPlayer());
        this.stealth.remove(user);
    }

    private ItemStack getDrop(LivingEntity entity, HumanEntity killer) {
        Collection loot;
        if (entity instanceof HumanEntity) {
            ItemStack drop = null;
            PlayerInventory inv = ((HumanEntity)entity).getInventory();
            for (int i = 0; i < inv.getContents().length; ++i) {
                int j = random.nextInt(inv.getContents().length);
                if (inv.getContents()[j] == null) continue;
                drop = inv.getContents()[j].clone();
                inv.getContents()[j].setAmount(inv.getContents()[j].getAmount() - 1);
                break;
            }
            if (drop != null) {
                drop.setAmount(1);
            }
            return drop;
        }
        if (entity instanceof Lootable && (loot = ((Lootable)entity).getLootTable().populateLoot(random, new LootContext.Builder(entity.getLocation()).killer(killer).lootedEntity((Entity)entity).build())).size() > 0) {
            int chance = random.nextInt(loot.size());
            return (ItemStack)loot.stream().skip(chance).findFirst().get();
        }
        return null;
    }

    @EventHandler(ignoreCancelled=true)
    private void onDamage(EntityDamageEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this) && this.stealth.contains(user)) {
            user.sendMessage(this.stealthBroken);
            this.removeStealth(user);
        }
    }

    @EventHandler
    private void onDeath(EntityDeathEvent event) {
        if (this.noDrop.contains(event.getEntity()) && this.getOption(this.dontDrop).booleanValue()) {
            event.getDrops().clear();
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onTarget(EntityTargetLivingEntityEvent event) {
        PowerUser user;
        if (event.getTarget() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getTarget()))).allowPower(this) && this.stealth.contains(user)) {
            user.sendMessage(this.detected);
            this.removeStealth(user);
        }
    }

    @EventHandler
    private void onSteal(PlayerInteractEntityEvent event) {
        LivingEntity target;
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this) && this.stealth.contains(user) && PowerTools.isGhost(user.getPlayer()) && (event.getRightClicked() instanceof Monster || event.getRightClicked() instanceof Player) && !(event.getRightClicked() instanceof Wither) && user.getCooldown(this) <= 0L && !this.noDrop.contains(target = (LivingEntity)event.getRightClicked())) {
            ItemStack drop = this.getDrop(target, (HumanEntity)user.getPlayer());
            if (drop != null) {
                if (user.getOption(this.goToInv).booleanValue()) {
                    user.addItems(drop);
                } else {
                    target.getWorld().dropItemNaturally(target.getLocation(), drop);
                }
                if (random.nextDouble() < user.getOption(this.brChance) / 100.0 && !user.hasStatMaxed(this.thefts)) {
                    if (target instanceof Monster) {
                        if (target instanceof PigZombie) {
                            ((PigZombie)target).setAngry(true);
                        }
                        ((Monster)target).setTarget((LivingEntity)user.getPlayer());
                    } else if (target instanceof Player) {
                        PowerUser victim = this.getUser((OfflinePlayer)((Player)target));
                        victim.sendMessage(this.triedToSteal.replace("[name]", user.getName()));
                        if (user.getOption(this.lookAtThief).booleanValue()) {
                            PowerTools.setLook((Player)target, user.getPlayer().getEyeLocation());
                        }
                    }
                    user.sendMessage(this.caught);
                    this.removeStealth(user);
                }
                if (!(target instanceof Player) && !user.getOption(this.repeat).booleanValue()) {
                    this.noDrop.add(target);
                }
                user.increaseStat(this.thefts, 1);
                user.setCooldown(this, (Long)user.getOption(this.cooldown));
            } else {
                user.sendMessage(this.failedToSteal);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onSneak(PlayerToggleSneakEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this)) {
            if (event.isSneaking()) {
                user.getPlayer().playEffect(EntityEffect.ENTITY_POOF);
                PowerTools.addGhost(user.getPlayer());
                this.stealth.add(user);
            } else {
                this.removeStealth(user);
            }
        }
    }
}

