/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.passive;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;

@PowerManifest(name="Ore Detector", type=PowerType.PASSIVE, author="sirrus86", concept="sirrus86", icon=Material.COMPASS, usesPackets=true, description="While holding [item] in either hand, nearby ore blocks within [detect-range] blocks will become visible.[use-progression] Mining detected blocks will eventually allow you to detect more rare veins.[/use-progression]")
public final class OreDetector
extends Power {
    private Set<Material> detectable = EnumSet.noneOf(Material.class);
    private Map<PowerUser, Set<Block>> detectBlocks;
    private PowerStat copperMined;
    private PowerStat goldMined;
    private PowerStat ironMined;
    private PowerStat lapisMined;
    private PowerStat quartzMined;
    private PowerOption<Double> range;
    private PowerOption<Boolean> useProgression;
    private PowerOption<String> coalColor;
    private PowerOption<String> copperColor;
    private PowerOption<String> debrisColor;
    private PowerOption<String> diamondColor;
    private PowerOption<String> emeraldColor;
    private PowerOption<String> goldColor;
    private PowerOption<String> ironColor;
    private PowerOption<String> lapisColor;
    private PowerOption<String> quartzColor;
    private PowerOption<String> redstoneColor;

    @Override
    protected void onEnable() {
        this.detectable.clear();
        for (Material material : Material.values()) {
            if (!material.name().contains("_ORE") && !material.name().contains("ANCIENT_DEBRIS")) continue;
            this.detectable.add(material);
        }
        this.detectBlocks = new HashMap<PowerUser, Set<Block>>();
    }

    @Override
    protected void onEnable(PowerUser user) {
        this.refreshDetect(user);
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.detectBlocks.containsKey(user)) {
            for (Block block : this.detectBlocks.get(user)) {
                PowerTools.removeSpectralBlock(user.getPlayer(), block);
            }
            this.detectBlocks.remove(user);
        }
    }

    @Override
    protected void config() {
        this.coalColor = this.option("color.coal-ore", ChatColor.DARK_GRAY.toString(), "Color to highlight coal ore blocks when detected.");
        this.cooldown = this.option("update-cooldown", PowerTime.toMillis(1, 0), "Minimum time needed before updating detectable blocks when moving.");
        this.copperColor = this.option("color.copper-ore", ChatColor.DARK_AQUA.toString(), "Color to highlight copper ore blocks when detected.");
        this.copperMined = this.stat("copper-mined", 250, "Copper mined while detecting", "You can now detect gold and iron veins.");
        this.debrisColor = this.option("color.ancient-debris", ChatColor.DARK_RED.toString(), "Color to highlight ancient debris blocks when detected.");
        this.diamondColor = this.option("color.diamond-ore", ChatColor.AQUA.toString(), "Color to highlight diamond ore blocks when detected.");
        this.emeraldColor = this.option("color.emerald-ore", ChatColor.GREEN.toString(), "Color to highlight emerald ore blocks when detected.");
        this.goldColor = this.option("color.gold-ore", ChatColor.YELLOW.toString(), "Color to highlight gold ore blocks when detected.");
        this.goldMined = this.stat("gold-mined", 150, "Gold mined while detecting", "You can now detect lapis lazuli, quartz, and redstone veins.");
        this.ironColor = this.option("color.iron-ore", ChatColor.GOLD.toString(), "Color to highlight iron ore blocks when detected.");
        this.ironMined = this.stat("iron-mined", 500, "Iron mined while detecting", "You can now detect diamond veins.");
        this.item = this.option("item", new ItemStack(Material.COMPASS), "Item used to detect ores.");
        this.lapisColor = this.option("color.lapis-ore", ChatColor.BLUE.toString(), "Color to highlight lapis ore blocks when detected.");
        this.lapisMined = this.stat("lapis-mined", 300, "Lapis lazuli mined while detecting", "You can now detect emerald veins.");
        this.quartzColor = this.option("color.quartz-ore", ChatColor.WHITE.toString(), "Color to highlight quartz ore blocks when detected.");
        this.quartzMined = this.stat("quartz-mined", 500, "Quartz mined while detecting", "You can now detect ancient debris.");
        this.range = this.option("detect-range", 10.0, "Maximum range to detect ores.");
        this.redstoneColor = this.option("color.redstone-ore", ChatColor.RED.toString(), "Color to highlight redstone ore blocks when detected.");
        this.useProgression = this.option("use-progression", true, "Whether a progression system should require users to earn the ability to detect better ores.");
        this.supplies(this.getRequiredItem());
    }

    private void refreshDetect(PowerUser user) {
        if (user.allowPower(this) && !this.detectBlocks.containsKey(user)) {
            this.detectBlocks.put(user, new HashSet());
        }
        Set<Block> blockMap = this.detectBlocks.get(user);
        if (user.allowPower(this) && user.isHoldingItem((ItemStack)user.getOption(this.item))) {
            user.setCooldown(this, (Long)user.getOption(this.cooldown));
            Set<Block> blockCheck = PowerTools.getNearbyBlocks(user.getPlayer().getEyeLocation(), user.getOption(this.range), this.detectable);
            for (Block block : Set.copyOf(blockMap)) {
                if (blockCheck.contains(block) && this.detectable.contains(block.getType())) continue;
                PowerTools.removeSpectralBlock(user.getPlayer(), block);
                blockMap.remove(block);
            }
            blockMap.retainAll(blockCheck);
            boolean showBlock = true;
            for (Block block : blockCheck) {
                if (blockMap.contains(block)) continue;
                ChatColor color = ChatColor.BLACK;
                if (block.getType().name().contains("ANCIENT_DEBRIS")) {
                    showBlock = user.getOption(this.useProgression) == false || user.hasStatMaxed(this.quartzMined);
                    color = ChatColor.getByChar((char)user.getOption(this.debrisColor).charAt(1));
                } else if (block.getType().name().contains("COAL_ORE")) {
                    color = ChatColor.getByChar((char)user.getOption(this.coalColor).charAt(1));
                } else if (block.getType().name().contains("COPPER_ORE")) {
                    color = ChatColor.getByChar((char)user.getOption(this.copperColor).charAt(1));
                } else if (block.getType().name().contains("DIAMOND_ORE")) {
                    showBlock = user.getOption(this.useProgression) == false || user.hasStatMaxed(this.ironMined);
                    color = ChatColor.getByChar((char)user.getOption(this.diamondColor).charAt(1));
                } else if (block.getType().name().contains("EMERALD_ORE")) {
                    showBlock = user.getOption(this.useProgression) == false || user.hasStatMaxed(this.lapisMined);
                    color = ChatColor.getByChar((char)user.getOption(this.emeraldColor).charAt(1));
                } else if (block.getType().name().contains("GOLD_ORE")) {
                    showBlock = user.getOption(this.useProgression) == false || user.hasStatMaxed(this.copperMined);
                    color = ChatColor.getByChar((char)user.getOption(this.goldColor).charAt(1));
                } else if (block.getType().name().contains("IRON_ORE")) {
                    showBlock = user.getOption(this.useProgression) == false || user.hasStatMaxed(this.copperMined);
                    color = ChatColor.getByChar((char)user.getOption(this.ironColor).charAt(1));
                } else if (block.getType().name().contains("LAPIS_ORE")) {
                    showBlock = user.getOption(this.useProgression) == false || user.hasStatMaxed(this.goldMined);
                    color = ChatColor.getByChar((char)user.getOption(this.lapisColor).charAt(1));
                } else if (block.getType().name().contains("QUARTZ_ORE")) {
                    showBlock = user.getOption(this.useProgression) == false || user.hasStatMaxed(this.goldMined);
                    color = ChatColor.getByChar((char)user.getOption(this.quartzColor).charAt(1));
                } else if (block.getType().name().contains("REDSTONE_ORE")) {
                    showBlock = user.getOption(this.useProgression) == false || user.hasStatMaxed(this.goldMined);
                    color = ChatColor.getByChar((char)user.getOption(this.redstoneColor).charAt(1));
                }
                if (!showBlock) continue;
                PowerTools.addSpectralBlock(user.getPlayer(), block, color);
                blockMap.add(block);
            }
        } else if (blockMap != null) {
            for (Block block : blockMap) {
                PowerTools.removeSpectralBlock(user.getPlayer(), block);
            }
            blockMap.clear();
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onBreak(BlockBreakEvent event) {
        for (final PowerUser user : this.detectBlocks.keySet()) {
            if (!this.detectBlocks.get(user).contains(event.getBlock())) continue;
            if (user.isOnline() && user.allowPower(this) && user.isHoldingItem((ItemStack)user.getOption(this.item)) && event.getPlayer() == user.getPlayer() && this.detectable.contains(event.getBlock().getType()) && user.getOption(this.useProgression).booleanValue()) {
                if (event.getBlock().getType().name().contains("COPPER_ORE")) {
                    user.increaseStat(this.copperMined, 1);
                } else if (user.hasStatMaxed(this.copperMined)) {
                    if (event.getBlock().getType().name().contains("GOLD_ORE")) {
                        user.increaseStat(this.goldMined, 1);
                    } else if (event.getBlock().getType().name().contains("IRON_ORE")) {
                        user.increaseStat(this.ironMined, 1);
                    }
                } else if (user.hasStatMaxed(this.goldMined)) {
                    if (event.getBlock().getType().name().contains("LAPIS_ORE")) {
                        user.increaseStat(this.lapisMined, 1);
                    } else if (event.getBlock().getType().name().contains("QUARTZ_ORE")) {
                        user.increaseStat(this.quartzMined, 1);
                    }
                }
            }
            this.runTaskLater(new Runnable(){

                @Override
                public void run() {
                    OreDetector.this.refreshDetect(user);
                }
            }, 1L);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onBlockDamage(BlockDamageEvent event) {
        if (event.getInstaBreak()) {
            for (final PowerUser user : this.detectBlocks.keySet()) {
                if (!this.detectBlocks.get(user).contains(event.getBlock())) continue;
                this.runTaskLater(new Runnable(){

                    @Override
                    public void run() {
                        OreDetector.this.refreshDetect(user);
                    }
                }, 1L);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onExtend(BlockPistonExtendEvent event) {
        for (final PowerUser user : this.detectBlocks.keySet()) {
            if (Collections.disjoint((Collection)this.detectBlocks.get(user), event.getBlocks())) continue;
            this.runTaskLater(new Runnable(){

                @Override
                public void run() {
                    OreDetector.this.refreshDetect(user);
                }
            }, 1L);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onRetract(BlockPistonRetractEvent event) {
        for (final PowerUser user : this.detectBlocks.keySet()) {
            if (Collections.disjoint((Collection)this.detectBlocks.get(user), event.getBlocks())) continue;
            this.runTaskLater(new Runnable(){

                @Override
                public void run() {
                    OreDetector.this.refreshDetect(user);
                }
            }, 1L);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onItemChange(PlayerItemHeldEvent event) {
        this.refreshDetect(this.getUser((OfflinePlayer)event.getPlayer()));
    }

    @EventHandler(ignoreCancelled=true)
    private void onMove(PlayerMoveEvent event) {
        PowerUser user;
        if ((event.getFrom().getWorld() != event.getTo().getWorld() || event.getFrom().distanceSquared(event.getTo()) > 0.0) && (user = this.getUser((OfflinePlayer)event.getPlayer())).getCooldown(this) <= 0L) {
            this.refreshDetect(this.getUser((OfflinePlayer)event.getPlayer()));
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onItemSwap(PlayerSwapHandItemsEvent event) {
        this.refreshDetect(this.getUser((OfflinePlayer)event.getPlayer()));
    }
}

