/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.passive;

import java.util.HashSet;
import java.util.Set;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.tools.version.MCMetadata;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.ChatColor;
import org.bukkit.EntityEffect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Lycanthropy", type=PowerType.PASSIVE, author="sirrus86", concept="vashvhexx", icon=Material.RABBIT_HIDE, usesPackets=true, description="[control-transformation]By [act:item]ing while holding [item][/control-transformation][noControl]At night during a full moon [/noControl]you change into a wolf. As a wolf[increase-speed] sprinting speed increases,[/increase-speed][night-vision] you gain night vision,[/night-vision][either] and[/either] unarmed damage increases by [damage-multiplier]%, but you take [iron-multiplier]% damage from iron tools and weapons[prevent-armor], and are unable to wear any armor[/prevent-armor].[noControl] Effect ends at sunrise.[/noControl]")
public final class Lycanthropy
extends Power {
    private Set<PowerUser> isWolf;
    private final MCMetadata angryMeta = new MCMetadata();
    private PowerOption<Double> dmgIncr;
    private PowerOption<Double> infectChance;
    private PowerOption<Double> ironDmg;
    private PowerOption<Boolean> control;
    private PowerOption<Boolean> infect;
    private PowerOption<Boolean> nv;
    private PowerOption<Boolean> preventArmor;
    private PowerOption<Boolean> speed;
    private PowerOption<Integer> moonEnd;
    private PowerOption<Integer> moonStart;
    private PowerOption<Integer> spdIncr;
    private PowerStat transforms;
    private String infected;
    private String noArmor;
    private String turnToHuman;
    private String turnToWolf;
    private boolean either;
    private boolean noControl;
    private Runnable manage = new BukkitRunnable(){

        public void run() {
            for (PowerUser user : Lycanthropy.this.getUsers()) {
                if (!user.allowPower(Lycanthropy.this.getInstance())) continue;
                if (Lycanthropy.this.isWolf.contains(user)) {
                    if (user.isOnline() && ((Boolean)user.getOption(Lycanthropy.this.preventArmor)).booleanValue() && user.getPlayer().getInventory().getArmorContents() != null) {
                        boolean hadArmor = false;
                        for (ItemStack armor : user.getPlayer().getInventory().getArmorContents()) {
                            if (armor == null || armor.getType() == Material.AIR) continue;
                            user.getPlayer().getWorld().dropItem(user.getPlayer().getLocation(), armor);
                            hadArmor = true;
                        }
                        if (hadArmor) {
                            user.sendMessage(Lycanthropy.this.noArmor);
                        }
                        user.getPlayer().getInventory().setArmorContents(null);
                    }
                    if (!user.isOnline() || Lycanthropy.this.isFullMoon(user.getPlayer().getWorld()) || Lycanthropy.this.canControl(user)) continue;
                    Lycanthropy.this.revert(user);
                    continue;
                }
                if (!user.isOnline() || !Lycanthropy.this.isFullMoon(user.getPlayer().getWorld()) || Lycanthropy.this.canControl(user)) continue;
                Lycanthropy.this.transform(user);
            }
        }
    };

    @Override
    protected void onEnable() {
        this.angryMeta.setEntry(MCMetadata.EntityMeta.TAMEABLE_STATE, (byte)2);
        this.isWolf = new HashSet<PowerUser>();
        this.runTaskTimer(this.manage, 0L, 0L);
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.isWolf.contains(user)) {
            this.revert(user);
        }
    }

    @Override
    protected void config() {
        this.control = this.option("control-transformation", false, "Whether users should always be able to willfully transform.");
        this.dmgIncr = this.option("damage-multiplier", 400.0, "Percentage increase of damage done while transformed and barehanded.");
        this.infect = this.option("infect-other-players", false, "Whether barehanded attacks from werewolves should infect players without the power.");
        this.infectChance = this.option("infect-chance", 15.0, "Percent chance that other players will be infected.");
        this.ironDmg = this.option("iron-multiplier", 200.0, "Percent of damage done by iron weapons against transformed werewolves.");
        this.item = this.option("item", new ItemStack(Material.ROTTEN_FLESH), "Item used to manually transform into a werewolf.");
        this.moonEnd = this.option("full-moon-end", 22000, "Time (in game ticks) moon sets.");
        this.moonStart = this.option("full-moon-start", 13000, "Time (in game ticks) when the moon rises.");
        this.nv = this.option("night-vision", true, "Whether users should get night vision while transformed.");
        this.preventArmor = this.option("prevent-armor", true, "Whether users are prevented from wearing armor while transformed.");
        this.spdIncr = this.option("speed-amplifier", 3, "Amplifier for increased speed potion effect.");
        this.speed = this.option("increase-speed", true, "Whether speed should increase while transformed.");
        this.transforms = this.stat("transformations", 10, "Transformations", "[act:item]ing while holding [item] at night allows you to transform into a werewolf at will.");
        this.infected = this.locale("message.been-infected", ChatColor.RED + "You've been infected with [power]!");
        this.noArmor = this.locale("message.cant-wear-armor", ChatColor.RED + "Your power prevents you from wearing armor.");
        this.turnToHuman = this.locale("message.turn-to-human", ChatColor.YELLOW + "You return to human form.");
        this.turnToWolf = this.locale("message.turn-to-wolf", ChatColor.GREEN + "You transform into a wolf.");
        this.noControl = this.getOption(this.control) == false;
        this.either = this.getOption(this.nv) != false || this.getOption(this.speed) != false;
    }

    private boolean canControl(PowerUser user) {
        return user.getOption(this.control) != false || user.hasStatMaxed(this.transforms);
    }

    private boolean isFullMoon(World world) {
        if (world.getEnvironment() == World.Environment.NORMAL) {
            double days = world.getFullTime() / 24000L;
            int phase = (int)(days % 8.0);
            return phase == 0 && world.getTime() < (long)this.getOption(this.moonEnd).intValue() && world.getTime() > (long)this.getOption(this.moonStart).intValue();
        }
        return false;
    }

    private void revert(PowerUser user) {
        if (user.isOnline()) {
            user.removePotionEffect(PotionEffectType.NIGHT_VISION);
            user.removePotionEffect(PotionEffectType.SPEED);
            user.getPlayer().playEffect(EntityEffect.ENTITY_POOF);
            PowerTools.removeDisguise((Entity)user.getPlayer());
            user.sendMessage(this.turnToHuman);
            this.isWolf.remove(user);
        }
    }

    private void transform(PowerUser user) {
        if (user.isOnline()) {
            if (user.getOption(this.nv).booleanValue()) {
                user.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Short.MAX_VALUE, 0));
            }
            user.getPlayer().getWorld().playSound(user.getPlayer().getEyeLocation(), Sound.ENTITY_WOLF_HOWL, 1.0f, 1.0f);
            user.getPlayer().playEffect(EntityEffect.ENTITY_POOF);
            PowerTools.addDisguise((Entity)user.getPlayer(), EntityType.WOLF, this.angryMeta);
            user.sendMessage(this.turnToWolf);
            if (this.noControl) {
                user.increaseStat(this.transforms, 1);
            }
            this.isWolf.add(user);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onDmg(EntityDamageByEntityEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && event.getDamager() instanceof LivingEntity) {
            user = this.getUser((OfflinePlayer)((Player)event.getEntity()));
            LivingEntity attacker = (LivingEntity)event.getDamager();
            if (this.isWolf.contains(user) && attacker.getEquipment() != null && attacker.getEquipment().getItemInMainHand() != null && attacker.getEquipment().getItemInMainHand().getType().toString().startsWith("IRON_")) {
                event.setDamage(event.getDamage() * (user.getOption(this.ironDmg) / 100.0));
            }
        }
        if (event.getDamager() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getDamager()))).allowPower(this) && this.isWolf.contains(user) && user.getEquipment(EquipmentSlot.HAND).getType() == Material.AIR) {
            PowerUser victim;
            event.setDamage(event.getDamage() * (user.getOption(this.dmgIncr) / 100.0));
            PowerTools.playParticleEffect(event.getEntity().getLocation(), Particle.CRIT, 5);
            if (event.getEntity() instanceof Player && user.getOption(this.infect).booleanValue() && !(victim = this.getUser((OfflinePlayer)((Player)event.getEntity()))).hasPower(this) && !victim.hasPower("Vampirism") && random.nextDouble() < user.getOption(this.infectChance) / 100.0) {
                victim.sendMessage(this.infected.replace("[power]", this.getName()));
                victim.addPower(this, true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onSprint(PlayerToggleSprintEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this) && this.isWolf.contains(user)) {
            if (event.isSprinting()) {
                if (user.getOption(this.speed).booleanValue()) {
                    user.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Short.MAX_VALUE, user.getOption(this.spdIncr).intValue()));
                }
            } else if (user.getOption(this.speed).booleanValue()) {
                user.getPlayer().removePotionEffect(PotionEffectType.SPEED);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        PowerUser user;
        if (event.getPower() == this && this.canControl(user = event.getUser())) {
            if (this.isWolf.contains(user)) {
                this.revert(user);
            } else {
                this.transform(user);
            }
        }
    }
}

