/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.passive;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.TreeSpecies;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

@PowerManifest(name="Lumberjack", type=PowerType.PASSIVE, author="sirrus86", concept="sirrus86", icon=Material.IRON_AXE, description="Breaking log blocks[require-axe] using an axe[/require-axe] will cause all adjacent logs[break-leaves] and leaves[/break-leaves] to also break.[auto-replant] Trees cut down are automatically replanted.[/auto-replant]")
public final class Lumberjack
extends Power {
    private List<Block> blocks;
    private final Set<Material> plantable = Sets.newHashSet((Object[])new Material[]{Material.DIRT, Material.GRASS});
    private PowerOption<Boolean> doLeaves;
    private PowerOption<Boolean> doThreshold;
    private PowerOption<Boolean> replant;
    private PowerOption<Boolean> reqAxe;
    private PowerOption<Integer> threshold;

    @Override
    protected void onEnable() {
        this.blocks = new ArrayList<Block>();
    }

    @Override
    protected void config() {
        this.doLeaves = this.option("break-leaves", true, "Whether adjacent leaves should also be broken when trees are chopped down.");
        this.doThreshold = this.option("apply-threshold", true, "Whether the number of blocks broken at one time should be limited.");
        this.replant = this.option("auto-replant", true, "Whether a sapling should be placed where the tree once stood after being chopped.");
        this.reqAxe = this.option("require-axe", true, "Whether trees can only be chopped by users when holding an axe.");
        this.threshold = this.option("threshold", 30, "Maximum number of blocks that can be broken at one time. 'apply-threshold' must be true for this to apply.");
        this.supplies(new ItemStack(Material.IRON_AXE));
    }

    private Material getSapling(TreeSpecies species) {
        switch (species) {
            case ACACIA: {
                return Material.ACACIA_SAPLING;
            }
            case BIRCH: {
                return Material.BIRCH_SAPLING;
            }
            case DARK_OAK: {
                return Material.DARK_OAK_SAPLING;
            }
            case GENERIC: {
                return Material.OAK_SAPLING;
            }
            case JUNGLE: {
                return Material.JUNGLE_SAPLING;
            }
            case REDWOOD: {
                return Material.SPRUCE_SAPLING;
            }
        }
        return Material.OAK_SAPLING;
    }

    private TreeSpecies getTreeSpecies(Material material) {
        for (TreeSpecies species : TreeSpecies.values()) {
            String speciesStr = species.toString();
            if (speciesStr.equalsIgnoreCase("GENERIC")) {
                speciesStr = "OAK";
            } else if (speciesStr.equalsIgnoreCase("REDWOOD")) {
                speciesStr = "SPRUCE";
            }
            if (!material.toString().startsWith(speciesStr)) continue;
            return species;
        }
        return null;
    }

    @EventHandler(ignoreCancelled=true)
    private void onChop(BlockBreakEvent event) {
        PowerUser user;
        if (event.getPlayer() != null && (user = this.getUser((OfflinePlayer)event.getPlayer())).allowPower(this) && (PowerTools.isAxe(user.getPlayer().getInventory().getItemInMainHand()) || !user.getOption(this.reqAxe).booleanValue()) && event.getBlock().getType().toString().contains("LOG")) {
            Block block = event.getBlock();
            this.blocks.add(block);
            final TreeSpecies species = this.getTreeSpecies(block.getType());
            while (this.blocks.size() > 0) {
                for (int i = 0; i < this.blocks.size(); ++i) {
                    final Block log = this.blocks.get(i);
                    if ((log.getType().toString().contains("LOG") || log.getType().toString().contains("LEAVES") && user.getOption(this.doLeaves).booleanValue()) && this.getTreeSpecies(log.getType()) == species) {
                        log.breakNaturally();
                        for (BlockFace face : BlockFace.values()) {
                            if (log.getRelative(face).getType().toString().contains("LOG") || log.getRelative(face).getType().toString().contains("LEAVES") && user.getOption(this.doLeaves).booleanValue()) {
                                if (user.getOption(this.doThreshold).booleanValue() && this.blocks.size() >= user.getOption(this.threshold)) continue;
                                this.blocks.add(log.getRelative(face));
                                continue;
                            }
                            if (face != BlockFace.DOWN || !this.plantable.contains(log.getRelative(BlockFace.DOWN).getType()) || !user.getOption(this.replant).booleanValue() || species == null) continue;
                            this.runTask(new Runnable(){

                                @Override
                                public void run() {
                                    log.setType(Lumberjack.this.getSapling(species));
                                }
                            });
                        }
                    }
                    this.blocks.remove(log);
                }
            }
        }
    }
}

