/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.passive;

import java.util.HashSet;
import java.util.Set;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.Material;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@PowerManifest(name="Haste", type=PowerType.PASSIVE, author="sirrus86", concept="JJoiler", icon=Material.ELYTRA, description="Perform hand-related tasks (mining, digging, attacking, etc) much faster than other players.")
public final class Haste
extends Power {
    private Set<PowerUser> hasEffects;

    @Override
    protected void onEnable() {
        this.hasEffects = new HashSet<PowerUser>();
    }

    @Override
    protected void onEnable(PowerUser user) {
        if (user.allowPower(this) && !this.hasEffects.contains(user)) {
            user.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, Integer.MAX_VALUE, 3, false, false, true));
            this.hasEffects.add(user);
        }
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.hasEffects.contains(user)) {
            user.removePotionEffect(PotionEffectType.FAST_DIGGING);
            this.hasEffects.remove(user);
        }
    }

    @Override
    protected void config() {
    }
}

