/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.passive;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Fire Aura", type=PowerType.PASSIVE, author="sirrus86", concept="FyreCat", icon=Material.BLAZE_POWDER, description="Regenerate hunger from fire and magma blocks, while regenerating health while in lava. Lose hunger in rain, and lose health in water.[blind-in-lava] Vision while in lava is improved.[/blind-in-lava]")
public final class FireAura
extends Power {
    private Set<PowerUser> isBlind;
    private Map<PowerUser, Integer> rainTask;
    private Map<PowerUser, Integer> sparkTask;
    private Map<PowerUser, Integer> waterTask;
    private Map<PowerUser, Long> sparkDur;
    private PowerOption<Boolean> goBlind;
    private PowerOption<Integer> rainDmg;
    private PowerOption<Double> waterDmg;

    @Override
    protected void onEnable() {
        this.isBlind = new HashSet<PowerUser>();
        this.rainTask = new HashMap<PowerUser, Integer>();
        this.sparkDur = new HashMap<PowerUser, Long>();
        this.sparkTask = new HashMap<PowerUser, Integer>();
        this.waterTask = new HashMap<PowerUser, Integer>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.isBlind.contains(user)) {
            user.removePotionEffect(PotionEffectType.BLINDNESS);
            this.isBlind.remove(user);
        }
        if (this.rainTask.containsKey(user)) {
            this.cancelTask(this.rainTask.get(user));
            this.rainTask.remove(user);
        }
        if (this.sparkTask.containsKey(user)) {
            this.cancelTask(this.sparkTask.get(user));
            this.sparkTask.remove(user);
        }
        if (this.waterTask.containsKey(user)) {
            this.cancelTask(this.waterTask.get(user));
            this.waterTask.remove(user);
        }
    }

    @Override
    protected void config() {
        this.goBlind = this.option("blind-in-lava", true, "Whether to apply blindness to player while in lava. This actually improves vision.");
        this.rainDmg = this.option("rain-damage", 1, "Hunger caused by being in the rain.");
        this.waterDmg = this.option("water-damage", 4.0, "Damage caused by being in water.");
    }

    private void rainTask(final PowerUser user) {
        if (this.inRain(user) && !this.inWater(user)) {
            this.rainTask.put(user, this.runTaskLater((Runnable)new BukkitRunnable(){

                public void run() {
                    user.getPlayer().playEffect(EntityEffect.ENTITY_POOF);
                    int food = user.getPlayer().getFoodLevel();
                    if (food > 0) {
                        user.getPlayer().setFoodLevel(food - (Integer)user.getOption(FireAura.this.rainDmg));
                    }
                    FireAura.this.rainTask(user);
                }
            }, 10L).getTaskId());
        } else {
            this.rainTask.remove(user);
        }
    }

    private void sparkTask(final PowerUser user) {
        if (this.sparkDur.containsKey(user) && System.currentTimeMillis() < this.sparkDur.get(user)) {
            this.sparkTask.put(user, this.runTaskLater((Runnable)new BukkitRunnable(){

                public void run() {
                    PowerTools.playParticleEffect(user.getPlayer().getEyeLocation(), Particle.LAVA);
                    FireAura.this.sparkTask(user);
                }
            }, 5L).getTaskId());
        } else {
            this.sparkTask.remove(user);
        }
    }

    private void waterTask(final PowerUser user) {
        if (this.inWater(user)) {
            this.waterTask.put(user, this.runTaskLater((Runnable)new BukkitRunnable(){

                public void run() {
                    user.getPlayer().playEffect(EntityEffect.ENTITY_POOF);
                    EntityDamageEvent event = new EntityDamageEvent((Entity)user.getPlayer(), EntityDamageEvent.DamageCause.DROWNING, ((Double)user.getOption(FireAura.this.waterDmg)).doubleValue());
                    FireAura.this.callEvent((Event)event);
                    if (!event.isCancelled()) {
                        user.getPlayer().damage(event.getDamage());
                    }
                    FireAura.this.waterTask(user);
                }
            }, 10L).getTaskId());
        } else {
            this.waterTask.remove(user);
        }
    }

    private boolean inLava(PowerUser user) {
        Block block = user.getPlayer().getEyeLocation().getBlock();
        return block.getType() == Material.LAVA;
    }

    private boolean inRain(PowerUser user) {
        Location loc = user.getPlayer().getEyeLocation();
        return PowerTools.isOutside(loc) && loc.getWorld().hasStorm();
    }

    private boolean inWater(PowerUser user) {
        ArrayList blocks = Lists.newArrayList((Object[])new Block[]{user.getPlayer().getEyeLocation().getBlock()});
        if (user.getPlayer().getVehicle() == null) {
            blocks.add(user.getPlayer().getLocation().getBlock());
        }
        for (int i = 0; i < blocks.size(); ++i) {
            if (((Block)blocks.get(i)).getType() != Material.WATER && (!(((Block)blocks.get(i)).getBlockData() instanceof Waterlogged) || !((Waterlogged)((Block)blocks.get(i)).getBlockData()).isWaterlogged())) continue;
            return true;
        }
        return false;
    }

    @EventHandler(ignoreCancelled=true)
    private void onDmg(EntityDamageEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this)) {
            switch (event.getCause()) {
                case FIRE: 
                case FIRE_TICK: 
                case HOT_FLOOR: {
                    user.regenHunger((int)event.getDamage());
                    event.setCancelled(true);
                    break;
                }
                case LAVA: {
                    user.heal(event.getDamage());
                    this.sparkDur.put(user, System.currentTimeMillis() + PowerTime.toMillis(3, 0));
                    if (!this.sparkTask.containsKey(user)) {
                        this.sparkTask(user);
                    }
                    event.setCancelled(true);
                    break;
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void inWater(PlayerMoveEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this)) {
            if (this.inLava(user) && user.getOption(this.goBlind).booleanValue()) {
                user.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, Integer.MAX_VALUE, 0));
                this.isBlind.add(user);
            } else if (!this.inLava(user) && this.isBlind.contains(user)) {
                user.removePotionEffect(PotionEffectType.BLINDNESS);
                this.isBlind.remove(user);
            }
            if (this.inWater(user) && !this.waterTask.containsKey(user)) {
                this.waterTask(user);
            } else if (this.inRain(user) && !this.rainTask.containsKey(user)) {
                this.rainTask(user);
            }
        }
    }
}

