/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.passive;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Dark Regen", type=PowerType.PASSIVE, author="sirrus86", concept="sirrus86", icon=Material.END_CRYSTAL, description="[regenAny]Regenerate [regenerate-health]health [/regenerate-health][regenBoth]and [/regenBoth][regenerate-hunger]hunger [/regenerate-hunger]while in dark areas. [/regenAny][night-vision]Gain night vision in dark areas.[/night-vision]")
public final class DarkRegen
extends Power {
    private Set<PowerUser> hasNV;
    private Map<PowerUser, Integer> regenTask;
    private PowerOption<Boolean> doNV;
    private PowerOption<Boolean> noRegen;
    private PowerOption<Boolean> regenFood;
    private PowerOption<Boolean> regenHP;
    private PowerOption<Integer> maxLvl;
    private PowerOption<Integer> minLvl;
    private boolean regenAny;
    private boolean regenBoth;

    @Override
    protected void onEnable() {
        this.hasNV = new HashSet<PowerUser>();
        this.regenTask = new HashMap<PowerUser, Integer>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.hasNV.contains(user)) {
            user.removePotionEffect(PotionEffectType.NIGHT_VISION);
            this.hasNV.remove(user);
        }
        if (this.regenTask.containsKey(user)) {
            this.cancelTask(this.regenTask.get(user));
        }
    }

    @Override
    protected void config() {
        this.cooldown = this.option("minimum-cooldown", PowerTime.toMillis(200), "Minimum amount of time before user can regenerate in darkness.");
        this.maxLvl = this.option("maximum-light-level", 8, "Maximum light level (from 0-15, darkest to brightest) in which the power will work.");
        this.minLvl = this.option("minimum-light-level", 0, "Minimum light level (from 0-15, darkest to brightest) in which the power will work.");
        this.doNV = this.option("night-vision", false, "Whether night vision should be granted in dark areas.");
        this.noRegen = this.option("prevent-regen-in-light", true, "Whether to prevent users from regenerating health in higher light levels.");
        this.regenFood = this.option("regenerate-hunger", true, "Whether user will regenerate hunger in dark areas.");
        this.regenHP = this.option("regenerate-health", true, "Whether user will regenerate health in dark areas.");
        this.regenAny = this.getOption(this.regenFood) != false || this.getOption(this.regenHP) != false;
        this.regenBoth = this.getOption(this.regenFood) != false && this.getOption(this.regenHP) != false;
    }

    private Runnable doRegen(final PowerUser user) {
        return new BukkitRunnable(){

            public void run() {
                if (user.allowPower(DarkRegen.this.getInstance()) && user.getPlayer().getEyeLocation().getBlock().getLightLevel() >= (Integer)user.getOption(DarkRegen.this.minLvl) && user.getPlayer().getEyeLocation().getBlock().getLightLevel() <= (Integer)user.getOption(DarkRegen.this.maxLvl)) {
                    if (user.getPlayer().getHealth() < user.getPlayer().getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() && (Boolean)user.getOption(DarkRegen.this.regenHP) != false || user.getPlayer().getFoodLevel() < 20 && ((Boolean)user.getOption(DarkRegen.this.regenFood)).booleanValue()) {
                        if (((Boolean)user.getOption(DarkRegen.this.regenHP)).booleanValue()) {
                            user.heal(1.0);
                        }
                        if (((Boolean)user.getOption(DarkRegen.this.regenFood)).booleanValue()) {
                            user.regenHunger(1);
                        }
                        PowerTools.playParticleEffect(user.getPlayer().getEyeLocation(), Particle.PORTAL, 10);
                    }
                    if (((Boolean)user.getOption(DarkRegen.this.doNV)).booleanValue() && !DarkRegen.this.hasNV.contains(user)) {
                        user.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, 0));
                        DarkRegen.this.hasNV.add(user);
                    }
                    DarkRegen.this.regenTask.put(user, DarkRegen.this.getInstance().runTaskLater(DarkRegen.this.doRegen(user), PowerTime.toTicks((Long)user.getOption(DarkRegen.this.cooldown))).getTaskId());
                } else if (DarkRegen.this.hasNV.contains(user)) {
                    user.removePotionEffect(PotionEffectType.NIGHT_VISION);
                    DarkRegen.this.hasNV.remove(user);
                }
            }
        };
    }

    @EventHandler(ignoreCancelled=true)
    private void onMove(PlayerMoveEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (!(!user.allowPower(this) || user.getPlayer().getEyeLocation().getBlock().getLightLevel() < user.getOption(this.minLvl) || user.getPlayer().getEyeLocation().getBlock().getLightLevel() > user.getOption(this.maxLvl) || this.regenTask.containsKey(user) && this.isTaskLive(this.regenTask.get(user)))) {
            this.regenTask.put(user, this.runTask(this.doRegen(user)).getTaskId());
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onRegen(EntityRegainHealthEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this) && user.getOption(this.noRegen).booleanValue() && (user.getPlayer().getEyeLocation().getBlock().getLightLevel() < user.getOption(this.minLvl) || user.getPlayer().getEyeLocation().getBlock().getLightLevel() > user.getOption(this.maxLvl))) {
            event.setCancelled(true);
        }
    }
}

