/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.passive;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.ChatColor;
import org.bukkit.EntityEffect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@PowerManifest(name="Aquaphile", type=PowerType.PASSIVE, author="sirrus86", concept="bobby16may", icon=Material.NAUTILUS_SHELL, usesPackets=true, description="Can breath[night-vision] and see better[/night-vision] underwater.[heal-underwater] Healed by water.[/heal-underwater] Movement while underwater is much faster.[enable-dolphin-form] Sprinting while underwater transforms you into a dolphin.[/enable-dolphin-form]")
public final class Aquaphile
extends Power {
    private final Set<Material> waterMats = EnumSet.of(Material.KELP_PLANT, Material.SEAGRASS, Material.TALL_SEAGRASS, Material.WATER);
    private Set<PowerUser> isDolphin;
    private Set<PowerUser> nvList;
    private PowerOption<Boolean> canDolphin;
    private PowerOption<Boolean> heal;
    private PowerOption<Boolean> nv;
    private String dolphinOnLand;
    private String turnToDolphin;
    private String turnToHuman;

    @Override
    protected void onEnable() {
        this.isDolphin = new HashSet<PowerUser>();
        this.nvList = new HashSet<PowerUser>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.isDolphin.contains(user)) {
            this.setDolphin(user, false);
        }
        if (this.nvList.contains(user)) {
            user.removePotionEffect(PotionEffectType.NIGHT_VISION);
            user.removePotionEffect(PotionEffectType.REGENERATION);
            user.removePotionEffect(PotionEffectType.DOLPHINS_GRACE);
            user.removePotionEffect(PotionEffectType.WATER_BREATHING);
            this.nvList.remove(user);
        }
    }

    @Override
    protected void config() {
        this.canDolphin = this.option("enable-dolphin-form", true, "Whether dolphin form should be enabled.");
        this.heal = this.option("heal-underwater", true, "Whether users should be healed while underwater.");
        this.nv = this.option("night-vision", true, "Whether users should get night-vision underwater.");
        this.dolphinOnLand = this.locale("message.dolphin-on-land", ChatColor.RED + "You can't become a dolphin on land.");
        this.turnToDolphin = this.locale("message.turn-to-dolphin", ChatColor.GREEN + "You transform into a dolphin.");
        this.turnToHuman = this.locale("message.turn-to-human", ChatColor.YELLOW + "You return to human form.");
        this.supplies(this.getRequiredItem());
    }

    private boolean isWater(Block block) {
        return this.waterMats.contains(block.getType()) || block.getBlockData() instanceof Waterlogged && ((Waterlogged)block.getBlockData()).isWaterlogged();
    }

    private void setDolphin(PowerUser user, boolean dolphin) {
        if (dolphin) {
            if (this.isWater(user.getPlayer().getEyeLocation().getBlock())) {
                user.getPlayer().playEffect(EntityEffect.ENTITY_POOF);
                this.isDolphin.add(user);
                PowerTools.addDisguise((Entity)user.getPlayer(), EntityType.DOLPHIN);
                user.sendMessage(this.turnToDolphin);
            } else {
                user.sendMessage(this.dolphinOnLand);
            }
        } else if (this.isDolphin.contains(user)) {
            if (user.isOnline()) {
                user.getPlayer().playEffect(EntityEffect.ENTITY_POOF);
                PowerTools.removeDisguise((Entity)user.getPlayer());
                user.sendMessage(this.turnToHuman);
            }
            this.isDolphin.remove(user);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onMove(PlayerMoveEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this)) {
            Block block = user.getPlayer().getEyeLocation().getBlock();
            if (this.isWater(block)) {
                if (!this.nvList.contains(user)) {
                    if (user.getOption(this.nv).booleanValue()) {
                        user.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, 0));
                    }
                    if (user.getOption(this.heal).booleanValue()) {
                        user.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, Integer.MAX_VALUE, 0));
                    }
                    user.addPotionEffect(new PotionEffect(PotionEffectType.DOLPHINS_GRACE, Integer.MAX_VALUE, 0));
                    user.addPotionEffect(new PotionEffect(PotionEffectType.WATER_BREATHING, Integer.MAX_VALUE, 0));
                    this.nvList.add(user);
                }
            } else {
                if (this.isDolphin.contains(user)) {
                    this.setDolphin(user, false);
                }
                if (this.nvList.contains(user)) {
                    if (user.getOption(this.nv).booleanValue()) {
                        user.removePotionEffect(PotionEffectType.NIGHT_VISION);
                    }
                    if (user.getOption(this.heal).booleanValue()) {
                        user.removePotionEffect(PotionEffectType.REGENERATION);
                    }
                    user.removePotionEffect(PotionEffectType.DOLPHINS_GRACE);
                    user.removePotionEffect(PotionEffectType.WATER_BREATHING);
                    this.nvList.remove(user);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onSwim(EntityToggleSwimEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this) && user.getOption(this.canDolphin).booleanValue()) {
            this.setDolphin(user, event.isSwimming());
        }
    }
}

