/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.passive;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@PowerManifest(name="Acrobat", type=PowerType.PASSIVE, author="sirrus86", concept="Air_spike", icon=Material.FEATHER, description="Jump much higher than other players and take no damage from falls. By [act:item]ing with [item], can adjust jump height.")
public final class Acrobat
extends Power {
    private Map<PowerUser, Integer> effectPower;
    private PowerOption<List<String>> effectTypes;
    private PowerOption<List<String>> negateTypes;
    private PowerOption<Integer> maxEffect;
    private String effectPwr;
    private String effectOff;

    @Override
    protected void onEnable() {
        this.effectPower = new HashMap<PowerUser, Integer>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.effectPower.containsKey(user) && this.effectPower.get(user) > -1) {
            this.effectPower.remove(user);
            user.removePotionEffect(PotionEffectType.JUMP);
        }
    }

    @Override
    protected void config() {
        this.effectTypes = this.option("effect-types", Lists.newArrayList((Object[])new String[]{"JUMP"}), "Effects to be controlled with this power.");
        this.item = this.option("item", new ItemStack(Material.FEATHER), "Item used to change jump levels.");
        this.maxEffect = this.option("max-effect-level", 3, "Maximum effect level user can achieve.");
        this.negateTypes = this.option("negate-damage-types", Lists.newArrayList((Object[])new String[]{"FALL"}), "Damage types to be negated by this power.");
        this.effectOff = this.locale("message.effect-off", ChatColor.YELLOW + "[type] power turned off.");
        this.effectPwr = this.locale("message.effect-power", ChatColor.YELLOW + "[type] power set to [amount].");
        this.supplies(this.getRequiredItem());
    }

    @EventHandler(ignoreCancelled=true)
    private void reduceFall(EntityDamageEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this) && user.getOption(this.negateTypes).contains(event.getCause().name())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        if (event.getPower() == this) {
            PowerUser user = event.getUser();
            if (!this.effectPower.containsKey(user)) {
                this.effectPower.put(user, -1);
            }
            this.effectPower.put(user, this.effectPower.get(user) < user.getOption(this.maxEffect) ? this.effectPower.get(user) + 1 : -1);
            for (String effect : user.getOption(this.effectTypes)) {
                PotionEffectType type = PotionEffectType.getByName((String)effect);
                if (this.effectPower.get(user) >= 0) {
                    user.sendMessage(this.effectPwr.replace("[type]", PowerTools.getPotionEffectName(type)).replace("[amount]", Integer.toString(this.effectPower.get(user) + 1)));
                    user.addPotionEffect(new PotionEffect(type, Integer.MAX_VALUE, this.effectPower.get(user).intValue()));
                    continue;
                }
                user.removePotionEffect(type);
                user.sendMessage(this.effectOff.replace("[type]", PowerTools.getPotionEffectName(type)));
            }
        }
    }
}

