/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.passive;

import java.util.List;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@PowerManifest(name="Acid Blood", type=PowerType.PASSIVE, author="sirrus86", concept="Gamekills99", icon=Material.EXPERIENCE_BOTTLE, description="Absorb [absorb.percentage]% of incoming poison damage.[afflict-attackers] When struck by a melee attack, attacker becomes poisoned for 5 seconds.[/afflict-attackers]")
public final class AcidBlood
extends Power {
    private PowerOption<Double> absorb;
    private PowerOption<List<String>> absorbTypes;
    private PowerOption<Boolean> afflict;

    @Override
    protected void config() {
        this.absorb = this.option("absorb.percentage", 100.0, "Percent of poison damage to be absorbed as health.");
        this.absorbTypes = this.option("absorb.types", List.of("POISON"), "Damage types to absorb.");
        this.afflict = this.option("afflict-attackers", true, "Whether to afflict attackers with status effects.");
        this.cooldown = this.option("cooldown", PowerTime.toMillis(0), "Period of time before an attacker can be afflicted again.");
    }

    @EventHandler(ignoreCancelled=true)
    private void onDmg(EntityDamageEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this) && user.getOption(this.absorbTypes).contains(event.getCause().name())) {
            double abs = event.getDamage() * (user.getOption(this.absorb) / 100.0);
            user.heal(abs);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onDmg(EntityDamageByEntityEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this) && user.getOption(this.afflict).booleanValue() && user.getCooldown(this) <= 0L && event.getDamager() instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)event.getDamager();
            target.addPotionEffect(new PotionEffect(PotionEffectType.POISON, PowerTime.toTicks(5, 0), 1, false, true, true));
            user.setCooldown(this, (Long)user.getOption(this.cooldown));
        }
    }
}

