/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.offense;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

@PowerManifest(name="Trickshot", type=PowerType.OFFENSE, author="sirrus86", concept="sirrus86", icon=Material.BOW, usesPackets=true, description="While holding a bow at maximum power, targets are highlighted. Upon release, the arrow will attempt to home in on the highlighted target.")
public final class Trickshot
extends Power {
    private Map<PowerUser, Integer> aiming;
    private Map<Entity, Integer> arrows;
    private Map<PowerUser, LivingEntity> targets;
    private PowerOption<Double> maxDist;
    private PowerOption<Double> maxAngle;
    private PowerOption<Boolean> targetAnimals;
    private PowerOption<Boolean> targetMonsters;
    private PowerOption<Boolean> targetPlayers;
    private PowerOption<Boolean> targetVillagers;
    private PowerOption<Long> targetDelay;
    private PowerStat targetsHit;

    @Override
    protected void onEnable() {
        this.aiming = new ConcurrentHashMap<PowerUser, Integer>();
        this.arrows = new HashMap<Entity, Integer>();
        this.targets = new HashMap<PowerUser, LivingEntity>();
    }

    @Override
    protected void onDisable() {
        super.onDisable();
        for (Entity arrow : this.arrows.keySet()) {
            this.cancelTask(this.arrows.get(arrow));
        }
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.aiming.containsKey(user)) {
            this.cancelTask(this.aiming.get(user));
        }
        if (this.targets.containsKey(user)) {
            PowerTools.showAsSpectral(user.getPlayer(), (Entity)this.targets.get(user), ChatColor.WHITE, false);
        }
    }

    @Override
    protected void config() {
        this.maxDist = this.option("maximum-target-distance", 50.0, "Maximum distance for which targets can be chosen.");
        this.maxAngle = this.option("maximum-angle", 0.12, "Maximum rotational angle homing arrows will turn.");
        this.targetAnimals = this.option("target-animals", false, "Whether animals should be targetted by ricochet arrows.");
        this.targetDelay = this.option("target-delay", PowerTime.toMillis(1, 500), "How long after aiming bow before target acquisition should begin.");
        this.targetMonsters = this.option("target-monsters", true, "Whether monsters should be targetted by ricochet arrows.");
        this.targetPlayers = this.option("target-players", true, "Whether players should be targetted by ricochet arrows.");
        this.targetsHit = this.stat("targets-hit", 50, "Targets hit with homing arrows", "Arrows that miss will often ricochet.");
        this.targetVillagers = this.option("target-villagers", false, "Whether villagers should be targetted by ricochet arrows.");
        this.supplies(new ItemStack(Material.BOW, 1), new ItemStack(Material.ARROW, 64));
    }

    private Runnable homingTask(final Entity arrow, final LivingEntity target) {
        return new BukkitRunnable(){

            public void run() {
                if (target.isValid() && !target.isDead()) {
                    Vector newVelocity;
                    double speed = arrow.getVelocity().length();
                    Vector toTarget = target.getEyeLocation().clone().subtract(arrow.getLocation()).toVector();
                    Vector dirVelocity = arrow.getVelocity().clone().normalize();
                    Vector dirToTarget = toTarget.clone().normalize();
                    double angle = dirVelocity.angle(dirToTarget);
                    double newSpeed = 0.9 * speed + 0.14;
                    if (angle < (Double)Trickshot.this.getOption(Trickshot.this.maxAngle)) {
                        newVelocity = dirVelocity.clone().multiply(newSpeed);
                    } else {
                        Vector newDir = dirVelocity.clone().multiply((angle - (Double)Trickshot.this.getOption(Trickshot.this.maxAngle)) / angle).add(dirToTarget.clone().multiply((Double)Trickshot.this.getOption(Trickshot.this.maxAngle) / angle));
                        newDir.normalize();
                        newVelocity = newDir.clone().multiply(newSpeed);
                    }
                    arrow.setVelocity(newVelocity.add(new Vector(0.0, 0.03, 0.0)));
                    Trickshot.this.arrows.put(arrow, Trickshot.this.getInstance().runTaskLater(Trickshot.this.homingTask(arrow, target), 1L).getTaskId());
                }
            }
        };
    }

    private Runnable targetTask(final PowerUser user) {
        return new BukkitRunnable(){

            public void run() {
                if (Trickshot.this.aiming.containsKey(user)) {
                    LivingEntity target = user.getTargetEntity(LivingEntity.class, (Double)user.getOption(Trickshot.this.maxDist));
                    if (target != null) {
                        if (Trickshot.this.targets.containsKey(user) && Trickshot.this.targets.get(user) != target) {
                            PowerTools.showAsSpectral(user.getPlayer(), (Entity)Trickshot.this.targets.get(user), ChatColor.WHITE, false);
                        }
                        Trickshot.this.targets.put(user, target);
                        PowerTools.showAsSpectral(user.getPlayer(), (Entity)target, ChatColor.WHITE, true);
                    }
                    Trickshot.this.aiming.put(user, Trickshot.this.getInstance().runTaskLater(Trickshot.this.targetTask(user), 1L).getTaskId());
                }
            }
        };
    }

    @EventHandler
    private void onShoot(EntityShootBowEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && this.aiming.containsKey(user = this.getUser((OfflinePlayer)((Player)event.getEntity())))) {
            this.cancelTask(this.aiming.get(user));
            if (this.targets.containsKey(user)) {
                this.arrows.put(event.getProjectile(), this.runTaskLater(this.homingTask(event.getProjectile(), this.targets.get(user)), 3L).getTaskId());
                PowerTools.showAsSpectral(user.getPlayer(), (Entity)this.targets.get(user), ChatColor.WHITE, false);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onChange(PlayerItemHeldEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this) && this.aiming.containsKey(user)) {
            this.cancelTask(this.aiming.get(user));
            if (this.targets.containsKey(user)) {
                PowerTools.showAsSpectral(user.getPlayer(), (Entity)this.targets.get(user), ChatColor.WHITE, false);
            }
        }
    }

    @EventHandler
    private void onAim(PlayerInteractEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this) && event.getItem() != null && event.getItem().getType() == Material.BOW && event.getAction().name().startsWith("RIGHT")) {
            this.aiming.put(user, this.runTaskLater(this.targetTask(user), PowerTime.toTicks(user.getOption(this.targetDelay))).getTaskId());
        }
    }

    @EventHandler
    private void onHit(ProjectileHitEvent event) {
        if (event.getEntity() instanceof Arrow) {
            PowerUser user;
            Arrow arrow = (Arrow)event.getEntity();
            if (this.arrows.containsKey(arrow)) {
                this.cancelTask(this.arrows.get(arrow));
            }
            if (arrow.getShooter() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)arrow.getShooter()))).allowPower(this)) {
                float speed;
                if (event.getHitEntity() != null && this.arrows.containsKey(arrow)) {
                    user.increaseStat(this.targetsHit, 1);
                } else if (event.getHitBlock() != null && user.hasStatMaxed(this.targetsHit) && (speed = (float)arrow.getVelocity().length()) > 2.0f) {
                    Predicate<Entity> pred = entity -> !(!(entity instanceof LivingEntity) || entity == arrow || entity == user.getPlayer() || user.getOption(this.targetAnimals) == false && entity instanceof Animals || user.getOption(this.targetMonsters) == false && entity instanceof Monster || user.getOption(this.targetPlayers) == false && entity instanceof Player || user.getOption(this.targetVillagers) == false && entity instanceof AbstractVillager);
                    LivingEntity target = null;
                    Vector direction = null;
                    double getMaxDist = user.getOption(this.maxDist);
                    List entities = arrow.getNearbyEntities(getMaxDist / 3.0, getMaxDist / 3.0, getMaxDist / 3.0);
                    Collections.shuffle(entities);
                    for (Entity entity2 : entities) {
                        if (!(entity2 instanceof LivingEntity)) continue;
                        Location targetLoc = entity2.getLocation().clone();
                        direction = targetLoc.subtract(arrow.getLocation()).toVector().normalize();
                        target = PowerTools.getTargetEntity(LivingEntity.class, arrow.getLocation(), direction, getMaxDist / 3.0, pred);
                        if (target == null) continue;
                        break;
                    }
                    if (target != null && direction != null) {
                        Arrow newArrow = arrow.getWorld().spawnArrow(arrow.getLocation(), direction, speed * 0.9f, 0.0f);
                        newArrow.setShooter((ProjectileSource)user.getPlayer());
                        arrow.remove();
                    }
                }
            }
        }
    }
}

