/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.offense;

import java.util.HashMap;
import java.util.Map;
import me.sirrus86.s86powers.config.ConfigOption;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Soul Siphon", type=PowerType.OFFENSE, author="sirrus86", concept="sirrus86", icon=Material.END_CRYSTAL, usesPackets=true, description="[act:item]ing the top of a block while holding [item] will place a Soul Siphon. Soul Siphons will drain health from nearby entities before returning the drained health to you. [cooldown] cooldown.")
public final class SoulSiphon
extends Power {
    private Map<PowerUser, Siphon> siphons;
    private PowerOption<Double> drainRange;
    private PowerOption<Double> maxLife;

    @Override
    protected void onEnable() {
        this.siphons = new HashMap<PowerUser, Siphon>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.siphons.containsKey(user)) {
            this.siphons.get(user).destroy();
        }
    }

    @Override
    protected void config() {
        this.cooldown = this.option("cooldown", PowerTime.toMillis(30, 0), "Amount of time before power can be used again.");
        this.drainRange = this.option("drain-range", 15.0, "Maximum range from which siphons can drain or feed health.");
        this.item = this.option("item", new ItemStack(Material.END_CRYSTAL), "Item used to create soul siphons.");
        this.maxLife = this.option("maximum-life", 10.0, "Maximum total amount of life siphons can drain from all targets.");
        this.supplies(new ItemStack(this.getRequiredItem().getType(), 1));
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        if (event.getPower() == this && event.getClickedBlock() != null && event.getBlockFace() == BlockFace.UP && event.getClickedBlock().getRelative(BlockFace.UP).isEmpty()) {
            PowerUser user = event.getUser();
            if (user.getCooldown(this) <= 0L) {
                if (this.siphons.containsKey(user)) {
                    this.siphons.get(user).destroy();
                }
                Block block = event.getClickedBlock().getRelative(BlockFace.UP);
                EnderCrystal crystal = (EnderCrystal)block.getWorld().spawn(block.getLocation(), EnderCrystal.class);
                Siphon siphon = new Siphon(user, crystal);
                this.siphons.put(user, siphon);
                user.setCooldown(this, (Long)user.getOption(this.cooldown));
            } else {
                user.showCooldown(this);
            }
        }
    }

    private class Siphon
    implements Listener {
        private final EnderCrystal crystal;
        private int drainCD = 0;
        private int drainTask = -1;
        private double life = 0.0;
        private final PowerUser owner;
        private LivingEntity target = null;
        private Runnable doDrain = new BukkitRunnable(){

            public void run() {
                if (Siphon.this.drainCD > 0) {
                    Siphon.this.drainCD--;
                }
                Siphon.this.updateHealth();
                if (Siphon.this.owner.getPlayer().getWorld().equals(Siphon.this.crystal.getWorld()) && Siphon.this.owner.getPlayer().getLocation().distanceSquared(Siphon.this.crystal.getLocation()) < (Double)Siphon.this.owner.getOption(SoulSiphon.this.drainRange) * (Double)Siphon.this.owner.getOption(SoulSiphon.this.drainRange) && Siphon.this.owner.getPlayer().getHealth() < Siphon.this.owner.getPlayer().getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() && !Siphon.this.owner.getPlayer().isDead() && Siphon.this.life > 0.0) {
                    Siphon.this.crystal.setBeamTarget(Siphon.this.owner.getPlayer().getLocation().clone().subtract(0.0, 1.0, 0.0));
                    if (Siphon.this.drainCD <= 0) {
                        Siphon.access$510(Siphon.this);
                        Siphon.this.owner.heal(1.0);
                        Siphon.this.drainCD = 10;
                    }
                } else if (Siphon.this.target != null && !Siphon.this.target.isDead() && Siphon.this.target.getLocation().distanceSquared(Siphon.this.crystal.getLocation()) < (Double)Siphon.this.owner.getOption(SoulSiphon.this.drainRange) * (Double)Siphon.this.owner.getOption(SoulSiphon.this.drainRange) && Siphon.this.life < (Double)Siphon.this.owner.getOption(SoulSiphon.this.maxLife)) {
                    Siphon.this.crystal.setBeamTarget(Siphon.this.target.getLocation().clone().subtract(0.0, 1.0, 0.0));
                    if (Siphon.this.drainCD <= 0) {
                        Siphon.access$508(Siphon.this);
                        Siphon.this.owner.causeDamage(SoulSiphon.this.getInstance(), (Damageable)Siphon.this.target, EntityDamageEvent.DamageCause.MAGIC, 1.0);
                        Siphon.this.drainCD = 10;
                    }
                } else {
                    Siphon.this.crystal.setBeamTarget(null);
                    Siphon.this.target = PowerTools.getRandomEntity((Entity)Siphon.this.crystal, (double)((Double)Siphon.this.owner.getOption(SoulSiphon.this.drainRange)), new LivingEntity[]{Siphon.this.owner.getPlayer()});
                }
            }
        };

        public Siphon(PowerUser owner, EnderCrystal crystal) {
            SoulSiphon.this.registerEvents(this);
            this.crystal = crystal;
            this.owner = owner;
            this.updateHealth();
            this.drainTask = SoulSiphon.this.runTaskTimer(this.doDrain, 0L, 0L).getTaskId();
        }

        public void destroy() {
            SoulSiphon.this.cancelTask(this.drainTask);
            PowerTools.fakeExplosion(this.crystal.getLocation(), 3.0f);
            this.crystal.remove();
            SoulSiphon.this.unregisterEvents(this);
            SoulSiphon.this.siphons.remove(this.owner);
        }

        private void updateHealth() {
            String tmp = "";
            double i = this.life / 2.0;
            double j = (Double)this.owner.getOption(SoulSiphon.this.maxLife) / 2.0;
            int k = 0;
            while ((double)k < j) {
                if (i > 0.0) {
                    tmp = tmp + ChatColor.RED;
                    i -= 1.0;
                } else {
                    tmp = tmp + ChatColor.GRAY;
                }
                tmp = tmp + "\u2665";
                ++k;
            }
            this.crystal.setCustomName(tmp);
            this.crystal.setCustomNameVisible(true);
        }

        @EventHandler(ignoreCancelled=true)
        private void onDamage(EntityDamageEvent event) {
            if (event.getEntity() == this.crystal && this.life >= event.getDamage()) {
                this.life -= event.getDamage();
                this.updateHealth();
                event.setCancelled(true);
            }
        }

        @EventHandler(ignoreCancelled=true)
        private void onExplode(EntityExplodeEvent event) {
            if (event.getEntity() == this.crystal) {
                if (ConfigOption.Powers.PREVENT_GRIEFING) {
                    event.blockList().clear();
                }
                this.destroy();
            }
        }

        static /* synthetic */ double access$510(Siphon x0) {
            double d = x0.life;
            x0.life = d - 1.0;
            return d;
        }

        static /* synthetic */ double access$508(Siphon x0) {
            double d = x0.life;
            x0.life = d + 1.0;
            return d;
        }
    }
}

