/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.offense;

import java.util.HashMap;
import java.util.Map;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

@PowerManifest(name="Shuriken", type=PowerType.OFFENSE, author="sirrus86", concept="n33dy1", icon=Material.FLINT, usesPackets=true, description="[act:item]ing while holding [item] throws it like a shuriken. Shuriken that hit enemies will deal [damage] damage to them.[pEither] If the victim is[penetrate-armor] wearing armor[/penetrate-armor][pBoth] or[/pBoth][penetrate-blocking] blocking[/penetrate-blocking] it will harmlessly bounce off.[/pEither]")
public final class Shuriken
extends Power {
    private Map<Snowball, PowerUser> shurikens;
    private PowerOption<Double> damage;
    private PowerOption<Boolean> drop;
    private PowerOption<Boolean> pArmor;
    private PowerOption<Boolean> pBlock;
    private boolean pBoth;
    private boolean pEither;

    @Override
    protected void onEnable() {
        this.shurikens = new HashMap<Snowball, PowerUser>();
    }

    @Override
    protected void config() {
        this.cooldown = this.option("cooldown", PowerTime.toMillis(5), "Amount of time before power can be used again.");
        this.damage = this.option("damage", 3.0, "Amount of damage caused by shurikens.");
        this.drop = this.option("drop-after-impact", true, "Whether thrown shuriken should become an item drop after hitting something.");
        this.item = this.option("item", new ItemStack(Material.FLINT), "Item to be thrown as a shuriken.");
        this.pArmor = this.option("penetrate-armor", false, "Whether shurikens should penetrate armor.");
        this.pBlock = this.option("penetrate-blocking", false, "Whether shurikens should penetrate blocking.");
        this.pBoth = this.getOption(this.pArmor) != false && this.getOption(this.pBlock) != false;
        this.pEither = this.getOption(this.pArmor) != false || this.getOption(this.pBlock) != false;
        this.supplies(new ItemStack(this.getRequiredItem().getType(), this.getRequiredItem().getMaxStackSize()));
    }

    private boolean hasArmor(LivingEntity entity) {
        EntityEquipment inv = entity.getEquipment();
        for (ItemStack item : inv.getArmorContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            return true;
        }
        return false;
    }

    @EventHandler
    private void onDmg(EntityDamageByEntityEvent event) {
        if (this.shurikens.containsKey(event.getDamager()) && event.getEntity() instanceof LivingEntity) {
            Snowball shuriken = (Snowball)event.getDamager();
            PowerUser user = this.shurikens.get(shuriken);
            LivingEntity target = (LivingEntity)event.getEntity();
            if (!user.getOption(this.pArmor).booleanValue() && this.hasArmor(target) || !user.getOption(this.pBlock).booleanValue() && target instanceof Player && ((Player)target).isBlocking()) {
                target.getWorld().playSound(shuriken.getLocation(), Sound.BLOCK_ANVIL_LAND, 1.0f, 1.0f);
                if (user.getOption(this.drop).booleanValue()) {
                    shuriken.getWorld().dropItemNaturally(shuriken.getLocation(), this.getRequiredItem());
                }
                event.setCancelled(true);
            } else {
                event.setDamage(user.getOption(this.damage).doubleValue());
            }
            this.shurikens.remove(shuriken);
            shuriken.remove();
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        PowerUser user;
        if (event.getPower() == this && (user = event.getUser()).allowPower(this) && user.getCooldown(this) <= 0L) {
            event.consumeItem();
            Snowball shuriken = (Snowball)user.getPlayer().launchProjectile(Snowball.class);
            shuriken.setVelocity(user.getPlayer().getEyeLocation().getDirection().clone().normalize().multiply(3));
            this.shurikens.put(shuriken, user);
            PowerTools.addDisguise((Entity)shuriken, (ItemStack)user.getOption(this.item));
        }
    }

    @EventHandler
    private void onHit(ProjectileHitEvent event) {
        if (this.shurikens.containsKey(event.getEntity())) {
            Snowball shuriken = (Snowball)event.getEntity();
            if (event.getHitEntity() == null && this.shurikens.get(shuriken).getOption(this.drop).booleanValue()) {
                shuriken.getWorld().dropItemNaturally(shuriken.getLocation(), (ItemStack)this.shurikens.get(shuriken).getOption(this.item));
                this.shurikens.remove(shuriken);
                shuriken.remove();
            }
        }
    }
}

