/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.offense;

import java.util.HashMap;
import java.util.Map;
import me.sirrus86.s86powers.events.PowerIgniteEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Pyro Bow", type=PowerType.OFFENSE, author="sirrus86", concept="FyreCat", icon=Material.BOW, description="All arrows fired ignite their targets[ignite-blocks], or the block they hit if they miss[/ignite-blocks].[disable-power-if-wet] Cannot use power if you've been in water or rain within the last [wet-cooldown].[/disable-power-if-wet]")
public final class PyroBow
extends Power {
    private Map<Arrow, Boolean> arrows;
    private Map<Arrow, Integer> tasks;
    private PowerStat canExplode;
    private PowerOption<Double> explodeRad;
    private PowerOption<Boolean> disableIfWet;
    private PowerOption<Boolean> igniteBlocks;

    @Override
    protected void onEnable() {
        this.arrows = new HashMap<Arrow, Boolean>();
        this.tasks = new HashMap<Arrow, Integer>();
    }

    @Override
    protected void config() {
        this.canExplode = this.stat("enemies-ignited", 50, "Enemies ignited", "Arrows now explode, covering the nearby area in flames.");
        this.cooldown = this.option("wet-cooldown", PowerTime.toMillis(5, 0), "How long after being wet before power can be used again.");
        this.disableIfWet = this.option("disable-power-if-wet", true, "Whether the power should fail if the user has been exposed to rain or water recently.");
        this.explodeRad = this.option("explosion-radius", 3.0, "Radius of explosion when arrows are superpowered.");
        this.igniteBlocks = this.option("ignite-blocks", true, "Whether arrows should ignite blocks they hit.");
        this.supplies(new ItemStack(Material.BOW), new ItemStack(Material.ARROW, 64));
    }

    private Runnable doSmoke(final Arrow arrow) {
        return new BukkitRunnable(){

            public void run() {
                if (arrow.isValid()) {
                    arrow.getWorld().spawnParticle(Particle.LAVA, arrow.getLocation(), 1);
                }
            }
        };
    }

    @EventHandler(ignoreCancelled=true)
    private void onShoot(EntityShootBowEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this) && user.getCooldown(this) <= 0L && event.getProjectile() instanceof Arrow) {
            Arrow arrow = (Arrow)event.getProjectile();
            this.arrows.put(arrow, user.hasStatMaxed(this.canExplode));
            this.tasks.put(arrow, this.runTaskTimer(this.doSmoke(arrow), 0L, 1L).getTaskId());
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onMove(PlayerMoveEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.getOption(this.disableIfWet).booleanValue() && user.allowPower(this) && (event.getTo().getBlock().getType() == Material.WATER || PowerTools.isOutside(event.getTo()) && event.getTo().getWorld().hasStorm())) {
            user.setCooldown(this, (Long)user.getOption(this.cooldown));
        }
    }

    @EventHandler
    private void onHit(ProjectileHitEvent event) {
        if (this.arrows.containsKey(event.getEntity())) {
            Arrow arrow = (Arrow)event.getEntity();
            PowerUser user = this.getUser((OfflinePlayer)((Player)arrow.getShooter()));
            if (event.getHitBlock() != null && user.getOption(this.igniteBlocks).booleanValue()) {
                this.callEvent(new PowerIgniteEvent(this, user, arrow.getLocation().getBlock(), null));
            } else if (event.getHitEntity() != null) {
                this.callEvent(new PowerIgniteEvent(this, user, (Entity)event.getEntity()));
                user.increaseStat(this.canExplode, 1);
            }
            if (this.arrows.get(arrow).booleanValue()) {
                arrow.getWorld().spawnParticle(Particle.EXPLOSION_HUGE, arrow.getLocation(), 1);
                for (Block block : PowerTools.getNearbyBlocks(arrow.getLocation(), user.getOption(this.explodeRad))) {
                    this.callEvent(new PowerIgniteEvent(this, user, block, BlockFace.SELF));
                }
            }
            this.arrows.remove(arrow);
            this.cancelTask(this.tasks.get(arrow));
            this.tasks.remove(arrow);
        }
    }
}

