/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.offense;

import java.util.List;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.tools.version.MCVersion;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

@PowerManifest(name="Polar Blade", type=PowerType.OFFENSE, author="sirrus86", concept="bobby16may", version=MCVersion.v1_14, icon=Material.IRON_SWORD, description="Able to craft Polar Blades. Polar Blades require a sword and snow materials. When crafted, comes equipped with a Sharpness enchant. Attacks with a Polar Blade also slow enemies.")
public final class PolarBlade
extends Power {
    private String effectDesc;
    private final NamespacedKey isPolar = this.createNamespacedKey("is-polar-blade");
    private final NamespacedKey pBladeEffectAmps = this.createNamespacedKey("slow-amp");

    @Override
    protected void config() {
        this.effectDesc = this.locale("message.effect-descriptor", ChatColor.RED + "[effect] [power] ([time])");
        this.supplies(new ItemStack(Material.IRON_SWORD), new ItemStack(Material.ICE, 16), new ItemStack(Material.SNOW_BLOCK, 16));
    }

    private ItemStack createPBlade(PowerUser user, ItemStack[] matrix) {
        ItemStack sword = null;
        int slow = 0;
        int sharpness = 0;
        for (int i = 0; i < matrix.length; ++i) {
            ItemStack stack = matrix[i];
            if (stack == null || stack.getType() == Material.AIR) continue;
            if (PowerTools.isSword(stack)) {
                sword = stack.clone();
                continue;
            }
            if (stack.getType() == Material.ICE) {
                ++sharpness;
                continue;
            }
            if (stack.getType() == Material.SNOWBALL) {
                ++slow;
                continue;
            }
            if (stack.getType() != Material.SNOW_BLOCK) continue;
            slow += 3;
        }
        if (sword != null) {
            ItemMeta meta = sword.hasItemMeta() ? this.getRequiredItem().getItemMeta() : Bukkit.getServer().getItemFactory().getItemMeta(sword.getType());
            meta.setDisplayName(ChatColor.RESET + this.getName());
            meta.getPersistentDataContainer().set(this.isPolar, PersistentDataType.BYTE, (Object)1);
            if (sharpness > 0) {
                meta.addEnchant(Enchantment.DAMAGE_ALL, sharpness, true);
            }
            if (slow > 0) {
                meta.getPersistentDataContainer().set(this.pBladeEffectAmps, PersistentDataType.INTEGER, (Object)(--slow));
                String effectText = this.effectDesc.replace("[effect]", "Slowness").replace("[power]", PowerTools.getRomanNumeral(slow)).replace("[time]", PowerTime.asClock(PowerTime.toMillis(3, 0), false, false, true, true, false));
                meta.setLore(List.of(effectText));
            }
            sword.setItemMeta(meta);
        }
        return sword;
    }

    private boolean hasPBlade(LivingEntity entity) {
        ItemStack sword = entity instanceof Player ? ((Player)entity).getInventory().getItemInMainHand() : entity.getEquipment().getItemInMainHand();
        return sword != null && this.isPBlade(sword);
    }

    private boolean isPBlade(ItemStack sword) {
        return PowerTools.isSword(sword) && sword.hasItemMeta() && sword.getItemMeta().getPersistentDataContainer().has(this.isPolar, PersistentDataType.BYTE);
    }

    private boolean isPBladeRecipe(PowerUser user, ItemStack[] matrix) {
        boolean broken = false;
        boolean hasMats = false;
        boolean hasSword = false;
        for (int i = 0; i < matrix.length; ++i) {
            ItemStack stack = matrix[i];
            if (stack == null || stack.getType() == Material.AIR) continue;
            if (!(!PowerTools.isSword(stack) || stack.hasItemMeta() && stack.getItemMeta().hasEnchants())) {
                if (!hasSword) {
                    hasSword = true;
                    continue;
                }
                broken = true;
                break;
            }
            if (stack.getType() == Material.ICE || stack.getType() == Material.SNOWBALL || stack.getType() == Material.SNOW_BLOCK) {
                hasMats = true;
                continue;
            }
            broken = true;
            break;
        }
        return !broken && hasMats && hasSword;
    }

    @EventHandler(ignoreCancelled=true)
    private void onDamage(EntityDamageByEntityEvent event) {
        LivingEntity damager;
        if (event.getDamager() instanceof LivingEntity && event.getEntity() instanceof LivingEntity && this.hasPBlade(damager = (LivingEntity)event.getDamager())) {
            if (damager instanceof Player) {
                PowerUser user = this.getUser((OfflinePlayer)((Player)damager));
                user.causeDamage(this, event);
            }
            ItemStack sword = damager instanceof Player ? ((Player)damager).getInventory().getItemInMainHand() : damager.getEquipment().getItemInMainHand();
            LivingEntity entity = (LivingEntity)event.getEntity();
            int slowAmp = (Integer)sword.getItemMeta().getPersistentDataContainer().get(this.pBladeEffectAmps, PersistentDataType.INTEGER);
            entity.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, PowerTime.toTicks(3, 0), slowAmp));
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onClick(InventoryClickEvent event) {
        PowerUser user;
        if (event.getWhoClicked() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getWhoClicked()))).allowPower(this) && event.getInventory() instanceof CraftingInventory) {
            final CraftingInventory inv = (CraftingInventory)event.getInventory();
            this.runTaskLater(new Runnable(){

                @Override
                public void run() {
                    if (PolarBlade.this.isPBladeRecipe(user, inv.getMatrix())) {
                        inv.setResult(PolarBlade.this.createPBlade(user, inv.getMatrix()));
                        user.getPlayer().updateInventory();
                    }
                }
            }, 1L);
            if (event.getCurrentItem() != null && this.isPBlade(event.getCurrentItem()) && event.getSlotType() == InventoryType.SlotType.RESULT) {
                if (event.isShiftClick()) {
                    event.getView().getBottomInventory().addItem(new ItemStack[]{event.getCurrentItem()});
                    inv.setMatrix(new ItemStack[inv.getMatrix().length]);
                    inv.setResult(null);
                    user.getPlayer().updateInventory();
                } else if (event.getCursor() == null || event.getCursor().getType() == Material.AIR) {
                    event.setCursor(event.getCurrentItem());
                    inv.setMatrix(new ItemStack[inv.getMatrix().length]);
                    inv.setResult(null);
                    user.getPlayer().updateInventory();
                }
            }
        }
    }
}

