/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.offense;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

@PowerManifest(name="Laser", type=PowerType.OFFENSE, author="sirrus86", concept="n33dy1", icon=Material.DISPENSER, description="[act:item]ing while holding [item] shoots a laser in front of you. The laser can penetrate walls and will constantly damage enemies.[use-consumable] Consumes [consumable] as fuel.[/use-consumable] [cooldown] cooldown.")
public final class Laser
extends Power {
    private Map<PowerUser, Beam> lasers;
    private PowerOption<Double> damage;
    private PowerOption<Double> dist;
    private PowerOption<Integer> laserBlue;
    private PowerOption<Integer> laserGreen;
    private PowerOption<Integer> laserRed;
    private PowerOption<Boolean> useConsume;

    @Override
    protected void onEnable() {
        this.lasers = new HashMap<PowerUser, Beam>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.lasers.containsKey(user)) {
            Beam laser = this.lasers.get(user);
            laser.disable();
        }
    }

    @Override
    protected void config() {
        this.consumable = this.option("consumable", new ItemStack(Material.REDSTONE, 1), "Item used as fuel for the laser.");
        this.cooldown = this.option("cooldown", PowerTime.toMillis(10, 0), "Amount of time before power can be used again.");
        this.damage = this.option("damage", 5.0, "Amount of damage done by laser beams.");
        this.dist = this.option("laser-distance", 10.0, "Maximum distance a laser can travel.");
        this.item = this.option("item", new ItemStack(Material.DISPENSER), "Item used to start/stop firing the laser.");
        this.laserBlue = this.option("color.blue", 0, "Blue value for laser color. Values below 0 or above 255 may provide unexpected results.");
        this.laserGreen = this.option("color.green", 255, "Green value for laser color. Values below 0 or above 255 may provide unexpected results.");
        this.laserRed = this.option("color.red", 255, "Red value for laser color. Values below 0 or above 255 may provide unexpected results.");
        this.useConsume = this.option("use-consumable", true, "Whether consumable item should be required and consumed when laser is used.");
        this.supplies(this.getRequiredItem(), new ItemStack(this.getConsumable().getType(), this.getConsumable().getMaxStackSize()));
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        PowerUser user;
        if (event.getPower() == this && (user = event.getUser()).allowPower(this)) {
            if (!this.lasers.containsKey(user)) {
                if (user.getCooldown(this) <= 0L) {
                    Beam laser = new Beam(user);
                    this.lasers.put(user, laser);
                } else {
                    user.showCooldown(this);
                }
            } else {
                Beam laser = this.lasers.get(user);
                laser.disable();
            }
        }
    }

    private class Beam {
        private final PowerUser owner;
        private final int task;
        private Runnable doBeam = new BukkitRunnable(){

            public void run() {
                if (!((Boolean)Beam.this.owner.getOption(Laser.this.useConsume)).booleanValue() || Beam.this.owner.getPlayer().getInventory().containsAtLeast(Laser.this.getConsumable(), 1)) {
                    Location loc = Beam.this.owner.getPlayer().getEyeLocation().add(0.0, -0.5, 0.0);
                    loc.getWorld().playSound(loc, Sound.ENTITY_FIREWORK_ROCKET_LAUNCH, 1.0f, 1.0f);
                    double getDist = (Double)Beam.this.owner.getOption(Laser.this.dist);
                    List entities = Beam.this.owner.getPlayer().getNearbyEntities(getDist, getDist, getDist);
                    Vector dir = loc.getDirection();
                    int i = 0;
                    while ((double)i < (Double)Beam.this.owner.getOption(Laser.this.dist) * 10.0) {
                        Vector newDir = dir.clone().multiply((double)i * 0.1);
                        loc.add(newDir);
                        PowerTools.playRedstoneEffect(loc, new Vector(0, 0, 0), 1, new Particle.DustOptions(Color.fromRGB((int)((Integer)Beam.this.owner.getOption(Laser.this.laserRed)), (int)((Integer)Beam.this.owner.getOption(Laser.this.laserGreen)), (int)((Integer)Beam.this.owner.getOption(Laser.this.laserBlue))), 1.0f));
                        for (Entity entity : entities) {
                            if (!(entity instanceof Damageable) || !(entity.getLocation().distanceSquared(loc) < 1.0)) continue;
                            Beam.this.owner.causeDamage(Laser.this.getInstance(), (Damageable)entity, EntityDamageEvent.DamageCause.PROJECTILE, (Double)Beam.this.owner.getOption(Laser.this.damage));
                        }
                        ++i;
                    }
                    if (((Boolean)Beam.this.owner.getOption(Laser.this.useConsume)).booleanValue()) {
                        Beam.this.owner.getPlayer().getInventory().removeItem(new ItemStack[]{Laser.this.getConsumable()});
                    }
                } else {
                    Beam.this.disable();
                }
            }
        };

        public Beam(PowerUser owner) {
            this.owner = owner;
            this.task = Laser.this.runTaskTimer(this.doBeam, 0L, 1L).getTaskId();
        }

        public void disable() {
            Laser.this.cancelTask(this.task);
            this.owner.setCooldown(Laser.this.getInstance(), (Long)this.owner.getOption(Laser.this.cooldown));
            Laser.this.lasers.remove(this.owner);
        }
    }
}

