/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.offense;

import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

@PowerManifest(name="Holy Blade", type=PowerType.OFFENSE, author="sirrus86", concept="onlycoops", icon=Material.GOLDEN_SWORD, description="[use-specified-item][act:item]ing while holding [item][/use-specified-item][wMany] or [/wMany][use-any-sword]attacking with any sword[/use-any-sword] creates a beam of light which shoots in the same direction. This beam deals [damage] damage[instantly-kill-undead], and will instantly kill Zombies, Skeletons and PigZombies[/instantly-kill-undead]. [cooldown] cooldown.")
public final class HolyBlade
extends Power {
    private PowerOption<String> beamBlock;
    private PowerOption<Double> dmg;
    private PowerOption<Integer> range;
    private PowerOption<Boolean> breakNonSolid;
    private PowerOption<Boolean> killUndead;
    private PowerOption<Boolean> swordWear;
    private boolean wMany;

    @Override
    protected void config() {
        this.beamBlock = this.option("beam-block-type", "GLOWSTONE", "Block type to be used for beam effects.");
        this.breakNonSolid = this.option("break-non-solid-blocks", true, "Whether non-solid blocks are broken by beams.");
        this.cooldown = this.option("cooldown", PowerTime.toMillis(200), "Period of time before power can be used again.");
        this.dmg = this.option("damage", 5.0, "Damage done by light beams.");
        this.item = this.option("item", new ItemStack(Material.GOLDEN_SWORD), "Item used to create light beams.");
        this.killUndead = this.option("instantly-kill-undead", true, "Whether light beams should instantly kill undead enemies.");
        this.range = this.option("beam-range", 12, "Range of light beams.");
        this.swordWear = this.option("wear-down-sword", true, "Whether power use should wear down the sword used.");
        this.wItem = this.option("use-specified-item", true, "Whether power can be used with the specified item.");
        this.wSword = this.option("use-any-sword", false, "Whether power can be used with any sword.");
        this.wMany = (Boolean)this.getOption(this.wItem) != false && (Boolean)this.getOption(this.wSword) != false;
        this.supplies(this.getRequiredItem());
    }

    @EventHandler
    private void onUse(PlayerInteractEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this) && event.getAction().name().startsWith("LEFT_CLICK") && (((Boolean)user.getOption(this.wSword)).booleanValue() && event.getItem() != null && PowerTools.isSword(event.getItem()) || event.getItem() != null && event.getItem().getType() == this.getRequiredItem().getType())) {
            if (user.getCooldown(this) <= 0L) {
                if ((!event.getItem().hasItemMeta() || !event.getItem().getItemMeta().isUnbreakable()) && user.getOption(this.swordWear).booleanValue() && PowerTools.hasDurability(event.getItem()) && event.getItem().getDurability() < event.getItem().getType().getMaxDurability()) {
                    event.getItem().setDurability((short)(event.getItem().getDurability() + 1));
                }
                new Beam(user, user.getOption(this.range));
                user.setCooldown(this, (Long)user.getOption(this.cooldown));
            } else {
                user.showCooldown(this);
            }
        }
    }

    private class Beam {
        private final Vector dir;
        private final int length;
        private Location selected;
        private int stage = 0;
        private final PowerUser user;

        protected Beam(PowerUser user, int length) {
            this.user = user;
            this.dir = user.getPlayer().getEyeLocation().getDirection();
            this.length = length;
            this.selected = user.getPlayer().getEyeLocation().clone().add(this.dir);
            this.tick();
        }

        private void tick() {
            if (this.stage < this.length && (this.selected.getBlock().isEmpty() || !this.selected.getBlock().getType().isSolid() && ((Boolean)this.user.getOption(HolyBlade.this.breakNonSolid)).booleanValue())) {
                if (!this.selected.getBlock().isEmpty()) {
                    BlockBreakEvent event = new BlockBreakEvent(this.selected.getBlock(), this.user.getPlayer());
                    HolyBlade.this.callEvent((Event)event);
                    if (!event.isCancelled()) {
                        this.selected.getBlock().breakNaturally();
                    }
                }
                for (LivingEntity entity : PowerTools.getNearbyEntities(LivingEntity.class, this.selected, 1.5, (Entity)this.user.getPlayer())) {
                    if (((Boolean)this.user.getOption(HolyBlade.this.killUndead)).booleanValue() && (entity instanceof Skeleton || entity instanceof Zombie)) {
                        this.user.causeDamage(HolyBlade.this.getInstance(), (Damageable)entity, EntityDamageEvent.DamageCause.MAGIC, entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue() * 2.0);
                        continue;
                    }
                    this.user.causeDamage(HolyBlade.this.getInstance(), (Damageable)entity, EntityDamageEvent.DamageCause.MAGIC, (Double)this.user.getOption(HolyBlade.this.dmg));
                }
                HolyBlade.this.runTaskLater(new Runnable(){

                    @Override
                    public void run() {
                        Beam.this.selected.getWorld().playEffect(Beam.this.selected, Effect.STEP_SOUND, (Object)Material.getMaterial((String)((String)Beam.this.user.getOption(HolyBlade.this.beamBlock))));
                        Beam.this.selected.add(Beam.this.dir);
                        Beam.this.stage++;
                        Beam.this.tick();
                    }
                }, 1L);
            }
        }
    }
}

