/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.offense;

import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Material;
import org.bukkit.entity.Damageable;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.ItemStack;

@PowerManifest(name="Geomancer", type=PowerType.OFFENSE, author="sirrus86", concept="kamyarm007", incomplete=true, icon=Material.MOSSY_COBBLESTONE, description="[act:item]ing a distant entity while holding [item] will cause the ground beneath the target to deal unique effects to the target. Target must be on the ground. [cooldown] cooldown.")
public class Geomancer
extends Power {
    private PowerOption<Double> minRange;
    private PowerOption<Double> range;

    @Override
    protected void onEnable() {
        this.incomplete = true;
    }

    @Override
    protected void config() {
        this.cooldown = this.option("cooldown", PowerTime.toMillis(2, 0), "Period of time before power can be used again.");
        this.item = this.option("item", new ItemStack(Material.MOSSY_COBBLESTONE), "Item required to use power.");
        this.minRange = this.option("minimum-range", 5.0, "Minimum range which power can be used on targets.");
        this.range = this.option("range", 25.0, "Maximum range which power can be used on targets.");
        this.supplies(this.getRequiredItem());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        if (event.getPower() != this) return;
        PowerUser user = event.getUser();
        if (user.getCooldown(this) <= 0L) {
            Damageable target = user.getTargetEntity(Damageable.class, user.getOption(this.range));
            if (target != null && user.getPlayer().getLocation().distanceSquared(target.getLocation()) >= user.getOption(this.minRange) * user.getOption(this.minRange) && !target.isOnGround()) return;
        }
        user.showCooldown(this);
    }

    private static enum GeoType {
        SAND_SWALLOW;


        public static GeoType getByBlockType(Material type) {
            switch (type) {
                case COARSE_DIRT: 
                case DIRT: 
                case GRASS_BLOCK: 
                case PODZOL: {
                    return null;
                }
                case GRAVEL: 
                case RED_SAND: 
                case SAND: {
                    return SAND_SWALLOW;
                }
            }
            return null;
        }
    }
}

