/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.offense;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

@PowerManifest(name="Brawler", type=PowerType.OFFENSE, author="sirrus86", concept="diamondmario", icon=Material.DAMAGED_ANVIL, description="All barehanded attacks deal [damage-increase]% normal damage. Barehanded attacks while crouching will afflict them with status effects, while attacks within [uppercut-buffer] of rising will uppercut them into the air. Falling enemies above you can be juggled for additional damage.")
public final class Brawler
extends Power {
    private Map<PowerUser, Long> canUppercut;
    private PowerOption<Double> dmgIncr;
    private PowerOption<Double> juggleVert;
    private PowerOption<Double> offHandDef;
    private PowerOption<Double> uppercutVert;
    private PowerOption<Long> uppercutBuffer;
    private PowerOption<List<PotionEffect>> sweepEffects;
    private PowerStat totalDmg;

    @Override
    protected void onEnable() {
        this.canUppercut = new HashMap<PowerUser, Long>();
    }

    @Override
    protected void config() {
        this.dmgIncr = this.option("damage-increase", 400.0, "Percentage increase for damage done while barehanded.");
        this.juggleVert = this.option("juggle-vertical-modifier", 0.5, "Velocity modifier to entities hit while falling.");
        this.offHandDef = this.option("offhand-defense", 75.0, "Percentage decrease to incoming melee damage while off-hand has no item equipped.");
        this.sweepEffects = this.option("sweep-effects", List.of(new PotionEffect(PotionEffectType.SLOW, PowerTime.toTicks(3, 0), 2)), "Effects to afflict on entities hit by sweeping attacks.");
        this.totalDmg = this.stat("total-barehanded-damage", 100, "Damage dealt while barehanded", "Keeping you off-hand empty allows you to block [offhand-defense]% of melee damage from enemies.");
        this.uppercutBuffer = this.option("uppercut-buffer", PowerTime.toMillis(500), "Amount of time after standing from crouch to perform an uppercut.");
        this.uppercutVert = this.option("uppercut-vertical-modifier", 0.75, "Velocity modifier to entities hit by an uppercut.");
    }

    @EventHandler(ignoreCancelled=true)
    private void onDmg(final EntityDamageByEntityEvent event) {
        PowerUser user;
        if (event.getDamager() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getDamager()))).allowPower(this) && user.getEquipment(EquipmentSlot.HAND).getType() == Material.AIR) {
            event.setDamage(event.getDamage() * (user.getOption(this.dmgIncr) / 100.0));
            if (user.getPlayer().isSneaking() && event.getEntity() instanceof LivingEntity) {
                ((LivingEntity)event.getEntity()).addPotionEffects((Collection)user.getOption(this.sweepEffects));
            } else if (this.canUppercut.containsKey(user) && System.currentTimeMillis() < this.canUppercut.get(user)) {
                this.runTask((Runnable)new BukkitRunnable(){

                    public void run() {
                        event.getEntity().setVelocity(new Vector(event.getEntity().getVelocity().getX(), ((Double)user.getOption(Brawler.this.uppercutVert)).doubleValue(), event.getEntity().getVelocity().getZ()));
                    }
                });
            } else if (event.getEntity().getFallDistance() > 0.0f && event.getEntity().getLocation().getY() > user.getPlayer().getLocation().getY()) {
                this.runTask((Runnable)new BukkitRunnable(){

                    public void run() {
                        event.getEntity().setVelocity(new Vector(event.getEntity().getVelocity().getX(), ((Double)user.getOption(Brawler.this.juggleVert)).doubleValue(), event.getEntity().getVelocity().getZ()));
                    }
                });
            }
            user.increaseStat(this.totalDmg, (int)event.getDamage());
        }
        if (event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this) && user.getEquipment(EquipmentSlot.OFF_HAND).getType() == Material.AIR && event.getEntity() instanceof LivingEntity && user.hasStatMaxed(this.totalDmg)) {
            event.setDamage(event.getDamage() * (user.getOption(this.offHandDef) / 100.0));
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onSneak(PlayerToggleSneakEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this) && !event.isSneaking()) {
            this.canUppercut.put(user, System.currentTimeMillis() + user.getOption(this.uppercutBuffer));
        }
    }
}

