/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.offense;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.events.PowerUseOnEntityEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

@PowerManifest(name="Bloodbend", type=PowerType.OFFENSE, author="sirrus86", concept="TheClownOfCrime", icon=Material.GHAST_TEAR, usesPackets=true, description="[act:item]ing an entity while holding [item] allows you to momentarily control them, freezing and levitating them while you drain their blood. This damages them while restoring your own hunger, then health. Does not work on undead. Can only be used against a given entity once every [victim-cooldown]. [cooldown] cooldown.")
public final class Bloodbend
extends Power {
    private Map<LivingEntity, Long> vCooldown;
    private Set<BendTarget> targets;
    private PowerOption<Double> dmg;
    private PowerOption<Double> heal;
    private PowerOption<Double> range;
    private PowerOption<Long> dur;
    private PowerOption<Long> vCD;
    private PowerOption<Integer> freq;
    private String targetRecent;

    @Override
    protected void onEnable() {
        this.targets = new HashSet<BendTarget>();
        this.vCooldown = new WeakHashMap<LivingEntity, Long>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        for (BendTarget target : this.targets) {
            if (target.getUser() != user) continue;
            target.disable();
        }
    }

    @Override
    protected void config() {
        this.cooldown = this.option("cooldown", PowerTime.toMillis(5, 0), "Amount of time before power can be used again.");
        this.dmg = this.option("damage", 1.0, "Amount of damage done to targets per tick.");
        this.dur = this.option("duration", PowerTime.toMillis(1, 0), "Amount of time target is drained before being let go.");
        this.freq = this.option("drain-frequency", 5, "How often damage and healing occur while using power. Lower values are more frequent.");
        this.heal = this.option("healing", 1.0, "Amount of healing done to user while power is used.");
        this.item = this.option("item", new ItemStack(Material.GHAST_TEAR), "Item required to use power.");
        this.range = this.option("range", 7.5, "Maximum range which power can be used on targets.");
        this.vCD = this.option("victim-cooldown", PowerTime.toMillis(15, 0), "Amount of time before an entity can be targetted again.");
        this.targetRecent = this.locale("message.target-too-recent", ChatColor.RED + "Entity has been targetted too recently.");
        this.supplies(this.getRequiredItem());
    }

    private void doBend(PowerUser user, LivingEntity target) {
        if (target != null && !(target instanceof Skeleton) && !(target instanceof Zombie)) {
            if (!this.vCooldown.containsKey(target) || this.vCooldown.get(target) <= System.currentTimeMillis()) {
                this.targets.add(new BendTarget(user, target));
                this.vCooldown.put(target, System.currentTimeMillis() + user.getOption(this.vCD));
                user.setCooldown(this, (Long)user.getOption(this.cooldown));
            } else {
                user.sendMessage(this.targetRecent);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onTarget(PowerUseEvent event) {
        if (event.getPower() == this) {
            if (event.getUser().getCooldown(this) <= 0L) {
                this.doBend(event.getUser(), event.getUser().getTargetEntity(LivingEntity.class, event.getUser().getOption(this.range)));
            } else {
                event.getUser().showCooldown(this);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onTarget(PowerUseOnEntityEvent event) {
        if (event.getPower() == this && event.getEntity() instanceof LivingEntity) {
            if (event.getUser().getCooldown(this) <= 0L) {
                this.doBend(event.getUser(), (LivingEntity)event.getEntity());
            } else {
                event.getUser().showCooldown(this);
            }
        }
    }

    private class BendTarget {
        private int taskID = -1;
        private final PowerUser user;

        protected BendTarget(final PowerUser user, final LivingEntity target) {
            this.user = user;
            this.taskID = Bloodbend.this.runTaskTimer(new Runnable(){
                long i;
                {
                    this.i = PowerTime.toTicks((Long)user.getOption(Bloodbend.this.dur));
                }

                @Override
                public void run() {
                    if (this.i > 0L && user.isOnline() && user.getPlayer().getWorld() == target.getWorld()) {
                        target.setVelocity(new Vector(0.0, 0.1, 0.0));
                        PowerTools.playRedstoneEffect(target.getEyeLocation(), Vector.getRandom(), 3, new Particle.DustOptions(Color.RED, 1.5f));
                        Item red = target.getWorld().dropItem(target.getEyeLocation(), new ItemStack(Material.REDSTONE, 1));
                        red.setPickupDelay(Integer.MAX_VALUE);
                        PowerTools.fakeCollect((Entity)user.getPlayer(), red);
                        red.remove();
                        if (this.i % (long)((Integer)user.getOption(Bloodbend.this.freq)).intValue() == 0L) {
                            user.causeDamage(Bloodbend.this.getInstance(), (Damageable)target, EntityDamageEvent.DamageCause.MAGIC, (Double)user.getOption(Bloodbend.this.dmg));
                            if (user.getPlayer().getFoodLevel() < 20) {
                                user.regenHunger((int)Math.round((Double)user.getOption(Bloodbend.this.heal)));
                            } else {
                                user.heal((Double)user.getOption(Bloodbend.this.heal));
                            }
                        }
                        --this.i;
                    } else {
                        BendTarget.this.disable();
                    }
                }
            }, 0L, 1L).getTaskId();
        }

        public PowerUser getUser() {
            return this.user;
        }

        public void disable() {
            if (this.taskID > -1) {
                Bloodbend.this.cancelTask(this.taskID);
            }
        }
    }
}

