/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.offense;

import java.util.HashMap;
import java.util.Map;
import me.sirrus86.s86powers.events.PowerIgniteEvent;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

@PowerManifest(name="Blastwave", type=PowerType.OFFENSE, author="sirrus86", concept="brysi", icon=Material.BLAZE_POWDER, description="[act:item]ing while holding [item] creates a fiery explosion beneath you, propelling you up and away from the direction you're facing. [cooldown] cooldown.")
public final class Blastwave
extends Power {
    private Map<PowerUser, Long> fallCDs;
    private PowerOption<Double> blastRad;
    private PowerOption<Double> hVec;
    private PowerOption<Double> vVec;
    private PowerOption<Boolean> consume;
    private PowerOption<Long> fallCD;

    @Override
    protected void onEnable() {
        this.fallCDs = new HashMap<PowerUser, Long>();
    }

    @Override
    protected void config() {
        this.blastRad = this.option("blast-radius", 3.0, "Radius size of the blast.");
        this.consume = this.option("consume-item", true, "Whether item should be consumed when power is used.");
        this.cooldown = this.option("cooldown", PowerTime.toMillis(10, 0), "Amount of time before power can be used again.");
        this.fallCD = this.option("fall-cooldown", PowerTime.toMillis(2, 0), "How long to give player fall damage immunity after using power.");
        this.hVec = this.option("horizontal-momentum", -1.5, "Vector modifier for horizontal movement after blast is initiated.");
        this.item = this.option("item", new ItemStack(Material.BLAZE_ROD), "Item used to create blasts.");
        this.vVec = this.option("vertical-momentum", 1.0, "Vector modifier for vertical movement after blast is initiated.");
        this.supplies(new ItemStack(this.getRequiredItem().getType(), this.getRequiredItem().getMaxStackSize() / 4));
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        if (event.getPower() == this) {
            PowerUser user = event.getUser();
            if (user.getCooldown(this) <= 0L) {
                for (Block block : PowerTools.getNearbyBlocks(user.getPlayer().getLocation(), user.getOption(this.blastRad))) {
                    PowerIgniteEvent pEvent = new PowerIgniteEvent(this, user, block, BlockFace.SELF);
                    this.callEvent(pEvent);
                }
                Vector dir = user.getPlayer().getLocation().getDirection();
                user.getPlayer().setVelocity(new Vector(dir.getX() * user.getOption(this.hVec), user.getOption(this.vVec).doubleValue(), dir.getZ() * user.getOption(this.hVec)));
                user.setCooldown(this, (Long)user.getOption(this.cooldown));
                if (user.getOption(this.consume).booleanValue()) {
                    event.consumeItem();
                }
                this.fallCDs.put(user, System.currentTimeMillis() + user.getOption(this.fallCD));
            } else {
                user.showCooldown(this);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onFall(EntityDamageEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && event.getCause() == EntityDamageEvent.DamageCause.FALL && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this) && this.fallCDs.containsKey(user) && this.fallCDs.get(user) > System.currentTimeMillis()) {
            event.setCancelled(true);
        }
    }
}

