/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.offense;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

@PowerManifest(name="Auto Gun", type=PowerType.OFFENSE, author="sirrus86", concept="sirrus86", icon=Material.DISPENSER, usesPackets=true, description="[act:item]ing against a solid block while holding [item] will place a turret against that block. Turrets will search out and fire upon any living targets within [turret-range] blocks.")
public final class AutoGun
extends Power {
    private Map<PowerUser, List<Turret>> turrets;
    private PowerOption<Integer> arrowsPerVolley;
    private PowerOption<Integer> maxTurrets;
    private final MultipleFacing baseData = (MultipleFacing)Material.DARK_OAK_FENCE.createBlockData();
    private final Directional cartData = (Directional)Material.DISPENSER.createBlockData();
    private PowerOption<Boolean> consumeItem;
    private PowerOption<Boolean> ignoreInvis;
    private final Vector cartCenter = new Vector(0.0, 0.8, 0.0);
    private PowerStat dmgByTurrets;
    private PowerOption<Long> fireDelay;
    private PowerOption<Double> range;

    @Override
    protected void onEnable() {
        this.cartData.setFacing(BlockFace.SOUTH);
        this.turrets = new HashMap<PowerUser, List<Turret>>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.turrets.containsKey(user) && this.turrets.get(user) != null) {
            for (int i = 0; i < this.turrets.get(user).size(); ++i) {
                this.turrets.get(user).get(0).destroy();
            }
        }
    }

    @Override
    protected void config() {
        this.arrowsPerVolley = this.option("arrows-per-volley", 3, "Number of arrows fired at a time by turrets.");
        this.consumeItem = this.option("consume-item", true, "Whether item should be consumed on use.");
        this.cooldown = this.option("cooldown", PowerTime.toMillis(1, 0), "Cooldown between placing turrets.");
        this.dmgByTurrets = this.stat("damage-by-turrets", 150, "Damage done by turrets", "Can now deploy [maximum-turrets] turrets at a time.");
        this.fireDelay = this.option("firing-delay", PowerTime.toMillis(3, 0), "Amount of time before another volley of arrows can be shot by a turret.");
        this.ignoreInvis = this.option("ignore-invisible-targets", true, "Whether invisible targets should be ignored by turrets.");
        this.item = this.option("item", new ItemStack(Material.DISPENSER), "Item used to deploy turrets.");
        this.maxTurrets = this.option("maximum-turrets", 3, "Maximum number of turrets that can be deployed at one time.");
        this.range = this.option("turret-range", 25.0, "Maximum range which turrets can detect targets.");
        this.supplies(new ItemStack(this.getRequiredItem().getType(), this.getRequiredItem().getMaxStackSize() / 4));
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        Block base;
        if (event.getPower() == this && event.hasBlock() && event.getUser().getCooldown(this) <= 0L && (base = event.getClickedBlock().getRelative(event.getBlockFace())).getType() == Material.AIR && event.getClickedBlock().getType().isSolid()) {
            if (!this.turrets.containsKey(event.getUser())) {
                this.turrets.put(event.getUser(), new ArrayList());
            }
            if (!event.getUser().hasStatMaxed(this.dmgByTurrets) && this.turrets.get(event.getUser()).size() >= 1 || event.getUser().hasStatMaxed(this.dmgByTurrets) && this.turrets.get(event.getUser()).size() >= event.getUser().getOption(this.maxTurrets)) {
                this.turrets.get(event.getUser()).get(0).destroy();
            }
            for (BlockFace blockFace : this.baseData.getAllowedFaces()) {
                this.baseData.setFace(blockFace, false);
            }
            if (this.baseData.getAllowedFaces().contains(event.getBlockFace().getOppositeFace())) {
                this.baseData.setFace(event.getBlockFace().getOppositeFace(), true);
            }
            base.setBlockData((BlockData)this.baseData);
            double modY = event.getBlockFace() == BlockFace.DOWN ? -0.5 : 0.5;
            RideableMinecart cart = (RideableMinecart)base.getWorld().spawn(base.getLocation().add(0.5, modY, 0.5), RideableMinecart.class);
            cart.setDisplayBlockData((BlockData)this.cartData);
            Turret turret = new Turret(event.getUser(), cart, base);
            this.turrets.get(event.getUser()).add(turret);
            event.getUser().setCooldown(this, (Long)event.getUser().getOption(this.cooldown));
            if (event.getUser().getOption(this.consumeItem).booleanValue()) {
                event.consumeItem();
            }
        }
    }

    private class Turret
    implements Listener {
        private Set<Arrow> arrows;
        private final Block base;
        private final RideableMinecart cart;
        private final PowerUser owner;
        private final Predicate<Entity> predEntity;
        private LivingEntity target = null;
        private int task = -1;
        private Runnable cycleActions = new BukkitRunnable(){

            public void run() {
                if (Turret.this.target == null || !Turret.this.target.isValid() || !Turret.this.haveLineOfSight(Turret.this.target)) {
                    Turret.this.target = Turret.this.findTarget();
                }
                if (Turret.this.target != null) {
                    Turret.this.lookAt(Turret.this.target.getEyeLocation());
                    Turret.this.fireVolley(Turret.this.target);
                    Turret.this.task = AutoGun.this.getInstance().runTaskLater(Turret.this.cycleActions, PowerTime.toTicks((Long)Turret.this.owner.getOption(AutoGun.this.fireDelay))).getTaskId();
                } else {
                    Turret.this.randomLook();
                    Turret.this.task = AutoGun.this.getInstance().runTaskLater(Turret.this.cycleActions, 40L).getTaskId();
                }
            }
        };

        public Turret(PowerUser owner, RideableMinecart cart, Block base) {
            AutoGun.this.getInstance().registerEvents(this);
            this.arrows = new HashSet<Arrow>();
            this.base = base;
            this.cart = cart;
            this.owner = owner;
            this.predEntity = entity -> entity != this.cart && entity != this.owner.getPlayer() && entity instanceof LivingEntity;
            this.task = AutoGun.this.runTask(this.cycleActions).getTaskId();
        }

        public void destroy() {
            if (this.base.getType() != Material.AIR) {
                this.base.getWorld().playEffect(this.base.getLocation(), Effect.STEP_SOUND, (Object)this.base.getType());
                this.base.setType(Material.AIR);
            }
            if (this.cart != null && this.cart.isValid()) {
                PowerTools.fakeExplosion(this.cart.getLocation(), 2.0f);
                this.cart.remove();
            }
            if (this.task >= 0) {
                AutoGun.this.cancelTask(this.task);
            }
            ((List)AutoGun.this.turrets.get(this.owner)).remove(this);
        }

        private LivingEntity findTarget() {
            double getRange = (Double)this.owner.getOption(AutoGun.this.range);
            List nearby = this.cart.getNearbyEntities(getRange, getRange, getRange);
            Collections.shuffle(nearby);
            for (Entity entity : nearby) {
                LivingEntity lEntity;
                if (!(entity instanceof LivingEntity) || entity == this.owner.getPlayer() || !this.haveLineOfSight(lEntity = (LivingEntity)entity) || ((Boolean)this.owner.getOption(AutoGun.this.ignoreInvis)).booleanValue() && lEntity.hasPotionEffect(PotionEffectType.INVISIBILITY)) continue;
                this.lookAt(lEntity.getEyeLocation());
                return lEntity;
            }
            return null;
        }

        private void fireVolley(final LivingEntity entity) {
            final Vector direction = PowerTools.getDirection(this.cart.getLocation(), entity.getEyeLocation());
            final float arrowPower = (float)(this.cart.getLocation().distance(this.target.getEyeLocation()) * (double)0.1f);
            for (int i = 0; i < (Integer)this.owner.getOption(AutoGun.this.arrowsPerVolley); ++i) {
                AutoGun.this.runTaskLater((Runnable)new BukkitRunnable(){
                    private Vector newDir;
                    private float newPower;
                    {
                        this.newDir = direction;
                        this.newPower = arrowPower;
                    }

                    public void run() {
                        if (entity.isValid()) {
                            this.newDir = PowerTools.getDirection(Turret.this.cart.getLocation(), entity.getEyeLocation());
                            this.newPower = (float)(Turret.this.cart.getLocation().distance(Turret.this.target.getEyeLocation()) * (double)0.1f);
                        }
                        Arrow arrow = Turret.this.cart.getWorld().spawnArrow(Turret.this.cart.getLocation().add(this.newDir).add(AutoGun.this.cartCenter), this.newDir, this.newPower, 0.0f);
                        Turret.this.arrows.add(arrow);
                    }
                }, 5L * (long)i);
            }
        }

        private boolean haveLineOfSight(LivingEntity entity) {
            Vector direction = PowerTools.getDirection(this.cart.getLocation().add(AutoGun.this.cartCenter), entity.getLocation());
            return PowerTools.getTargetEntity(LivingEntity.class, this.cart.getLocation().clone().add(direction).add(AutoGun.this.cartCenter), direction, (Double)this.owner.getOption(AutoGun.this.range), this.predEntity) != null;
        }

        private void lookAt(Location loc) {
            if (loc.getWorld() == this.cart.getWorld()) {
                double dx = -(loc.getX() - this.cart.getLocation().getX());
                double dy = loc.getY() - this.cart.getLocation().getY();
                double dz = -(loc.getZ() - this.cart.getLocation().getZ());
                double dh = Math.sqrt(dx * dx + dz * dz);
                float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI);
                float pitch = (float)(-Math.atan(dy / dh) * 180.0 / Math.PI);
                PowerTools.setRotation((Entity)this.cart, yaw, pitch);
            }
        }

        private void randomLook() {
            double getRange = (Double)this.owner.getOption(AutoGun.this.range);
            double randX = random.nextDouble() * (double)random.nextInt((int)getRange) - getRange / 2.0;
            double randY = random.nextDouble() * (double)random.nextInt((int)getRange) - getRange / 2.0;
            double randZ = random.nextDouble() * (double)random.nextInt((int)getRange) - getRange / 2.0;
            this.lookAt(new Location(this.cart.getWorld(), this.cart.getLocation().getX() + randX, this.cart.getLocation().getY() + randY, this.cart.getLocation().getZ() + randZ));
        }

        @EventHandler(ignoreCancelled=true)
        private void onBreak(BlockBreakEvent event) {
            if (event.getBlock() == this.base) {
                this.destroy();
            }
        }

        @EventHandler(ignoreCancelled=true)
        private void onDamage(VehicleDamageEvent event) {
            if (event.getVehicle() == this.cart) {
                this.destroy();
            }
        }

        @EventHandler(ignoreCancelled=true)
        private void onArrowDamage(EntityDamageByEntityEvent event) {
            if (this.arrows.contains(event.getDamager())) {
                this.owner.causeDamage(AutoGun.this.getInstance(), event);
                this.owner.increaseStat(AutoGun.this.dmgByTurrets, (int)event.getDamage());
            }
        }

        @EventHandler
        private void onDeath(EntityDeathEvent event) {
            if (event.getEntity() == this.target) {
                this.target = null;
            }
        }

        @EventHandler(ignoreCancelled=true)
        private void noPickup(PlayerPickupArrowEvent event) {
            if (this.arrows.contains(event.getArrow())) {
                event.setCancelled(true);
            }
        }

        @EventHandler(ignoreCancelled=true)
        private void noCollide(VehicleEntityCollisionEvent event) {
            if (event.getVehicle() == this.cart) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        private void noMove(VehicleMoveEvent event) {
            if (event.getVehicle() == this.cart && event.getFrom().distanceSquared(event.getTo()) > 0.0) {
                this.cart.teleport(event.getFrom());
            }
        }

        @EventHandler(ignoreCancelled=true)
        private void noRide(VehicleEnterEvent event) {
            if (event.getVehicle() == this.cart) {
                event.setCancelled(true);
            }
        }
    }
}

