/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.offense;

import java.util.Map;
import java.util.WeakHashMap;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

@PowerManifest(name="Aero Blade", type=PowerType.OFFENSE, author="sirrus86", concept="repete8", icon=Material.IRON_SWORD, usesPackets=true, description="[use-with-specific-item][act:item]ing while holding [item][/use-with-specific-item][wMany] or [/wMany][use-any-sword]swinging any sword[/use-any-sword] will create a gust of wind in front of you, propelling entities away from you.")
public final class AeroBlade
extends Power {
    private Map<Snowball, PowerUser> sList;
    private PowerOption<Double> fSpread;
    private PowerOption<Double> fVel;
    private boolean wMany;

    @Override
    protected void onEnable() {
        this.sList = new WeakHashMap<Snowball, PowerUser>();
    }

    @Override
    protected void config() {
        this.cooldown = this.option("cooldown", PowerTime.toMillis(1, 0), "Amount of time before power can be used again.");
        this.fSpread = this.option("feather-spread", 0.1, "Spread of feathers. Higher values create greater spreads.");
        this.fVel = this.option("feather-velocity", 2.0, "Velocity of feathers.");
        this.item = this.option("item", new ItemStack(Material.IRON_SWORD), "Item used to trigger power.");
        this.wItem = this.option("use-with-specific-item", false, "Whether power will work with the specified item.");
        this.wSword = this.option("use-any-sword", true, "Whether power will work with any sword.");
        this.wMany = (Boolean)this.getOption(this.wItem) != false && (Boolean)this.getOption(this.wSword) != false;
        this.supplies(this.getRequiredItem());
    }

    @EventHandler
    private void onDmg(EntityDamageByEntityEvent event) {
        if (this.sList.containsKey(event.getDamager())) {
            Snowball snowball = (Snowball)event.getDamager();
            event.getEntity().setVelocity(snowball.getVelocity());
            this.sList.remove(snowball);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        PowerUser user;
        if (event.getPower() == this && (user = event.getUser()).getCooldown(this) <= 0L) {
            user.getPlayer().getWorld().playEffect(user.getPlayer().getEyeLocation(), Effect.BLAZE_SHOOT, 0);
            for (int i = 0; i < 10; ++i) {
                Snowball snowball = (Snowball)user.getPlayer().launchProjectile(Snowball.class);
                Vector sVel = snowball.getVelocity().clone();
                snowball.setVelocity(sVel.add(new Vector(random.nextGaussian() * user.getOption(this.fSpread), 0.0, random.nextGaussian() * user.getOption(this.fSpread))).multiply(user.getOption(this.fVel).doubleValue()));
                PowerTools.addDisguise((Entity)snowball, new ItemStack(Material.FEATHER, 1));
                this.sList.put(snowball, user);
            }
            user.setCooldown(this, (Long)user.getOption(this.cooldown));
        }
    }
}

