/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Web Wall", type=PowerType.DEFENSE, author="sirrus86", concept="vashvhexx", icon=Material.COBWEB, description="[act:item]ing a block while holding [item] will cause a wall made of spider webs to sprout from the surface. Walls last for [wall-duration]. [cooldown] cooldown.")
public final class WebWall
extends Power {
    private final EnumSet<BlockFace> directions = EnumSet.of(BlockFace.DOWN, new BlockFace[]{BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.UP, BlockFace.WEST});
    private Map<PowerUser, List<Wall>> walls;
    private PowerOption<Boolean> doConsume;
    private PowerOption<Double> maxGrowth;
    private PowerOption<Integer> maxWalls;
    private PowerOption<Long> wallDur;
    private PowerStat wallsMade;

    @Override
    protected void onEnable() {
        this.walls = new HashMap<PowerUser, List<Wall>>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.walls.containsKey(user)) {
            for (Wall wall : Sets.newHashSet((Iterable)this.walls.get(user))) {
                wall.terminate();
            }
        }
    }

    @Override
    protected void config() {
        this.cooldown = this.option("cooldown", PowerTime.toMillis(30, 0), "Amount of time before power can be used again.");
        this.doConsume = this.option("consume-item", true, "Whether item should be consumed on use.");
        this.item = this.option("item", new ItemStack(Material.COBWEB), "Item used to create web walls.");
        this.maxGrowth = this.option("maximum-growth", 5.0, "Maximum distance webs can grow from their starting point.");
        this.maxWalls = this.option("maximum-walls", 3, "Maximum number of walls user can create after maxing stat.");
        this.wallDur = this.option("wall-duration", PowerTime.toMillis(15, 0), "How long web walls last before disappearing.");
        this.wallsMade = this.stat("walls-created", 30, "Web walls created", "Can now create [maxWalls] web walls at a time.");
        this.supplies(new ItemStack(this.getRequiredItem().getType(), this.getRequiredItem().getMaxStackSize()));
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        if (event.getPower() == this && event.getClickedBlock() != null && event.getBlockFace() != null && event.getClickedBlock().getRelative(event.getBlockFace()).isEmpty()) {
            PowerUser user = event.getUser();
            if (!this.walls.containsKey(user)) {
                this.walls.put(user, new ArrayList());
            }
            if (user.getCooldown(this) <= 0L || this.walls.get(user).size() < user.getOption(this.maxWalls) && user.hasStatMaxed(this.wallsMade)) {
                Wall wall = new Wall(user, event.getClickedBlock().getRelative(event.getBlockFace()), PowerTools.getDirection(user.getPlayer().getEyeLocation(), false));
                this.walls.get(user).add(wall);
                user.increaseStat(this.wallsMade, 1);
                if (user.getOption(this.doConsume).booleanValue()) {
                    event.consumeItem();
                }
                if (user.getCooldown(this) <= 0L) {
                    user.setCooldown(this, (Long)user.getOption(this.cooldown));
                }
            } else {
                user.showCooldown(this);
            }
        }
    }

    static /* synthetic */ EnumSet access$000(WebWall x0) {
        return x0.directions;
    }

    private class Wall
    implements Listener {
        private Set<Block> blocks = new HashSet<Block>();
        private final Block core;
        List<BlockFace> faces = Lists.newArrayList((Iterable)WebWall.access$000(WebWall.this));
        private int growTask;
        private int lifeTask;
        private final PowerUser owner;
        private Runnable growth = new BukkitRunnable(){
            int tries = 0;

            public void run() {
                boolean added = false;
                for (Block block : Sets.newHashSet((Iterable)Wall.this.blocks)) {
                    Collections.shuffle(Wall.this.faces);
                    BlockFace face = Wall.this.faces.get(0);
                    if (!block.getRelative(face).isEmpty() || !(Wall.this.core.getLocation().distanceSquared(block.getRelative(face).getLocation()) <= (Double)Wall.this.owner.getOption(WebWall.this.maxGrowth) * (Double)Wall.this.owner.getOption(WebWall.this.maxGrowth))) continue;
                    Block newWeb = block.getRelative(face);
                    newWeb.getWorld().playEffect(newWeb.getLocation(), Effect.STEP_SOUND, (Object)Material.COBWEB);
                    newWeb.setType(Material.COBWEB);
                    Wall.this.blocks.add(newWeb);
                    added = true;
                }
                if (!added) {
                    ++this.tries;
                }
                if (this.tries < 3) {
                    Wall.this.growTask = WebWall.this.getInstance().runTaskLater(Wall.this.growth, 1L).getTaskId();
                }
            }
        };

        public Wall(PowerUser owner, Block core, BlockFace facing) {
            WebWall.this.registerEvents(this);
            this.core = core;
            this.faces.remove(facing);
            this.faces.remove(facing.getOppositeFace());
            this.owner = owner;
            core.setType(Material.COBWEB);
            this.blocks.add(core);
            this.growTask = WebWall.this.getInstance().runTaskLater(this.growth, 1L).getTaskId();
            this.lifeTask = WebWall.this.getInstance().runTaskLater((Runnable)new BukkitRunnable(){

                public void run() {
                    Wall.this.terminate();
                }
            }, PowerTime.toTicks((Long)owner.getOption(WebWall.this.wallDur))).getTaskId();
        }

        @EventHandler(ignoreCancelled=true)
        private void onBreak(BlockBreakEvent event) {
            if (this.blocks.contains(event.getBlock())) {
                event.setDropItems(false);
            }
        }

        public void terminate() {
            WebWall.this.cancelTask(this.growTask);
            WebWall.this.cancelTask(this.lifeTask);
            for (Block block : this.blocks) {
                if (block.getType() != Material.COBWEB) continue;
                block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)Material.COBWEB);
                block.setType(Material.AIR);
            }
            this.blocks.clear();
            ((List)WebWall.this.walls.get(this.owner)).remove(this);
        }
    }
}

