/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.PigZombieAngerEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Summoner", type=PowerType.DEFENSE, author="sirrus86", concept="sirrus86", icon=Material.BLAZE_ROD, usesPackets=true, description="Most monsters from the nether will ignore you. [act:item]ing the ground while holding [item] will create a portal which summons a random minion from the nether. The summoned minion will follow and defend you. Summoning only works in the overworld and The End. [cooldown] cooldown.")
public final class Summoner
extends Power {
    private Map<PowerUser, LivingEntity> minions;
    private final EnumSet<EntityType> nMobs = EnumSet.of(EntityType.BLAZE, new EntityType[]{EntityType.GHAST, EntityType.HOGLIN, EntityType.MAGMA_CUBE, EntityType.PIGLIN, EntityType.PIGLIN_BRUTE, EntityType.STRIDER, EntityType.WITHER_SKELETON, EntityType.ZOGLIN, EntityType.ZOMBIFIED_PIGLIN});
    private PowerOption<Integer> bSpawn;
    private PowerOption<Integer> gSpawn;
    private PowerOption<Integer> pjSpawn;
    private PowerOption<Integer> pzSpawn;
    private PowerOption<Integer> wsSpawn;
    private String noRoom;
    private final Orientable portalData = (Orientable)Material.NETHER_PORTAL.createBlockData();

    @Override
    protected void onEnable() {
        this.minions = new HashMap<PowerUser, LivingEntity>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.minions.containsKey(user)) {
            this.minions.get(user).damage(200.0);
            this.minions.remove(user);
        }
    }

    @Override
    protected void config() {
        this.bSpawn = this.option("summon-chance.blaze", 10, "Chance blazes will be summoned. Higher number means greater chance, 0 means no chance.");
        this.cooldown = this.option("cooldown", PowerTime.toMillis(5, 0, 0), "Amount of time before power can be used again.");
        this.gSpawn = this.option("summon-chance.ghast", 3, "Chance ghasts will be summoned. Higher number means greater chance, 0 means no chance.");
        this.item = this.option("item", new ItemStack(Material.BLAZE_ROD), "Item used to summon minions.");
        this.pjSpawn = this.option("summon-chance.pigzombie-jockey", 1, "Chance pigzombie jockeys will be summoned. Higher number means greater chance, 0 means no chance.");
        this.pzSpawn = this.option("summon-chance.pigzombie", 30, "Chance pigzombies will be summoned. Higher number means greater chance, 0 means no chance.");
        this.wsSpawn = this.option("summon-chance.wither-skeleton", 10, "Chance blazes will be summoned. Higher number means greater chance, 0 means no chance.");
        this.noRoom = this.locale("message.no-room", ChatColor.RED + "No room to summon anything!");
        this.supplies(this.getRequiredItem());
    }

    private SummonType getSummonType(Location loc, BlockFace face) {
        Location testLoc = loc.add((double)face.getModX(), 1.0, (double)face.getModZ());
        ArrayList<SummonType> tmp = new ArrayList<SummonType>();
        for (SummonType type : SummonType.values()) {
            if (type == SummonType.BLAZE || type == SummonType.PIG_JOCKEY || type == SummonType.PIG_ZOMBIE) {
                if (testLoc.getBlock().getType().isSolid() || testLoc.getBlock().getRelative(BlockFace.UP).getType().isSolid()) continue;
                int max = this.getOption(this.bSpawn);
                if (type == SummonType.PIG_JOCKEY) {
                    max = this.getOption(this.pjSpawn);
                } else if (type == SummonType.PIG_ZOMBIE) {
                    max = this.getOption(this.pzSpawn);
                }
                for (int i = 0; i < max - 1; ++i) {
                    tmp.add(type);
                }
                continue;
            }
            if (type == SummonType.GHAST) {
                Block block = testLoc.getBlock().getRelative(face.getModX(), 1, face.getModZ());
                boolean canSpawn = true;
                for (BlockFace check : BlockFace.values()) {
                    if (Math.abs(check.getModX()) > 1 || Math.abs(check.getModY()) > 1 || Math.abs(check.getModZ()) > 1 || !block.getRelative(check).getType().isSolid()) continue;
                    canSpawn = false;
                    break;
                }
                if (!canSpawn) continue;
                for (int i = 0; i < this.getOption(this.gSpawn) - 1; ++i) {
                    tmp.add(type);
                }
                continue;
            }
            if (type != SummonType.WITHER_SKELETON || testLoc.getBlock().getType().isSolid() || testLoc.getBlock().getRelative(BlockFace.UP).getType().isSolid() || testLoc.getBlock().getRelative(BlockFace.UP, 2).getType().isSolid()) continue;
            for (int i = 0; i < this.getOption(this.wsSpawn) - 1; ++i) {
                tmp.add(type);
            }
        }
        return tmp.isEmpty() ? null : (SummonType)((Object)tmp.get(random.nextInt(tmp.size())));
    }

    @EventHandler
    private void onDeath(EntityDeathEvent event) {
        if (this.minions.containsValue(event.getEntity())) {
            event.getDrops().clear();
            event.setDroppedExp(0);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onTarget(EntityTargetLivingEntityEvent event) {
        PowerUser user;
        if (event.getTarget() instanceof Player && this.nMobs.contains(event.getEntityType()) && (user = this.getUser((OfflinePlayer)((Player)event.getTarget()))).allowPower(this)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onAnger(PigZombieAngerEvent event) {
        PowerUser user;
        if (event.getTarget() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getTarget()))).allowPower(this) && this.minions.get(user) == event.getEntity()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        PowerUser user;
        if (event.getPower() == this && event.hasBlock() && event.getBlockFace() == BlockFace.UP && event.getClickedBlock().getWorld().getEnvironment() != World.Environment.NETHER && (user = event.getUser()).allowPower(this)) {
            if (user.getCooldown(this) <= 0L) {
                BlockFace dir = PowerTools.getDirection(user.getPlayer().getLocation(), false);
                SummonType type = this.getSummonType(event.getClickedBlock().getLocation(), dir);
                if (type != null) {
                    if (this.minions.containsKey(user) && !this.minions.get(user).isDead()) {
                        LivingEntity minion = this.minions.get(user);
                        minion.damage(minion.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
                        this.minions.remove(user);
                    }
                    int height = type == SummonType.PIG_JOCKEY ? 3 : 4;
                    int minX = -Math.abs(type == SummonType.GHAST ? dir.getModZ() * 2 : dir.getModZ());
                    int maxX = Math.abs(type == SummonType.PIG_JOCKEY ? dir.getModZ() : dir.getModZ() * 2);
                    int minZ = -Math.abs(type == SummonType.GHAST ? dir.getModX() * 2 : dir.getModX());
                    int maxZ = Math.abs(type == SummonType.PIG_JOCKEY ? dir.getModX() : dir.getModX() * 2);
                    ArrayList<Block> frame = new ArrayList<Block>();
                    ArrayList<Block> portal = new ArrayList<Block>();
                    for (int x = minX; x <= maxX; ++x) {
                        for (int y = 0; y <= height; ++y) {
                            for (int z = minZ; z <= maxZ; ++z) {
                                if (x == minX && minX != 0 || x == maxX && maxX != 0 || z == minZ && minZ != 0 || z == maxZ && maxZ != 0 || y == 0 || y == height) {
                                    frame.add(event.getClickedBlock().getRelative(x, y, z));
                                    continue;
                                }
                                portal.add(event.getClickedBlock().getRelative(x, y, z));
                            }
                        }
                    }
                    new SummonPortal(user, event.getClickedBlock().getLocation(), frame, portal, dir, type);
                    user.setCooldown(this, (Long)user.getOption(this.cooldown));
                } else {
                    user.getPlayer().sendMessage(this.noRoom);
                }
            } else {
                user.showCooldown(this);
            }
        }
    }

    private static enum SummonType {
        BLAZE,
        GHAST,
        PIG_JOCKEY,
        PIG_ZOMBIE,
        WITHER_SKELETON;

    }

    private class SummonPortal {
        private final Collection<Block> frame;
        private final Collection<Block> portal;
        private final BlockFace face;
        private final Location loc;
        private final PowerUser owner;
        private final SummonType type;
        private BukkitRunnable breakPortal = new BukkitRunnable(){

            public void run() {
                for (Block block : SummonPortal.this.frame) {
                    block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)Material.OBSIDIAN);
                }
                for (Block block : SummonPortal.this.portal) {
                    block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)Material.NETHER_PORTAL);
                }
                PowerTools.blockUpdate(SummonPortal.this.frame);
                PowerTools.blockUpdate(SummonPortal.this.portal);
            }
        };
        private BukkitRunnable delayedSpawn = new BukkitRunnable(){

            public void run() {
                Location spawn = SummonPortal.this.loc.add((double)SummonPortal.this.face.getModX(), 1.0, (double)SummonPortal.this.face.getModZ());
                LivingEntity minion = null;
                switch (SummonPortal.this.type) {
                    case BLAZE: {
                        minion = (LivingEntity)spawn.getWorld().spawn(spawn, Blaze.class);
                        break;
                    }
                    case GHAST: {
                        minion = (LivingEntity)spawn.getWorld().spawn(spawn, Ghast.class);
                        break;
                    }
                    case PIG_JOCKEY: {
                        minion = (LivingEntity)spawn.getWorld().spawn(spawn, PigZombie.class);
                        Chicken ch = (Chicken)spawn.getWorld().spawn(spawn, Chicken.class);
                        ((PigZombie)minion).setBaby();
                        ch.addPassenger((Entity)minion);
                        break;
                    }
                    case PIG_ZOMBIE: {
                        minion = (LivingEntity)spawn.getWorld().spawn(spawn, PigZombie.class);
                        break;
                    }
                    case WITHER_SKELETON: {
                        minion = (LivingEntity)spawn.getWorld().spawn(spawn, WitherSkeleton.class);
                    }
                }
                if (minion != null) {
                    if (minion instanceof Creature) {
                        PowerTools.setTamed((Creature)minion, SummonPortal.this.owner);
                    }
                    Summoner.this.minions.put(SummonPortal.this.owner, minion);
                }
            }
        };

        public SummonPortal(PowerUser owner, Location loc, Collection<Block> frame, Collection<Block> portal, BlockFace face, SummonType type) {
            this.face = face;
            this.frame = frame;
            this.loc = loc;
            this.owner = owner;
            this.portal = portal;
            this.type = type;
            this.renderPortal();
            Summoner.this.runTaskLater((Runnable)this.delayedSpawn, 20L);
            Summoner.this.runTaskLater((Runnable)this.breakPortal, 40L);
        }

        private void renderPortal() {
            Summoner.this.runTask((Runnable)new BukkitRunnable(){

                public void run() {
                    PowerTools.blockDisguise(SummonPortal.this.frame, Material.OBSIDIAN, Material.OBSIDIAN.createBlockData());
                    Summoner.this.portalData.setAxis(PowerTools.getAxis(SummonPortal.this.face));
                    PowerTools.blockDisguise(SummonPortal.this.portal, Material.NETHER_PORTAL, (BlockData)Summoner.this.portalData);
                }
            });
        }
    }
}

