/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import java.util.Map;
import java.util.WeakHashMap;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Snow Miser", type=PowerType.DEFENSE, author="sirrus86", concept="bobby16may", icon=Material.SNOWBALL, description="[snowOrIce]Thrown snowballs[freeze-water] freeze water into ice[/freeze-water][snowAndIce] and[/snowAndIce][add-snow-cover] produce snow on other surfaces[/add-snow-cover]. [/snowOrIce]Snowballs thrown at enemies are slowed for [freeze-duration], increasing in effect with each application. Users of this power cannot be frozen by other users.")
public class SnowMiser
extends Power {
    private Map<Snowball, Integer> snowballs;
    private PowerOption<Boolean> addSnow;
    private PowerOption<Boolean> freezeWater;
    private PowerOption<Integer> freezeCap;
    private PowerOption<Long> freezeDur;
    private boolean snowAndIce;
    private boolean snowOrIce;

    @Override
    protected void onEnable() {
        this.snowballs = new WeakHashMap<Snowball, Integer>();
    }

    @Override
    protected void onDisable() {
        for (Snowball snowball : this.snowballs.keySet()) {
            if (this.snowballs.get(snowball) < 0) continue;
            this.cancelTask(this.snowballs.get(snowball));
        }
    }

    @Override
    protected void config() {
        this.addSnow = this.option("add-snow-cover", true, "Whether snowballs that hit solid surfaces should cover them with a snow layer.");
        this.freezeCap = this.option("freeze-amplifier-cap", 6, "Maximum amplifier of slowness effect applied to victims.");
        this.freezeDur = this.option("freeze-duration", PowerTime.toMillis(3, 0), "How long victims of snowballs are slowed.");
        this.freezeWater = this.option("freeze-water", true, "Whether water hit by snowballs should turn into ice.");
        this.snowAndIce = this.getOption(this.addSnow) != false && this.getOption(this.freezeWater) != false;
        this.snowOrIce = this.getOption(this.addSnow) != false || this.getOption(this.freezeWater) != false;
        this.supplies(new ItemStack(Material.SNOWBALL, 16));
    }

    private int trackSnowball(final Snowball snowball) {
        return this.runTaskLater((Runnable)new BukkitRunnable(){

            public void run() {
                if (snowball.isValid()) {
                    Block block = snowball.getLocation().getBlock();
                    if (block.getType() == Material.WATER && ((Boolean)SnowMiser.this.getOption(SnowMiser.this.freezeWater)).booleanValue()) {
                        block.setType(Material.ICE);
                        snowball.remove();
                    } else {
                        SnowMiser.this.snowballs.put(snowball, SnowMiser.this.trackSnowball(snowball));
                    }
                }
            }
        }, 1L).getTaskId();
    }

    @EventHandler(ignoreCancelled=true)
    private void onHit(EntityDamageByEntityEvent event) {
        LivingEntity target;
        if (event.getEntity() instanceof LivingEntity && !(event.getEntity() instanceof Snowman) && event.getDamager() instanceof Snowball && this.snowballs.containsKey(event.getDamager()) && (!((target = (LivingEntity)event.getEntity()) instanceof Player) || !this.getUser((OfflinePlayer)((Player)target)).hasPower(this))) {
            int amplifier = 0;
            if (target.hasPotionEffect(PotionEffectType.SLOW)) {
                amplifier = Integer.min(this.getOption(this.freezeCap), target.getPotionEffect(PotionEffectType.SLOW).getAmplifier() + 1);
            }
            target.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, (int)PowerTime.toTicks(this.getOption(this.freezeDur)), amplifier));
        }
    }

    @EventHandler
    private void onHit(ProjectileHitEvent event) {
        Block hitBlock;
        Block checkBlock;
        if (event.getEntity() instanceof Snowball && this.snowballs.containsKey(event.getEntity()) && (checkBlock = (hitBlock = event.getEntity().getLocation().getBlock()).getRelative(BlockFace.DOWN)).getType().isSolid() && hitBlock.isEmpty() && this.getOption(this.addSnow).booleanValue()) {
            hitBlock.setType(Material.SNOW);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onThrow(ProjectileLaunchEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Snowball && event.getEntity().getShooter() != null && event.getEntity().getShooter() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity().getShooter()))).allowPower(this)) {
            this.snowballs.put((Snowball)event.getEntity(), user.getOption(this.freezeWater) != false ? this.trackSnowball((Snowball)event.getEntity()) : -1);
        }
    }
}

