/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

@PowerManifest(name="Phasewalk", type=PowerType.DEFENSE, author="sirrus86", concept="FSCarver", icon=Material.PHANTOM_MEMBRANE, usesPackets=true, description="[act:item]ing while holding [item] phases you into another reality, becoming invisible to all nearby enemies[consume-item], consuming the [item] in the process[/consume-item]. While phased you're immune to damage, your speed increases, and you can move through walls one block deep. [act:item]ing [item] again unphases you, mildly damaging nearby enemies.[destabilize.enabled] Your Phasewalk will begin destabilizing if you don't unphase within [destabilize.duration], consuming held [item] every [destabilize.frequency] thereafter.[/destabilize.enabled] [cooldown] cooldown.")
public final class Phasewalk
extends Power {
    private Set<PowerUser> destabilizing;
    private Map<PowerUser, Integer> tasks;
    private String beginDestab;
    private String phaseBack;
    private String phaseOut;
    private PowerOption<Boolean> consume;
    private PowerOption<Boolean> destabilize;
    private PowerOption<Long> destabFreq;
    private PowerOption<Long> destabTimer;
    private PowerOption<List<PotionEffect>> phaseEffects;

    @Override
    protected void onEnable() {
        this.destabilizing = new HashSet<PowerUser>();
        this.tasks = new ConcurrentHashMap<PowerUser, Integer>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.tasks.containsKey(user)) {
            this.unphase(user);
        }
    }

    @Override
    protected void config() {
        this.consume = this.option("consume-item", true, "Whether item should be consumed when triggering power.");
        this.cooldown = this.option("cooldown", PowerTime.toMillis(10, 0), "Amount of time before power can be used again.");
        this.destabFreq = this.option("destabilize.frequency", PowerTime.toMillis(1, 0), "How often destabilization should consume an item.");
        this.destabilize = this.option("destabilize.enabled", true, "Whether power should destabilize over time.");
        this.destabTimer = this.option("destabilize.duration", PowerTime.toMillis(30, 0), "How long before destabilization should occur after power is first used.");
        this.item = this.option("item", new ItemStack(Material.PHANTOM_MEMBRANE, 1), "Item used to trigger phasewalking, as well as the item consumed if it destabilizes.");
        this.phaseEffects = this.option("phase-effects", List.of(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, 0, false, false, false), new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 1, false, false, false)), "Potion effects that should affect a user while phasewalking.");
        this.beginDestab = this.locale("message.begin-destabilizing", ChatColor.RED + "Phasewalk begins destabilizing.");
        this.phaseBack = this.locale("message.phase-back", ChatColor.RED + "You phase back into reality.");
        this.phaseOut = this.locale("message.phase-out", ChatColor.GREEN + "You phase out of reality...");
        this.supplies(new ItemStack(this.getRequiredItem().getType(), this.getRequiredItem().getMaxStackSize()));
    }

    private Runnable phasewalk(final PowerUser user) {
        return new BukkitRunnable(){

            public void run() {
                if (!Phasewalk.this.destabilizing.contains(user)) {
                    user.sendMessage(Phasewalk.this.beginDestab);
                    Phasewalk.this.destabilizing.add(user);
                }
                if (user.getPlayer().getInventory().containsAtLeast(Phasewalk.this.getRequiredItem(), 1)) {
                    user.getPlayer().getInventory().removeItem(new ItemStack[]{Phasewalk.this.getRequiredItem()});
                    user.getPlayer().getWorld().spawnParticle(Particle.ITEM_CRACK, user.getPlayer().getEyeLocation().add(user.getPlayer().getLocation().getDirection()), 1, (Object)((ItemStack)user.getOption(Phasewalk.this.item)));
                    Phasewalk.this.tasks.put(user, Phasewalk.this.getInstance().runTaskLater(Phasewalk.this.phasewalk(user), PowerTime.toTicks((Long)user.getOption(Phasewalk.this.destabFreq))).getTaskId());
                } else {
                    Phasewalk.this.unphase(user);
                }
            }
        };
    }

    private void unphase(PowerUser user) {
        user.sendMessage(this.phaseBack);
        user.removePotionEffects((Collection<PotionEffect>)user.getOption(this.phaseEffects));
        this.destabilizing.remove(user);
        PowerTools.removeGhost(user.getPlayer());
        if (this.tasks.containsKey(user)) {
            this.cancelTask(this.tasks.get(user));
        }
        this.tasks.remove(user);
        user.setCooldown(this, (Long)user.getOption(this.cooldown));
    }

    @EventHandler(ignoreCancelled=true)
    private void onMove(PlayerMoveEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this) && this.tasks.containsKey(user) && event.getFrom().distanceSquared(event.getTo()) > 0.0) {
            Location oldLoc = user.getPlayer().getLocation().clone();
            Vector vec = event.getTo().toVector().subtract(event.getFrom().toVector()).multiply(3);
            Block[] blocks = new Block[]{oldLoc.getBlock().getRelative((int)vec.getX(), (int)vec.getY(), (int)vec.getZ()), oldLoc.getBlock().getRelative((int)vec.getX() * 2, (int)vec.getY() * 2, (int)vec.getZ() * 2)};
            for (int i = 0; i < blocks.length; ++i) {
                if (!(i == 0 ? !blocks[i].getType().isSolid() && !blocks[i].getRelative(BlockFace.UP).getType().isSolid() : blocks[i].getType().isSolid() || blocks[i].getRelative(BlockFace.UP).getType().isSolid())) continue;
                return;
            }
            Location newLoc = new Location(oldLoc.getWorld(), oldLoc.getX() + vec.getX() * 2.0, oldLoc.getY() + vec.getY() * 2.0, oldLoc.getZ() + vec.getZ() * 2.0, oldLoc.getYaw(), oldLoc.getPitch());
            newLoc.getWorld().spawnParticle(Particle.CRIT_MAGIC, newLoc, 5);
            user.getPlayer().playSound(newLoc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            user.getPlayer().teleport(newLoc);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        if (event.getPower() == this) {
            PowerUser user = event.getUser();
            if (user.getCooldown(this) <= 0L) {
                if (!this.tasks.containsKey(user)) {
                    user.addPotionEffects((Collection<PotionEffect>)user.getOption(this.phaseEffects));
                    PowerTools.addGhost(user.getPlayer());
                    user.sendMessage(this.phaseOut);
                    if (user.getOption(this.consume).booleanValue()) {
                        event.consumeItem();
                    }
                    if (user.getOption(this.destabilize).booleanValue()) {
                        this.tasks.put(user, this.runTaskLater(this.phasewalk(user), PowerTime.toTicks(user.getOption(this.destabTimer))).getTaskId());
                    }
                } else {
                    this.unphase(user);
                }
            } else {
                user.showCooldown(this);
            }
        }
    }
}

