/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Necromancer", type=PowerType.DEFENSE, author="sirrus86", concept="nazizombies2354", icon=Material.BONE, description="[act:item]ing while holding [item] creates an aura of death around you. The aura causes nearby vegetation to decay, causes weakness to the living, and pulls the dead from their graves. Reanimated undead will follow and defend you. [cooldown] cooldown.")
public final class Necromancer
extends Power {
    private Set<Aura> auras;
    private Map<Monster, PowerUser> minions;
    private PowerOption<Long> auraDur;
    private PowerOption<Integer> auraRad;
    private PowerOption<Integer> maxMinions;
    private PowerOption<Integer> wkLvl;
    private PowerOption<List<String>> decayBlocks;
    private PowerOption<Boolean> noIgnite;
    private PowerStat summons;

    @Override
    protected void onEnable() {
        this.auras = new HashSet<Aura>();
        this.minions = new HashMap<Monster, PowerUser>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        for (Aura aura : this.auras) {
            if (aura.getOwner() != user) continue;
            aura.destroy();
        }
        Iterator<Monster> it2 = this.minions.keySet().iterator();
        while (it2.hasNext()) {
            Monster mob = it2.next();
            if (this.minions.get(mob) != user) continue;
            Monster newMob = (Monster)mob.getWorld().spawnEntity(mob.getLocation(), mob.getType());
            mob.remove();
            newMob.setTarget((LivingEntity)user.getPlayer());
            it2.remove();
        }
    }

    @Override
    protected void config() {
        this.auraDur = this.option("aura-duration", PowerTime.toMillis(10, 0), "Amount of time an aura will last before dissipating.");
        this.auraRad = this.option("aura-radius", 5, "Maximum radius of a given aura.");
        this.cooldown = this.option("cooldown", PowerTime.toMillis(30, 0), "Amount of time before power can be used again.");
        this.decayBlocks = this.option("decay-blocks", Lists.newArrayList((Object[])new String[]{"GRASS_BLOCK", "MYCELIUM", "PODZOL"}), "Block types which should turn to dirt when undead are summoned.");
        this.item = this.option("item", new ItemStack(Material.ROTTEN_FLESH), "Item used to create auras.");
        this.maxMinions = this.option("maximum-undead", 3, "Maximum number of undead that can be reanimated. Players will be reanimated regardless of whether the cap is met.");
        this.noIgnite = this.option("prevent-ignition", true, "Whether to prevent undead from igniting in sunlight.");
        this.summons = this.stat("undead-reanimated", 75, "Undead reanimated", "Players killed while in your aura will immediately be resurrected as an undead wearing their equipment.");
        this.wkLvl = this.option("weakness-amplifier", 4, "Amplification of weakness effect on living entities within an aura.");
        this.supplies(new ItemStack(this.getRequiredItem().getType(), this.getRequiredItem().getMaxStackSize()));
    }

    private boolean hasTooManyMinions(PowerUser user) {
        int i = 0;
        for (Map.Entry<Monster, PowerUser> entry : this.minions.entrySet()) {
            if (entry.getValue() == user && entry.getKey().isValid()) {
                ++i;
            }
            if (i < user.getOption(this.maxMinions)) continue;
            return true;
        }
        return false;
    }

    @EventHandler(ignoreCancelled=true)
    private void onIgnite(EntityCombustEvent event) {
        if (this.getOption(this.noIgnite).booleanValue() && !(event instanceof EntityCombustByBlockEvent) && !(event instanceof EntityCombustByEntityEvent) && this.minions.containsKey(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onDeath(EntityDeathEvent event) {
        if ((event.getEntityType() == EntityType.SKELETON || event.getEntityType() == EntityType.ZOMBIE) && this.minions.containsKey(event.getEntity())) {
            this.minions.remove(event.getEntity());
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onTarget(EntityTargetLivingEntityEvent event) {
        PowerUser user;
        if ((event.getEntity() instanceof Skeleton || event.getEntity() instanceof Zombie) && event.getTarget() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getTarget()))).allowPower(this)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        for (Aura aura : this.auras) {
            if (!aura.getBlocks().contains(player.getLocation().getBlock()) || !aura.getOwner().hasStatMaxed(this.summons)) continue;
            Zombie zombie = (Zombie)player.getWorld().spawn(player.getLocation(), Zombie.class);
            PowerTools.setTamed((Creature)zombie, aura.getOwner());
            zombie.setCustomName(player.getName() + "'s Zombie");
            Iterator it = event.getDrops().iterator();
            while (it.hasNext()) {
                ItemStack drop = (ItemStack)it.next();
                if (it == player.getInventory().getBoots()) {
                    zombie.getEquipment().setBoots(drop);
                    zombie.getEquipment().setBootsDropChance(1.0f);
                    it.remove();
                }
                if (it == player.getInventory().getChestplate()) {
                    zombie.getEquipment().setChestplate(drop);
                    zombie.getEquipment().setChestplateDropChance(1.0f);
                    it.remove();
                }
                if (it == player.getInventory().getHelmet()) {
                    zombie.getEquipment().setHelmet(drop);
                    zombie.getEquipment().setHelmetDropChance(1.0f);
                    it.remove();
                }
                if (it == player.getInventory().getLeggings()) {
                    zombie.getEquipment().setLeggings(drop);
                    zombie.getEquipment().setLeggingsDropChance(1.0f);
                    it.remove();
                }
                if (it == player.getInventory().getItemInMainHand()) {
                    zombie.getEquipment().setItemInMainHand(drop);
                    zombie.getEquipment().setItemInMainHandDropChance(1.0f);
                    it.remove();
                }
                if (it != player.getInventory().getItemInOffHand()) continue;
                zombie.getEquipment().setItemInOffHand(drop);
                zombie.getEquipment().setItemInOffHandDropChance(1.0f);
                it.remove();
            }
            this.minions.put((Monster)zombie, aura.getOwner());
            aura.getOwner().increaseStat(this.summons, 1);
            break;
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        PowerUser user;
        if (event.getPower() == this && (user = event.getUser()).allowPower(this)) {
            if (user.getCooldown(this) <= 0L) {
                this.auras.add(new Aura(user));
                user.setCooldown(this, (Long)user.getOption(this.cooldown));
            } else {
                user.showCooldown(this);
            }
        }
    }

    private class Aura {
        private Set<Block> blocks = new HashSet<Block>();
        private final Location loc;
        private final int task;
        private final long time;
        private final PowerUser user;
        private Runnable createAura = new BukkitRunnable(){
            private int i = 0;

            public void run() {
                int j = random.nextInt(5);
                if (this.i <= (Integer)Aura.this.user.getOption(Necromancer.this.auraRad)) {
                    Aura.this.blocks.addAll(PowerTools.getNearbyBlocks(Aura.this.loc, this.i));
                    ++this.i;
                }
                for (Block block : Aura.this.blocks) {
                    if (((List)Aura.this.user.getOption(Necromancer.this.decayBlocks)).contains(block.getType().name())) {
                        block.setType(Material.DIRT);
                    }
                    if (!block.getType().isSolid() && !block.getRelative(BlockFace.UP).getType().isSolid() && block.getRelative(BlockFace.DOWN).getType().isSolid() && random.nextInt(5) == j && !Necromancer.this.hasTooManyMinions(Aura.this.user)) {
                        Block bDown = block.getRelative(BlockFace.DOWN);
                        bDown.getWorld().playEffect(bDown.getLocation(), Effect.STEP_SOUND, (Object)bDown.getType());
                        Monster newMob = random.nextInt(2) == 0 ? (Monster)block.getWorld().spawn(block.getLocation(), Skeleton.class) : (Monster)block.getWorld().spawn(block.getLocation(), Zombie.class);
                        PowerTools.setTamed((Creature)newMob, Aura.this.user);
                        Necromancer.this.minions.put(newMob, Aura.this.user);
                        Aura.this.user.increaseStat(Necromancer.this.summons, 1);
                    }
                    PowerTools.playParticleEffect(block.getLocation(), Particle.TOWN_AURA, 1);
                }
                for (LivingEntity entity : PowerTools.getNearbyEntities(LivingEntity.class, Aura.this.loc, this.i)) {
                    if (entity instanceof Skeleton || entity instanceof Zombie || entity == Aura.this.user.getPlayer()) continue;
                    entity.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 20, ((Integer)Aura.this.user.getOption(Necromancer.this.wkLvl)).intValue()));
                }
                if (System.currentTimeMillis() >= Aura.this.time) {
                    Aura.this.destroy();
                }
            }
        };

        public Aura(PowerUser user) {
            this.user = user;
            this.loc = user.getPlayer().getEyeLocation();
            this.time = System.currentTimeMillis() + (Long)user.getOption(Necromancer.this.auraDur);
            this.task = Necromancer.this.runTaskTimer(this.createAura, 0L, 5L).getTaskId();
        }

        public Set<Block> getBlocks() {
            return this.blocks;
        }

        public PowerUser getOwner() {
            return this.user;
        }

        public void destroy() {
            Necromancer.this.auras.remove(this);
            Necromancer.this.cancelTask(this.task);
        }
    }
}

