/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.tools.version.MCVersion;
import me.sirrus86.s86powers.users.PowerUser;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Steerable;
import org.bukkit.entity.Strider;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Colorable;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

@PowerManifest(name="Mob Catcher", type=PowerType.DEFENSE, author="sirrus86", concept="kamyarm007", version=MCVersion.v1_14, icon=Material.ZOMBIE_SPAWN_EGG, usesPackets=true, description="[act:item]ing while holding [item] throws it. If it hits a capturable entity, it will be stored in the [item] which is returned to you. [act:item]ing a [item] with a stored entity will thorw it, causing it to expel the stored entity on contact.")
public final class MobCatcher
extends Power {
    private final Set<EntityType> capturable = EnumSet.of(EntityType.BAT, new EntityType[]{EntityType.BLAZE, EntityType.CAT, EntityType.CAVE_SPIDER, EntityType.CHICKEN, EntityType.COW, EntityType.CREEPER, EntityType.DOLPHIN, EntityType.DROWNED, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.FOX, EntityType.GHAST, EntityType.GUARDIAN, EntityType.HUSK, EntityType.MAGMA_CUBE, EntityType.MUSHROOM_COW, EntityType.OCELOT, EntityType.PANDA, EntityType.PARROT, EntityType.PHANTOM, EntityType.PIG, PowerTools.resolveEntityType("PIGZOMBIE"), EntityType.POLAR_BEAR, EntityType.RABBIT, EntityType.SHEEP, EntityType.SHULKER, EntityType.SILVERFISH, EntityType.SKELETON, EntityType.SLIME, EntityType.SPIDER, EntityType.SQUID, EntityType.STRAY, EntityType.TURTLE, EntityType.WITCH, EntityType.WITHER_SKELETON, EntityType.WOLF, EntityType.ZOMBIE});
    private final NamespacedKey ageableAge = this.createNamespacedKey("ageable-age");
    private final NamespacedKey axolotlVariant = this.createNamespacedKey("axolotl-variant");
    private final NamespacedKey beeHasNectar = this.createNamespacedKey("bee-has-nectar");
    private final NamespacedKey beeHasStung = this.createNamespacedKey("bee-has-stung");
    private final NamespacedKey catType = this.createNamespacedKey("cat-type");
    private final NamespacedKey collarColor = this.createNamespacedKey("collar-color");
    private final NamespacedKey colorableColor = this.createNamespacedKey("colorable-color");
    private final NamespacedKey creeperPowered = this.createNamespacedKey("creeper-powered");
    private final NamespacedKey customName = this.createNamespacedKey("custom-name");
    private final NamespacedKey entityHealth = this.createNamespacedKey("entity-health");
    private final NamespacedKey entityType = this.createNamespacedKey("entity-type");
    private final NamespacedKey foxType = this.createNamespacedKey("fox-type");
    private final NamespacedKey goatScreaming = this.createNamespacedKey("goat-screaming");
    private final NamespacedKey mooshroomVariant = this.createNamespacedKey("mooshroom-variant");
    private final NamespacedKey ownerUUID = this.createNamespacedKey("owner-uuid");
    private final NamespacedKey pandaHiddenGene = this.createNamespacedKey("panda-hidden-gene");
    private final NamespacedKey pandaMainGene = this.createNamespacedKey("panda-main-gene");
    private final NamespacedKey parrotVariant = this.createNamespacedKey("parrot-variant");
    private final NamespacedKey phantomSize = this.createNamespacedKey("phantom-size");
    private final NamespacedKey rabbitType = this.createNamespacedKey("rabbit-type");
    private final NamespacedKey sheepSheared = this.createNamespacedKey("sheep-sheared");
    private final NamespacedKey slimeSize = this.createNamespacedKey("slime-size");
    private final NamespacedKey steerableSaddle = this.createNamespacedKey("steerable-saddle");
    private Set<EntityType> allowCapture;
    private Map<Snowball, ItemStack> eggs;
    private Map<Snowball, PowerUser> eggOwners;
    private String cantCapTamed;
    private PowerOption<Boolean> captureTamed;
    private PowerStat eggsThrown;

    @Override
    protected void onEnable() {
        this.allowCapture = EnumSet.noneOf(EntityType.class);
        this.eggOwners = new HashMap<Snowball, PowerUser>();
        this.eggs = new HashMap<Snowball, ItemStack>();
    }

    @Override
    protected void config() {
        this.captureTamed = this.option("capture-tamed", false, "Whether entities tamed by other players (wolves, cats, etc) can be captured.");
        this.eggsThrown = this.stat("eggs-thrown", 50, "Entities relocated", "[item] is now refunded after expelling a stored entity.");
        this.item = this.option("item", new ItemStack(Material.ENDER_EYE, 1), "Item used to catch and store mobs.");
        for (EntityType eType : this.capturable) {
            PowerOption<Boolean> capturable = this.option("capturable." + eType.toString().replaceAll("_", "-").toLowerCase(), true, "Whether " + WordUtils.capitalizeFully((String)eType.toString().replaceAll("_", " ")) + " should be capturable.");
            if (!this.getOption(capturable).booleanValue()) continue;
            this.allowCapture.add(eType);
        }
        this.cantCapTamed = this.locale("message.cant-capture-tamed", ChatColor.RED + "You can't capture entities tamed by other players.");
        this.supplies(new ItemStack(this.getRequiredItem().getType(), this.getRequiredItem().getMaxStackSize()));
    }

    private ItemStack createEgg(LivingEntity entity) {
        ItemStack egg = new ItemStack(this.getRequiredItem().getType(), 1);
        ItemMeta meta = egg.hasItemMeta() ? this.getRequiredItem().getItemMeta() : entity.getServer().getItemFactory().getItemMeta(this.getRequiredItem().getType());
        PersistentDataContainer iData = meta.getPersistentDataContainer();
        ArrayList<String> stats = new ArrayList<String>();
        iData.set(this.entityType, PersistentDataType.STRING, (Object)entity.getType().toString());
        iData.set(this.entityHealth, PersistentDataType.DOUBLE, (Object)entity.getHealth());
        stats.add("Health: " + entity.getHealth() + "/" + entity.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
        if (entity instanceof Ageable) {
            if (!((Ageable)entity).isAdult()) {
                stats.add("Juvenile");
            }
            iData.set(this.ageableAge, PersistentDataType.INTEGER, (Object)((Ageable)entity).getAge());
        }
        if (entity instanceof Tameable && ((Tameable)entity).isTamed()) {
            iData.set(this.ownerUUID, PersistentDataType.STRING, (Object)((Tameable)entity).getOwner().getUniqueId().toString());
        }
        switch (entity.getType().name()) {
            case "AXOLOTL": {
                stats.add("Type: " + WordUtils.capitalize((String)((Axolotl)entity).getVariant().toString().replace("_", " ").toLowerCase()));
                iData.set(this.axolotlVariant, PersistentDataType.INTEGER, (Object)((Axolotl)entity).getVariant().ordinal());
                break;
            }
            case "BEE": {
                iData.set(this.beeHasNectar, PersistentDataType.BYTE, (Object)(((Bee)entity).hasNectar() ? (byte)1 : 0));
                iData.set(this.beeHasStung, PersistentDataType.BYTE, (Object)(((Bee)entity).hasStung() ? (byte)1 : 0));
                break;
            }
            case "CAT": {
                stats.add("Type: " + WordUtils.capitalize((String)((Cat)entity).getCatType().toString().replace("_", " ").toLowerCase()));
                iData.set(this.catType, PersistentDataType.STRING, (Object)((Cat)entity).getCatType().toString());
                iData.set(this.collarColor, PersistentDataType.STRING, (Object)((Cat)entity).getCollarColor().toString());
                break;
            }
            case "CREEPER": {
                if (((Creeper)entity).isPowered()) {
                    stats.add("Powered");
                }
                iData.set(this.creeperPowered, PersistentDataType.BYTE, (Object)(((Creeper)entity).isPowered() ? (byte)1 : 0));
                break;
            }
            case "FOX": {
                stats.add("Type: " + WordUtils.capitalize((String)((Fox)entity).getFoxType().toString().replace("_", " ").toLowerCase()));
                iData.set(this.foxType, PersistentDataType.STRING, (Object)((Fox)entity).getFoxType().toString());
                break;
            }
            case "GOAT": {
                iData.set(this.goatScreaming, PersistentDataType.BYTE, (Object)(((Goat)entity).isScreaming() ? (byte)1 : 0));
                break;
            }
            case "MAGMA_CUBE": 
            case "SLIME": {
                stats.add("Size: " + ((Slime)entity).getSize());
                iData.set(this.slimeSize, PersistentDataType.INTEGER, (Object)((Slime)entity).getSize());
                break;
            }
            case "MUSHROOM_COW": {
                stats.add("Color: " + WordUtils.capitalize((String)((MushroomCow)entity).getVariant().toString().replace("_", " ").toLowerCase()));
                iData.set(this.foxType, PersistentDataType.STRING, (Object)((MushroomCow)entity).getVariant().toString());
                break;
            }
            case "PANDA": {
                iData.set(this.pandaHiddenGene, PersistentDataType.STRING, (Object)((Panda)entity).getHiddenGene().toString());
                iData.set(this.pandaMainGene, PersistentDataType.STRING, (Object)((Panda)entity).getMainGene().toString());
                break;
            }
            case "PARROT": {
                stats.add("Color: " + WordUtils.capitalize((String)((Parrot)entity).getVariant().toString().replace("_", " ").toLowerCase()));
                iData.set(this.parrotVariant, PersistentDataType.STRING, (Object)((Parrot)entity).getVariant().toString());
                break;
            }
            case "PHANTOM": {
                iData.set(this.phantomSize, PersistentDataType.INTEGER, (Object)((Phantom)entity).getSize());
                break;
            }
            case "PIG": {
                if (((Pig)entity).hasSaddle()) {
                    stats.add("Saddled");
                }
                iData.set(this.steerableSaddle, PersistentDataType.BYTE, (Object)(((Pig)entity).hasSaddle() ? (byte)1 : 0));
                break;
            }
            case "RABBIT": {
                stats.add("Type: " + WordUtils.capitalize((String)((Rabbit)entity).getRabbitType().toString().replace("_", " ").toLowerCase()));
                iData.set(this.rabbitType, PersistentDataType.STRING, (Object)((Rabbit)entity).getRabbitType().toString());
                break;
            }
            case "SHEEP": {
                stats.add("Color: " + WordUtils.capitalize((String)((Sheep)entity).getColor().toString().replace("_", " ").toLowerCase()));
                iData.set(this.colorableColor, PersistentDataType.STRING, (Object)((Sheep)entity).getColor().toString());
                iData.set(this.sheepSheared, PersistentDataType.BYTE, (Object)(((Sheep)entity).isSheared() ? (byte)1 : 0));
                break;
            }
            case "SHULKER": {
                stats.add("Color: " + WordUtils.capitalize((String)((Shulker)entity).getColor().toString().replace("_", " ").toLowerCase()));
                iData.set(this.colorableColor, PersistentDataType.STRING, (Object)((Shulker)entity).getColor().toString());
                break;
            }
            case "STRIDER": {
                if (((Strider)entity).hasSaddle()) {
                    stats.add("Saddled");
                }
                iData.set(this.steerableSaddle, PersistentDataType.BYTE, (Object)(((Strider)entity).hasSaddle() ? (byte)1 : 0));
                break;
            }
            case "WOLF": {
                iData.set(this.collarColor, PersistentDataType.STRING, (Object)((Wolf)entity).getCollarColor().toString());
            }
        }
        meta.setDisplayName(WordUtils.capitalize((String)entity.getType().name().replaceAll("_", " ").toLowerCase()));
        if (entity.getCustomName() != null) {
            meta.setDisplayName(entity.getCustomName());
            iData.set(this.customName, PersistentDataType.STRING, (Object)entity.getCustomName());
        }
        meta.setLore(stats);
        egg.setItemMeta(meta);
        return egg;
    }

    private LivingEntity createEntity(ItemStack egg, Location loc) {
        ItemMeta meta = egg.getItemMeta();
        PersistentDataContainer iData = meta.getPersistentDataContainer();
        LivingEntity entity = (LivingEntity)loc.getWorld().spawnEntity(loc, EntityType.valueOf((String)((String)meta.getPersistentDataContainer().get(this.entityType, PersistentDataType.STRING))));
        if (entity instanceof Ageable) {
            ((Ageable)entity).setAge(((Integer)iData.get(this.ageableAge, PersistentDataType.INTEGER)).intValue());
        }
        if (entity instanceof Cat) {
            ((Cat)entity).setCatType(Cat.Type.valueOf((String)((String)iData.get(this.catType, PersistentDataType.STRING))));
            ((Cat)entity).setCollarColor(DyeColor.valueOf((String)((String)iData.get(this.collarColor, PersistentDataType.STRING))));
        }
        if (entity instanceof Colorable) {
            ((Colorable)entity).setColor(DyeColor.valueOf((String)((String)iData.get(this.colorableColor, PersistentDataType.STRING))));
        }
        if (entity instanceof Creeper) {
            ((Creeper)entity).setPowered((Byte)iData.get(this.creeperPowered, PersistentDataType.BYTE) == 1);
        }
        if (entity instanceof Fox) {
            ((Fox)entity).setFoxType(Fox.Type.valueOf((String)((String)iData.get(this.foxType, PersistentDataType.STRING))));
        }
        if (entity instanceof Goat) {
            ((Goat)entity).setScreaming((Byte)iData.get(this.goatScreaming, PersistentDataType.BYTE) == 1);
        }
        if (entity instanceof MushroomCow) {
            ((MushroomCow)entity).setVariant(MushroomCow.Variant.valueOf((String)((String)iData.get(this.mooshroomVariant, PersistentDataType.STRING))));
        }
        if (entity instanceof Panda) {
            ((Panda)entity).setHiddenGene(Panda.Gene.valueOf((String)((String)iData.get(this.pandaHiddenGene, PersistentDataType.STRING))));
            ((Panda)entity).setMainGene(Panda.Gene.valueOf((String)((String)iData.get(this.pandaMainGene, PersistentDataType.STRING))));
        }
        if (entity instanceof Parrot) {
            ((Parrot)entity).setVariant(Parrot.Variant.valueOf((String)((String)iData.get(this.parrotVariant, PersistentDataType.STRING))));
        }
        if (entity instanceof Phantom) {
            ((Phantom)entity).setSize(((Integer)iData.get(this.phantomSize, PersistentDataType.INTEGER)).intValue());
        }
        if (entity instanceof Rabbit) {
            ((Rabbit)entity).setRabbitType(Rabbit.Type.valueOf((String)((String)iData.get(this.rabbitType, PersistentDataType.STRING))));
        }
        if (entity instanceof Sheep) {
            ((Sheep)entity).setSheared((Byte)iData.get(this.sheepSheared, PersistentDataType.BYTE) == 1);
        }
        if (entity instanceof Slime) {
            ((Slime)entity).setSize(((Integer)iData.get(this.slimeSize, PersistentDataType.INTEGER)).intValue());
        }
        if (entity instanceof Steerable) {
            ((Steerable)entity).setSaddle((Byte)iData.get(this.steerableSaddle, PersistentDataType.BYTE) == 1);
        }
        if (entity instanceof Tameable && iData.has(this.ownerUUID, PersistentDataType.STRING)) {
            ((Tameable)entity).setOwner((AnimalTamer)Bukkit.getServer().getOfflinePlayer(UUID.fromString((String)iData.get(this.ownerUUID, PersistentDataType.STRING))));
        }
        if (entity instanceof Wolf) {
            ((Wolf)entity).setCollarColor(DyeColor.valueOf((String)((String)iData.get(this.collarColor, PersistentDataType.STRING))));
        }
        entity.setHealth(((Double)meta.getPersistentDataContainer().get(this.entityHealth, PersistentDataType.DOUBLE)).doubleValue());
        return entity;
    }

    private boolean hasEntityStored(ItemStack item) {
        return item.hasItemMeta() && item.getItemMeta().getPersistentDataContainer().has(this.entityType, PersistentDataType.STRING);
    }

    @EventHandler(ignoreCancelled=true)
    private void onCapture(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Snowball && this.eggs.containsKey(event.getDamager())) {
            PowerUser user;
            Snowball egg = (Snowball)event.getDamager();
            ItemStack spawnEgg = this.eggs.get(egg);
            if (egg.getShooter() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)egg.getShooter()))).allowPower(this) && this.capturable.contains(event.getEntity().getType()) && !this.hasEntityStored(spawnEgg)) {
                LivingEntity entity = (LivingEntity)event.getEntity();
                if (user.getOption(this.captureTamed).booleanValue() || !(entity instanceof Tameable) || entity instanceof Tameable && (((Tameable)entity).getOwner() == user.getPlayer() || ((Tameable)entity).getOwner() == null)) {
                    ItemStack newSpawnEgg = this.createEgg(entity);
                    final Item droppedEgg = entity.getWorld().dropItemNaturally(entity.getLocation(), newSpawnEgg);
                    droppedEgg.setOwner(user.getUUID());
                    entity.playEffect(EntityEffect.ENTITY_POOF);
                    entity.remove();
                    if (!user.getPlayer().getInventory().addItem(new ItemStack[]{newSpawnEgg}).containsValue(newSpawnEgg)) {
                        this.runTask(new Runnable(){

                            @Override
                            public void run() {
                                PowerTools.fakeCollect((Entity)user.getPlayer(), droppedEgg);
                                droppedEgg.remove();
                            }
                        });
                    }
                    this.eggs.remove(egg);
                } else if (!user.getOption(this.captureTamed).booleanValue() && entity instanceof Tameable && ((Tameable)entity).getOwner() != null && ((Tameable)entity).getOwner() != user.getPlayer()) {
                    user.getPlayer().sendMessage(this.cantCapTamed);
                }
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        PowerUser user;
        if (event.getPower() == this && (user = event.getUser()).allowPower(this)) {
            ItemStack item = event.getItem().clone();
            item.setAmount(1);
            Snowball snowball = (Snowball)user.getPlayer().launchProjectile(Snowball.class);
            PowerTools.addDisguise((Entity)snowball, item);
            this.eggs.put(snowball, item);
            if (user.hasStatMaxed(this.eggsThrown)) {
                this.eggOwners.put(snowball, user);
            }
            if (event.getItem().hasItemMeta() && event.getItem().getItemMeta().getPersistentDataContainer().has(this.entityType, PersistentDataType.STRING)) {
                user.increaseStat(this.eggsThrown, 1);
            }
            event.consumeItem();
        }
    }

    @EventHandler
    private void onEggHit(ProjectileHitEvent event) {
        if (this.eggs.containsKey(event.getEntity())) {
            Snowball egg = (Snowball)event.getEntity();
            ItemStack spawnEgg = this.eggs.get(egg);
            if (this.hasEntityStored(spawnEgg)) {
                this.createEntity(spawnEgg, egg.getLocation());
                this.eggs.remove(egg);
                if (this.eggOwners.containsKey(egg)) {
                    final Item droppedEgg = egg.getWorld().dropItemNaturally(egg.getLocation(), this.getRequiredItem());
                    final PowerUser user = this.eggOwners.get(egg);
                    droppedEgg.setOwner(user.getUUID());
                    if (!user.getPlayer().getInventory().addItem(new ItemStack[]{this.getRequiredItem()}).containsValue(this.getRequiredItem())) {
                        this.runTask(new Runnable(){

                            @Override
                            public void run() {
                                PowerTools.fakeCollect((Entity)user.getPlayer(), droppedEgg);
                                droppedEgg.remove();
                            }
                        });
                    }
                }
            } else if (event.getHitEntity() == null || !this.capturable.contains(event.getHitEntity().getType())) {
                egg.getWorld().dropItemNaturally(egg.getLocation(), spawnEgg);
            }
        }
    }
}

