/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Silverfish;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Locust Swarm", type=PowerType.DEFENSE, author="sirrus86", concept="sirrus86", icon=Material.STONE, description="[act:item]ing while holding [item] will cause Silverfish to break from any nearby [infested-only]infested [/infested-only]stone blocks, targeting nearby entities at random. After [silverfish-lifespan], spawned Silverfish reform into blocks. [cooldown] cooldown.")
public final class LocustSwarm
extends Power {
    private Map<PowerUser, Set<Swarm>> swarms;
    private PowerOption<Boolean> infestOnly;
    private PowerOption<Long> lifespan;
    private PowerOption<List<String>> spawnBlocks;
    private PowerStat summonCount;
    private PowerOption<Integer> summonMax;
    private PowerOption<Double> summonRad;

    @Override
    protected void onEnable() {
        this.swarms = new HashMap<PowerUser, Set<Swarm>>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.swarms.containsKey(user) && this.swarms.get(user) != null) {
            for (Swarm swarm : this.swarms.get(user)) {
                swarm.killOff();
            }
        }
    }

    @Override
    protected void config() {
        this.cooldown = this.option("cooldown", PowerTime.toMillis(30, 0), "How long before power can be used again.");
        this.infestOnly = this.option("infested-only", true, "Whether only infested stone blocks should spawn Silverfish. If false, all nearby stone blocks will spawn them.");
        this.item = this.option("item", new ItemStack(Material.ROTTEN_FLESH, 1), "Item used to summon silverfish.");
        this.lifespan = this.option("silverfish-lifespan", PowerTime.toMillis(15, 0), "How long before silverfish should despawn or reform.");
        this.spawnBlocks = this.option("spawnable-blocks", List.of("CHISELED_STONE_BRICKS", "COBBLESTONE", "CRACKED_STONE_BRICKS", "DEEPSLATE", "INFESTED_CHISELED_STONE_BRICKS", "INFESTED_COBBLESTONE", "INFESTED_CRACKED_STONE_BRICKS", "INFESTED_DEEPSLATE", "INFESTED_MOSSY_STONE_BRICKS", "INFESTED_STONE", "INFESTED_STONE_BRICKS", "MOSSY_STONE_BRICKS", "STONE", "STONE_BRICKS"), "Blocks which can spawn silverfish when summoned.");
        this.summonMax = this.option("summon-maximum", 15, "Maximum number of silverfish that can be summoned at one time.");
        this.summonRad = this.option("summon-radius", 10.0, "Radius at which silverfish are summoned.");
        this.summonCount = this.stat("summon-count", 100, "Silverfish summoned", "Can now mine infested stone using a Silk Touch pickaxe. Left-clicking while holding a stack of infested stone in your main hand will cause the entire stack to hatch.");
        this.supplies(this.getRequiredItem());
    }

    @EventHandler(ignoreCancelled=true)
    private void onBreak(BlockBreakEvent event) {
        ItemStack item;
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this) && user.hasStatMaxed(this.summonCount) && event.getBlock().getType().name().startsWith("INFESTED") && (item = user.getPlayer().getInventory().getItemInMainHand()).getType().name().contains("PICKAXE") && item.hasItemMeta() && item.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH)) {
            event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation(), new ItemStack(event.getBlock().getType(), 1));
            event.getBlock().setType(Material.AIR);
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onInteract(PlayerInteractEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this) && user.hasStatMaxed(this.summonCount) && event.getHand() == EquipmentSlot.HAND && event.getItem() != null && event.getItem().getType().name().startsWith("INFESTED")) {
            if (user.getCooldown(this) <= 0L) {
                ItemStack item = event.getItem();
                int count = item.getAmount();
                HashMap<Silverfish, Material> sList = new HashMap<Silverfish, Material>();
                for (int i = 0; i < Math.min(count, user.getOption(this.summonMax)); ++i) {
                    Silverfish sfish = (Silverfish)user.getPlayer().getWorld().spawn(user.getPlayer().getLocation(), Silverfish.class);
                    sList.put(sfish, item.getType());
                    item.setAmount(item.getAmount() - 1);
                }
                Swarm swarm = new Swarm(user, sList);
                if (!this.swarms.containsKey(user) || this.swarms.get(user) == null) {
                    this.swarms.put(user, new HashSet());
                }
                this.swarms.get(user).add(swarm);
                user.setCooldown(this, (Long)user.getOption(this.cooldown));
            } else {
                user.showCooldown(this);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onTarget(EntityTargetEvent event) {
        PowerUser user;
        if (event.getTarget() instanceof Player && event.getEntity() instanceof Silverfish && (user = this.getUser((OfflinePlayer)((Player)event.getTarget()))).allowPower(this)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    private void onUse(PowerUseEvent event) {
        if (event.getPower() == this) {
            PowerUser user = event.getUser();
            if (user.getCooldown(this) <= 0L) {
                Swarm swarm = new Swarm(user, user.getPlayer().getLocation());
                if (!this.swarms.containsKey(user) || this.swarms.get(user) == null) {
                    this.swarms.put(user, new HashSet());
                }
                this.swarms.get(user).add(swarm);
                user.setCooldown(this, (Long)user.getOption(this.cooldown));
            } else {
                user.showCooldown(this);
            }
        }
    }

    private class Swarm
    implements Listener {
        private Map<Silverfish, Material> sList = new HashMap<Silverfish, Material>();
        private int kTask = -1;
        private final PowerUser owner;

        public Swarm(PowerUser owner, Map<Silverfish, Material> sfish) {
            this.owner = owner;
            for (Silverfish fish : sfish.keySet()) {
                PowerTools.setTamed((Creature)fish, this.owner);
                HashSet<LivingEntity> targetList = new HashSet<LivingEntity>();
                targetList.addAll(this.sList.keySet());
                targetList.add((LivingEntity)owner.getPlayer());
                fish.setTarget(PowerTools.getRandomEntity((Entity)fish, 10.0, targetList));
                this.sList.putAll(sfish);
            }
            LocustSwarm.this.registerEvents(this);
            this.prepareKillOff();
        }

        public Swarm(PowerUser owner, Location loc) {
            this.owner = owner;
            int i = 0;
            while ((double)i < (Double)owner.getOption(LocustSwarm.this.summonRad)) {
                for (Block block : PowerTools.getNearbyBlocks(loc, i)) {
                    if (this.sList.size() >= (Integer)owner.getOption(LocustSwarm.this.summonMax) || !((List)owner.getOption(LocustSwarm.this.spawnBlocks)).contains(block.getType().name()) || ((Boolean)owner.getOption(LocustSwarm.this.infestOnly)).booleanValue() && !block.getType().name().startsWith("INFESTED")) continue;
                    Material mat = block.getState().getType();
                    loc.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)block.getType());
                    block.setType(Material.AIR);
                    Silverfish sfish = (Silverfish)loc.getWorld().spawn(block.getLocation(), Silverfish.class);
                    this.sList.put(sfish, mat);
                    PowerTools.setTamed((Creature)sfish, this.owner);
                    HashSet<LivingEntity> targetList = new HashSet<LivingEntity>();
                    targetList.addAll(this.sList.keySet());
                    targetList.add((LivingEntity)owner.getPlayer());
                    sfish.setTarget(PowerTools.getRandomEntity((Entity)sfish, 10.0, targetList));
                    owner.increaseStat(LocustSwarm.this.summonCount, 1);
                }
                ++i;
            }
            LocustSwarm.this.registerEvents(this);
            this.prepareKillOff();
        }

        public void killOff() {
            for (Silverfish sfish : this.sList.keySet()) {
                if (sfish.isValid() && !sfish.isDead()) {
                    sfish.getLocation().getBlock().setType(this.sList.get(sfish).name().startsWith("INFESTED") ? this.sList.get(sfish) : Material.valueOf((String)("INFESTED_" + this.sList.get(sfish).name())));
                    sfish.getWorld().playEffect(sfish.getLocation(), Effect.STEP_SOUND, (Object)this.sList.get(sfish));
                    sfish.remove();
                }
                PowerTools.setTamed((Creature)sfish, null);
            }
            this.sList.clear();
            ((Set)LocustSwarm.this.swarms.get(this.owner)).remove(this);
            if (this.kTask >= 0) {
                LocustSwarm.this.cancelTask(this.kTask);
            }
            LocustSwarm.this.unregisterEvents(this);
        }

        private void prepareKillOff() {
            this.kTask = LocustSwarm.this.runTaskLater((Runnable)new BukkitRunnable(){

                public void run() {
                    Swarm.this.killOff();
                }
            }, PowerTime.toTicks((Long)this.owner.getOption(LocustSwarm.this.lifespan))).getTaskId();
        }

        @EventHandler(ignoreCancelled=true)
        private void onSpawn(CreatureSpawnEvent event) {
            if (!this.sList.containsKey(event.getEntity()) && event.getEntity() instanceof Silverfish && event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SILVERFISH_BLOCK) {
                Silverfish sfish = (Silverfish)event.getEntity();
                for (Silverfish fish : this.sList.keySet()) {
                    if (!fish.isValid() || !fish.getWorld().equals(sfish.getWorld()) || !(fish.getLocation().distanceSquared(sfish.getLocation()) < (Double)this.owner.getOption(LocustSwarm.this.summonRad) * (Double)this.owner.getOption(LocustSwarm.this.summonRad))) continue;
                    this.sList.put(sfish, Material.STONE);
                    PowerTools.setTamed((Creature)sfish, this.owner);
                    this.owner.increaseStat(LocustSwarm.this.summonCount, 1);
                    return;
                }
            }
        }

        @EventHandler
        private void onDeath(EntityDeathEvent event) {
            if (this.sList.containsKey(event.getEntity())) {
                PowerTools.setTamed((Creature)((Silverfish)event.getEntity()), null);
            }
        }

        @EventHandler(ignoreCancelled=true)
        private void onTarget(EntityTargetEvent event) {
            PowerUser target;
            if (event.getTarget() instanceof Player && this.sList.containsKey(event.getEntity()) && ((target = LocustSwarm.this.getUser((OfflinePlayer)((Player)event.getTarget()))) == this.owner || this.sList.containsKey(event.getTarget()))) {
                event.setCancelled(true);
            }
        }
    }
}

