/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

@PowerManifest(name="Grappling Hook", type=PowerType.DEFENSE, author="sirrus86", concept="sirrus86", icon=Material.FISHING_ROD, description="When used on land, the fishing rod works as a grappling hook. Use once to establish a destination, reel in to pull yourself to that location. User has [fall-resist] of fall protection after use.[pull-hooked-entity] Can also be used to reel in entities.[/pull-hooked-entity]")
public final class GrapplingHook
extends Power {
    private Map<PowerUser, Hook> hooks;
    private Map<Hook, Integer> tasks;
    private PowerOption<List<String>> canPull;
    private PowerOption<List<String>> canRide;
    private PowerOption<List<String>> pulledTo;
    private PowerOption<Double> hookVel;
    private PowerOption<Double> minDist;
    private PowerOption<Double> reelVel;
    private PowerOption<Boolean> pullHooked;
    private PowerOption<Long> pullTime;
    private PowerStat travels;

    @Override
    protected void onEnable() {
        this.hooks = new HashMap<PowerUser, Hook>();
        this.tasks = new HashMap<Hook, Integer>();
    }

    @Override
    protected void config() {
        this.canPull = this.option("can-pull", List.of("AXOLOTL", "BAT", "BEE", "BLAZE", "CAT", "CAVE_SPIDER", "CHICKEN", "COW", "CREEPER", "DROWNED", "ENDERMAN", "ENDERMITE", "EVOKER", "FOX", "GOAT", "GUARDIAN", "HUSK", "ILLUSIONER", "MAGMA_CUBE", "MUSHROOM_COW", "OCELOT", "PARROT", "PHANTOM", "PIG", "PIGLIN", "PIGLIN_BRUTE", "PIGZOMBIE", "PILLAGER", "RABBIT", "SHEEP", "SILVERFISH", "SKELETON", "SLIME", "SNOWMAN", "SPIDER", "STRAY", "TURTLE", "VEX", "VILLAGER", "VINDICATOR", "WANDERING_TRADER", "WITCH", "WITHER_SKELETON", "WOLF", "ZOMBIE", "ZOMBIE_VILLAGER", "ZOMBIFIED_PIGLIN"), "Entities that the user can pull to themselves. Refer to https://hub.spigotmc.org/javadocs/spigot/org/bukkit/entity/EntityType.html for a list of applicable values.");
        this.canPull = this.option("can-ride", List.of("BOAT", "DONKEY", "ENDER_DRAGON", "GHAST", "HOGLIN", "HORSE", "LLAMA", "MINECART", "MULE", "PANDA", "POLAR_BEAR", "RAVAGER", "SKELETON_HORSE", "STRIDER", "TRADER_LLAMA", "WITHER", "ZOGLIN", "ZOMBIE_HORSE"), "Entities that the user can ride. Entity must also be on the 'pulled-to' list. Refer to https://hub.spigotmc.org/javadocs/spigot/org/bukkit/entity/EntityType.html for a list of applicable values.");
        this.cooldown = this.option("fall-resist", PowerTime.toMillis(3, 0), "How long after using power that the user is immune to fall damage.");
        this.hookVel = this.option("hook-velocity", 2.0, "Velocity at which hooks are cast by the user.");
        this.minDist = this.option("minimum-distance-from-target", 2.0, "Minimum distance entity can be from target location before hook disengages.");
        this.pulledTo = this.option("pulled-to", List.of("BOAT", "DONKEY", "ELDER_GUARDIAN", "ENDER_DRAGON", "GHAST", "GIANT", "HOGLIN", "HORSE", "IRON_GOLEM", "LLAMA", "MINECART", "MULE", "PANDA", "POLAR_BEAR", "RAVAGER", "SHULKER", "SKELETON_HORSE", "STRIDER", "TRADER_LLAMA", "WITHER", "ZOGLIN", "ZOMBIE_HORSE"), "Entities that the user will be pulled to when hooked. Refer to https://hub.spigotmc.org/javadocs/spigot/org/bukkit/entity/EntityType.html for a list of applicable values.");
        this.pullHooked = this.option("pull-hooked-entity", true, "Whether hooked entities should be pulled to the user.");
        this.pullTime = this.option("maximum-pull-duration", PowerTime.toMillis(3, 0), "Maximum amount of time hook should pull entity before letting go.");
        this.reelVel = this.option("reel-velocity", 1.0, "Speed at which an entity is reeled to their destination.");
        this.travels = this.stat("times-traveled", 50, "Times traveled via grappling hook", "Can now mount certain entities that are hooked.");
        this.supplies(new ItemStack(Material.FISHING_ROD));
    }

    private Runnable doReel(final Hook hook, final Entity entity, final Location loc, final Entity mount) {
        return new BukkitRunnable(){
            int i = 0;

            public void run() {
                if (entity.isValid() && !entity.isDead() && entity.getLocation().getWorld() == loc.getWorld() && entity.getLocation().distanceSquared(loc) > (Double)GrapplingHook.this.getOption(GrapplingHook.this.minDist) * (Double)GrapplingHook.this.getOption(GrapplingHook.this.minDist) && (long)this.i < PowerTime.toTicks((Long)GrapplingHook.this.getOption(GrapplingHook.this.pullTime))) {
                    double dist = entity.getLocation().distance(loc);
                    Vector incr = loc.clone().subtract(entity.getLocation()).toVector().multiply((Double)GrapplingHook.this.getOption(GrapplingHook.this.reelVel) / dist);
                    entity.setVelocity(incr);
                    ++this.i;
                } else {
                    if (mount != null) {
                        mount.addPassenger(entity);
                    }
                    GrapplingHook.this.cancelTask((Integer)GrapplingHook.this.tasks.get(hook));
                }
            }
        };
    }

    @EventHandler
    private void onDmg(EntityDamageEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && event.getCause() == EntityDamageEvent.DamageCause.FALL && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this) && user.getCooldown(this) > 0L) {
            event.setCancelled(true);
            user.setCooldown(this, 0L);
        }
    }

    @EventHandler
    private void onFish(PlayerFishEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.allowPower(this)) {
            Hook hook = null;
            if (event.getState() == PlayerFishEvent.State.CAUGHT_ENTITY && event.getCaught() != null && event.getCaught() != event.getPlayer() && user.getOption(this.pullHooked).booleanValue()) {
                hook = new Hook(event.getCaught());
            } else if (event.getState() == PlayerFishEvent.State.IN_GROUND) {
                hook = new Hook(event.getHook().getLocation());
                user.setCooldown(this, (Long)user.getOption(this.cooldown));
            }
            this.hooks.put(user, hook);
            if (hook != null) {
                user.increaseStat(this.travels, 1);
                hook.reel(user);
            }
        }
    }

    @EventHandler
    private void onLaunch(ProjectileLaunchEvent event) {
        FishHook hook;
        PowerUser user;
        if (event.getEntity() instanceof FishHook && event.getEntity().getShooter() != null && event.getEntity().getShooter() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)(hook = (FishHook)event.getEntity()).getShooter()))).allowPower(this)) {
            hook.setVelocity(hook.getVelocity().multiply(user.getOption(this.hookVel).doubleValue()));
            hook.setBounce(false);
        }
    }

    private class Hook {
        private final Entity entity;
        private final Location loc;

        public Hook(Location loc) {
            this.entity = null;
            this.loc = loc;
        }

        public Hook(Entity entity) {
            this.entity = entity;
            this.loc = null;
        }

        public void reel(PowerUser user) {
            if (this.entity != null) {
                if (((List)user.getOption(GrapplingHook.this.canRide)).contains(this.entity.getType().name()) || ((List)user.getOption(GrapplingHook.this.pulledTo)).contains(this.entity.getType().name())) {
                    GrapplingHook.this.tasks.put(this, GrapplingHook.this.runTaskTimer(GrapplingHook.this.doReel(this, (Entity)user.getPlayer(), this.entity.getLocation(), user.hasStatMaxed(GrapplingHook.this.travels) && ((List)user.getOption(GrapplingHook.this.canRide)).contains(this.entity.getType().name()) ? this.entity : null), 0L, 1L).getTaskId());
                } else if (((List)user.getOption(GrapplingHook.this.canPull)).contains(this.entity.getType().name())) {
                    GrapplingHook.this.tasks.put(this, GrapplingHook.this.runTaskTimer(GrapplingHook.this.doReel(this, this.entity, user.getPlayer().getEyeLocation(), null), 0L, 1L).getTaskId());
                }
            } else if (this.loc != null) {
                GrapplingHook.this.tasks.put(this, GrapplingHook.this.runTaskTimer(GrapplingHook.this.doReel(this, (Entity)user.getPlayer(), this.loc, null), 0L, 1L).getTaskId());
            }
        }
    }
}

