/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

@PowerManifest(name="Ender Soul", type=PowerType.DEFENSE, author="sirrus86", concept="sirrus86", icon=Material.ENDER_PEARL, description="[velOrRefund]Ender pearls [modify-pearl-velocity]are thrown at greater velocity[/modify-pearl-velocity][velAndRefund] and [/velAndRefund][refund-pearl]are immediately refunded after being thrown[/refund-pearl]. [/velOrRefund][pearl-damage-immunity]Damage from ender pearls is negated.[/pearl-damage-immunity]")
public final class EnderSoul
extends Power {
    private PowerOption<Boolean> doEffects;
    private PowerOption<Boolean> immunePearl;
    private PowerOption<Boolean> modVel;
    private PowerOption<Boolean> refundPearl;
    private boolean velAndRefund;
    private boolean velOrRefund;
    private PowerOption<Double> velMod;

    @Override
    protected void config() {
        this.doEffects = this.option("effects.enable", true, "Whether effects should be applied to user after teleporting.");
        this.immunePearl = this.option("pearl-damage-immunity", true, "Whether users should be immune to ender pearl damage.");
        this.modVel = this.option("modify-pearl-velocity", true, "Whether ender pearl velocity should be modified. If false, pearls are thrown normally.");
        this.refundPearl = this.option("refund-pearl", true, "Whether ender pearls should be refunded immediately after use.");
        this.velMod = this.option("velocity-modifier", 2.0, "Modifier for pearl velocity. Higher value leads to faster, but less accurate throws.");
        this.velAndRefund = this.getOption(this.modVel) != false && this.getOption(this.refundPearl) != false;
        this.velOrRefund = this.getOption(this.modVel) != false || this.getOption(this.refundPearl) != false;
        this.supplies(new ItemStack(Material.ENDER_PEARL, 16));
    }

    @EventHandler(ignoreCancelled=true)
    private void onDamage(EntityDamageByEntityEvent event) {
        PowerUser user;
        if (event.getDamager() instanceof EnderPearl && event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this)) {
            event.setCancelled(user.getOption(this.immunePearl).booleanValue());
        }
    }

    @EventHandler
    private void onTeleport(PlayerTeleportEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getPlayer());
        if (user.getOption(this.doEffects).booleanValue() && user.allowPower(this) && event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
            user.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, PowerTime.toTicks(1, 0), 2, false, false, false));
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onLaunch(ProjectileLaunchEvent event) {
        PowerUser user;
        EnderPearl pearl;
        if (event.getEntity() instanceof EnderPearl && (pearl = (EnderPearl)event.getEntity()).getShooter() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)pearl.getShooter()))).allowPower(this)) {
            if (user.getOption(this.refundPearl).booleanValue() && user.getCooldown(this) <= 0L) {
                user.setCooldown(this, 50L);
                this.runTask((Runnable)new BukkitRunnable(){

                    public void run() {
                        user.getPlayer().getInventory().addItem(new ItemStack[]{new ItemStack(Material.ENDER_PEARL, 1)});
                    }
                });
            }
            if (user.getOption(this.modVel).booleanValue()) {
                Vector dir = user.getPlayer().getEyeLocation().getDirection().clone();
                pearl.setVelocity(dir.normalize().multiply(user.getOption(this.velMod).doubleValue()));
            }
        }
    }
}

