/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

@PowerManifest(name="Electrified", type=PowerType.DEFENSE, author="sirrus86", concept="vashvhexx", icon=Material.GLOWSTONE_DUST, description="Immune to lightning. Enemies who attack you with melee attacks while you are blocking are struck by lightning. [cooldown] cooldown.")
public final class Electrified
extends Power {
    private PowerOption<Double> lDmg;

    @Override
    protected void config() {
        this.cooldown = this.option("cooldown", PowerTime.toMillis(0), "Period of time before power can be used again.");
        this.lDmg = this.option("lightning-damage", 5.0, "Damage caused by lightning strikes to attackers.");
        this.supplies(new ItemStack(Material.SHIELD));
    }

    @EventHandler(ignoreCancelled=true)
    private void onDmg(EntityDamageEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this)) {
            if (event instanceof EntityDamageByEntityEvent && user.getPlayer().isBlocking() && user.getCooldown(this) <= 0L) {
                LivingEntity target = PowerTools.getEntitySource(((EntityDamageByEntityEvent)event).getDamager());
                target.getWorld().strikeLightningEffect(target.getLocation());
                user.causeDamage(this, target instanceof Damageable ? (Damageable)target : null, EntityDamageEvent.DamageCause.LIGHTNING, user.getOption(this.lDmg));
                user.setCooldown(this, (Long)user.getOption(this.cooldown));
            }
            if (event.getCause() == EntityDamageEvent.DamageCause.LIGHTNING) {
                event.setCancelled(true);
            }
        }
    }
}

