/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import java.util.HashMap;
import java.util.Map;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.util.Vector;

@PowerManifest(name="Dodge", type=PowerType.DEFENSE, author="sirrus86", concept="n33dy1", icon=Material.ENDER_EYE, description="Always have a [base-dodge-chance]% chance to dodge melee attacks. Chance to dodge increases as you fail to dodge attacks, up to a maximum of [maximum-dodge-chance]%. Upon death your dodge chance resets back to [base-dodge-chance]%.")
public final class Dodge
extends Power {
    private Map<PowerUser, Double> dodge;
    private PowerOption<Double> base;
    private PowerOption<Double> max;
    private PowerOption<Integer> steps;
    private String chanceDecrease;
    private String chanceIncrease;
    private String playerDodged;
    private String youDodged;

    @Override
    protected void onEnable() {
        this.dodge = new HashMap<PowerUser, Double>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.dodge.containsKey(user)) {
            this.dodge.remove(user);
        }
    }

    @Override
    protected void config() {
        this.base = this.option("base-dodge-chance", 15.0, "Minimum dodge chance while using this power.");
        this.max = this.option("maximum-dodge-chance", 75.0, "Maximum dodge chance while using this power.");
        this.steps = this.option("increment-steps", 15, "Number of times dodge chance can increment.");
        this.chanceDecrease = this.locale("message.dodge-chance-decrease", ChatColor.RED + "Dodge chance decreased to [amount]%.");
        this.chanceIncrease = this.locale("message.dodge-chance-increase", ChatColor.GREEN + "Dodge chance increased to [amount]%.");
        this.playerDodged = this.locale("message.player-dodged", ChatColor.RED + "[player] dodged your attack.");
        this.youDodged = this.locale("message.you-dodged", ChatColor.GREEN + "You dodged [name]'s attack!");
    }

    @EventHandler(ignoreCancelled=true)
    private void onDmg(EntityDamageByEntityEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && event.getDamager() instanceof LivingEntity && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this)) {
            double chance;
            if (!this.dodge.containsKey(user)) {
                this.dodge.put(user, user.getOption(this.base));
            }
            if ((chance = random.nextDouble()) < this.dodge.get(user) / 100.0) {
                if (event.getDamager() instanceof Player) {
                    this.getUser((OfflinePlayer)((Player)event.getDamager())).sendMessage(this.playerDodged.replace("[player]", user.getPlayer().getName()));
                }
                user.sendMessage(this.youDodged.replace("[name]", PowerTools.getFriendlyName(event.getDamager()) + ChatColor.GREEN));
                PowerTools.playParticleEffect(user.getPlayer().getLocation(), Particle.CLOUD);
                Vector difference = user.getPlayer().getLocation().clone().subtract(event.getDamager().getLocation()).toVector();
                user.getPlayer().setVelocity(difference);
                event.setCancelled(true);
            } else if (this.dodge.get(user) < user.getOption(this.max)) {
                double dpl = (user.getOption(this.max) - user.getOption(this.base)) / (double)user.getOption(this.steps).intValue();
                double newDodge = this.dodge.get(user) + dpl;
                this.dodge.put(user, newDodge <= user.getOption(this.max) ? Double.valueOf(newDodge) : user.getOption(this.max));
                user.sendMessage(this.chanceIncrease.replace("[amount]", Double.toString(this.dodge.get(user))));
            }
        }
    }

    @EventHandler
    private void onDeath(PlayerDeathEvent event) {
        PowerUser user = this.getUser((OfflinePlayer)event.getEntity());
        if (user.allowPower(this)) {
            this.dodge.put(user, user.getOption(this.base));
            user.sendMessage(this.chanceDecrease.replace("[amount]", Double.toString(this.dodge.get(user))));
        }
    }
}

