/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vindicator;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Diversion", type=PowerType.DEFENSE, author="sirrus86", concept="blacknova777", icon=Material.ARMOR_STAND, usesPackets=true, incomplete=true, description="Upon taking damage from another entity, become invisible while summoning an exact copy of yourself as a diversion to attack the damager. Remain invisible until the diversion dies or despawns [diversion-lifespan] later. [cooldown] cooldown.")
public final class Diversion
extends Power {
    private Map<PowerUser, Set<Decoy>> decoys;
    private PowerStat decoysMade;
    private PowerOption<Long> lifespan;
    private PowerOption<Integer> maxDecoys;

    @Override
    protected void onEnable() {
        this.decoys = new HashMap<PowerUser, Set<Decoy>>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.decoys.get(user) != null) {
            for (Decoy decoy : this.decoys.get(user)) {
                decoy.kill();
            }
        }
    }

    @Override
    protected void config() {
        this.cooldown = this.option("cooldown", PowerTime.toMillis(1, 0, 0), "How long before another diversion can be created.");
        this.decoysMade = this.stat("diversions-made", 30, "Diversions created", "You now create [maxDecoys] diversions when damaged instead of 1.");
        this.lifespan = this.option("diversion-lifespan", PowerTime.toMillis(10, 0), "How long diversions last before despawning.");
        this.maxDecoys = this.option("maximum-diversions", 3, "Number of diversions created when player has fulfilled stat.");
    }

    @EventHandler(ignoreCancelled=true)
    private void onDamage(EntityDamageByEntityEvent event) {
        LivingEntity damager;
        PowerUser user;
        if (event.getEntity() instanceof Player && event.getDamage() > 0.0 && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this) && user.getCooldown(this) <= 0L && (damager = PowerTools.getEntitySource(event.getDamager())) != null && damager != user.getPlayer()) {
            if (!this.decoys.containsKey(user) || this.decoys.get(user) == null) {
                this.decoys.put(user, new HashSet());
            }
            if (this.decoys.get(user).size() < (user.hasStatMaxed(this.decoysMade) ? user.getOption(this.maxDecoys) : 1)) {
                for (int i = 0; i < (user.hasStatMaxed(this.decoysMade) ? user.getOption(this.maxDecoys) : 1); ++i) {
                    final Vindicator pz = (Vindicator)user.getPlayer().getWorld().spawn(user.getPlayer().getLocation(), Vindicator.class);
                    this.runTask((Runnable)new BukkitRunnable(){

                        public void run() {
                            pz.setPatrolLeader(false);
                            PowerTools.addDisguise((Entity)pz, EntityType.PLAYER, null, user.getPlayer().getUniqueId());
                            PowerTools.addEquipmentDisguise((Entity)pz, (LivingEntity)user.getPlayer());
                            PowerTools.addGhost(user.getPlayer());
                        }
                    });
                    if (damager instanceof Mob) {
                        ((Mob)damager).setTarget((LivingEntity)pz);
                    }
                    pz.setSilent(true);
                    pz.setTarget(damager);
                    Decoy decoy = new Decoy(user, pz);
                    this.decoys.get(user).add(decoy);
                    user.increaseStat(this.decoysMade, 1);
                }
            }
        }
    }

    private class Decoy
    implements Listener {
        private PowerUser owner;
        private int timer;
        private Vindicator zombie;

        public Decoy(PowerUser owner, Vindicator zombie) {
            this.owner = owner;
            this.zombie = zombie;
            Diversion.this.registerEvents(this);
            this.timer = Diversion.this.runTaskLater((Runnable)new BukkitRunnable(){

                public void run() {
                    Decoy.this.kill();
                }
            }, PowerTime.toTicks((Long)owner.getOption(Diversion.this.lifespan))).getTaskId();
        }

        public void kill() {
            if (this.zombie != null && this.zombie.isValid() && !this.zombie.isDead()) {
                this.zombie.damage(this.zombie.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
            }
            if (this.owner != null && PowerTools.isGhost(this.owner.getPlayer())) {
                PowerTools.removeGhost(this.owner.getPlayer());
            }
            ((Set)Diversion.this.decoys.get(this.owner)).remove(this);
            Diversion.this.unregisterEvents(this);
            Diversion.this.cancelTask(this.timer);
        }

        @EventHandler
        private void onDeath(EntityDeathEvent event) {
            if (event.getEntity() == this.zombie) {
                event.getDrops().clear();
                event.setDroppedExp(0);
                this.kill();
            }
        }

        @EventHandler(ignoreCancelled=true)
        private void onTarget(EntityTargetEvent event) {
            if (event.getEntity() == this.zombie && event.getTarget() == this.owner.getPlayer()) {
                event.setCancelled(true);
            }
        }
    }
}

