/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import java.util.HashMap;
import java.util.Map;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.EntityEffect;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.ItemStack;

@PowerManifest(name="Decoy", type=PowerType.DEFENSE, author="sirrus86", concept="heylookoverthere", icon=Material.ARMOR_STAND, usesPackets=true, incomplete=true, description="By [act:item]ing any non-player entity while holding [item], transform the entity into a copy of yourself[consume-item], consuming the [item] in the process[/consume-item]. Effect lasts until entity is killed or despawns. [cooldown] cooldown.")
public final class Decoy
extends Power {
    private Map<LivingEntity, PowerUser> decoys;
    private PowerOption<Boolean> consume;
    private PowerOption<Double> range;

    @Override
    protected void onEnable() {
        this.decoys = new HashMap<LivingEntity, PowerUser>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        for (Map.Entry<LivingEntity, PowerUser> entry : this.decoys.entrySet()) {
            if (entry.getValue() != user) continue;
            PowerTools.removeDisguise((Entity)entry.getKey());
        }
    }

    @Override
    protected void config() {
        this.consume = this.option("consume-item", false, "Whether item should be consumed on use.");
        this.cooldown = this.option("cooldown", PowerTime.toMillis(0), "Amount of time before power can be used again.");
        this.item = this.option("item", new ItemStack(Material.BLAZE_ROD), "Item used to create decoys.");
        this.range = this.option("range", 5.0, "How far away user can be to turn an entity into a decoy.");
        this.supplies(this.getRequiredItem());
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        PowerUser user;
        LivingEntity target;
        if (event.getPower() == this && (target = (user = event.getUser()).getTargetEntity(LivingEntity.class, user.getOption(this.range))) != null && !(target instanceof Player)) {
            if (user.getCooldown(this) <= 0L) {
                user.getPlayer().playEffect(EntityEffect.ENTITY_POOF);
                PowerTools.addDisguise((Entity)target, (Entity)user.getPlayer());
                if (user.getOption(this.consume).booleanValue()) {
                    event.consumeItem();
                }
                user.setCooldown(this, (Long)user.getOption(this.cooldown));
                this.decoys.put(target, user);
            } else {
                user.showCooldown(this);
            }
        }
    }
}

