/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.sirrus86.s86powers.events.PowerUseEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Celestial Pillars", type=PowerType.DEFENSE, author="sirrus86", concept="TotalPotato", icon=Material.SEA_LANTERN, usesPackets=true, description="[act:item]ing the top of a block while holding [item][consume-item] consumes it, then[/consume-item] creates a circle of pillars around you. Entities within the circle are trapped inside, while entities outside the pillar cannot enter. You may pass beyond your own pillars. Pillars last for [pillar-duration]. [cooldown] cooldown.")
public final class CelestialPillars
extends Power {
    private Map<PowerUser, Pillar> pillars;
    private Map<PowerUser, Pillar> sPillars;
    private Map<FallingBlock, PowerUser> falling;
    private Set<FallingBlock> superFalling;
    private PowerOption<Boolean> consume;
    private PowerOption<Long> pDur;
    private PowerOption<Integer> pHeight;
    private PowerOption<Integer> pRange;
    private PowerOption<Integer> sPRange;
    private PowerStat pillarsSummoned;

    @Override
    protected void onEnable() {
        this.falling = new HashMap<FallingBlock, PowerUser>();
        this.pillars = new HashMap<PowerUser, Pillar>();
        this.sPillars = new HashMap<PowerUser, Pillar>();
        this.superFalling = new HashSet<FallingBlock>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.pillars.containsKey(user)) {
            this.pillars.get(user).shatter();
        }
        if (this.sPillars.containsKey(user)) {
            this.sPillars.get(user).shatter();
        }
    }

    @Override
    protected void config() {
        this.consume = this.option("consume-item", true, "Whether item should be consumed when power is used.");
        this.cooldown = this.option("cooldown", PowerTime.toMillis(45, 0), "Amount of time before power can be used again.");
        this.item = this.option("item", new ItemStack(Material.SEA_LANTERN), "Item used to trigger pillars.");
        this.pDur = this.option("pillar-duration", PowerTime.toMillis(30, 0), "How long pillars last once created.");
        this.pHeight = this.option("pillar-height", 5, "Height of pillars.");
        this.pRange = this.option("pillar-range", 4, "Distance the pillars are in meters away from the origin point.");
        this.sPRange = this.option("superpower.pillar-range", 8, "Distance the extra pillars are in meters away from the origin point.");
        this.pillarsSummoned = this.stat("pillars-summoned", 60, "Number of pillars summoned", "[act:item]ing the top of the same block creates a second circle of pillars farther away.");
        this.supplies(new ItemStack(this.getRequiredItem().getType(), this.getRequiredItem().getMaxStackSize() / 4));
    }

    private void doPillars(final PowerUser user, Block block, final boolean isSuper) {
        Block[] blocks;
        final int usrPHeight = user.getOption(this.pHeight);
        int usrPRange = user.getOption(this.pRange);
        int usrSPRange = user.getOption(this.sPRange);
        if (isSuper) {
            blocks = new Block[]{block.getRelative(BlockFace.EAST, usrSPRange).getRelative(BlockFace.UP), block.getRelative(BlockFace.WEST, usrSPRange).getRelative(BlockFace.UP), block.getRelative(BlockFace.NORTH_EAST, usrSPRange / 2).getRelative(BlockFace.NORTH, usrSPRange / 2).getRelative(BlockFace.UP), block.getRelative(BlockFace.NORTH_WEST, usrSPRange / 2).getRelative(BlockFace.NORTH, usrSPRange / 2).getRelative(BlockFace.UP), block.getRelative(BlockFace.SOUTH_EAST, usrSPRange / 2).getRelative(BlockFace.SOUTH, usrSPRange / 2).getRelative(BlockFace.UP), block.getRelative(BlockFace.SOUTH_WEST, usrSPRange / 2).getRelative(BlockFace.SOUTH, usrSPRange / 2).getRelative(BlockFace.UP)};
            user.increaseStat(this.pillarsSummoned, 6);
        } else {
            user.setCooldown(this, (Long)user.getOption(this.cooldown));
            blocks = new Block[]{block.getRelative(BlockFace.NORTH, usrPRange).getRelative(BlockFace.UP), block.getRelative(BlockFace.SOUTH, usrPRange).getRelative(BlockFace.UP), block.getRelative(BlockFace.NORTH_EAST, usrPRange / 2).getRelative(BlockFace.EAST, usrPRange / 2).getRelative(BlockFace.UP), block.getRelative(BlockFace.NORTH_WEST, usrPRange / 2).getRelative(BlockFace.WEST, usrPRange / 2).getRelative(BlockFace.UP), block.getRelative(BlockFace.SOUTH_EAST, usrPRange / 2).getRelative(BlockFace.EAST, usrPRange / 2).getRelative(BlockFace.UP), block.getRelative(BlockFace.SOUTH_WEST, usrPRange / 2).getRelative(BlockFace.WEST, usrPRange / 2).getRelative(BlockFace.UP)};
            user.increaseStat(this.pillarsSummoned, 6);
        }
        if (blocks != null) {
            for (final Block b : blocks) {
                for (int i = 0; i < usrPHeight; ++i) {
                    this.runTaskLater(new Runnable(){

                        @Override
                        public void run() {
                            Block air = PowerTools.getHighestAirBlock(b.getLocation(), usrPHeight);
                            if (air != null && !air.getType().isSolid()) {
                                FallingBlock fall = air.getWorld().spawnFallingBlock(air.getLocation(), Material.SEA_LANTERN.createBlockData());
                                fall.setDropItem(false);
                                CelestialPillars.this.falling.put(fall, user);
                                if (isSuper) {
                                    CelestialPillars.this.superFalling.add(fall);
                                }
                            }
                        }
                    }, i * 5);
                }
            }
        }
        PowerTools.blockDisguise(block, Material.SEA_LANTERN);
    }

    @EventHandler(ignoreCancelled=true)
    private void onChange(EntityChangeBlockEvent event) {
        FallingBlock fallBlock;
        if (event.getEntity() instanceof FallingBlock && this.falling.containsKey(fallBlock = (FallingBlock)event.getEntity()) && this.pillars.containsKey(this.falling.get(fallBlock))) {
            PowerUser user = this.falling.get(fallBlock);
            if (this.superFalling.contains(fallBlock) && this.sPillars.containsKey(user)) {
                Pillar pillar = this.sPillars.get(user);
                pillar.addBlock(event.getBlock());
            } else {
                Pillar pillar = this.pillars.get(user);
                pillar.addBlock(event.getBlock());
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseEvent event) {
        if (event.getPower() == this && event.hasBlock()) {
            boolean isSuper;
            PowerUser user = event.getUser();
            boolean bl = isSuper = user.hasStatMaxed(this.pillarsSummoned) && this.pillars.containsKey(user) && event.getClickedBlock().equals(this.pillars.get(user).getCore());
            if (user.getCooldown(this) <= 0L || isSuper) {
                Pillar pillar = new Pillar(user, event.getClickedBlock(), isSuper);
                this.doPillars(user, event.getClickedBlock(), isSuper);
                if (user.getOption(this.consume).booleanValue()) {
                    event.consumeItem();
                }
                if (isSuper) {
                    this.sPillars.put(user, pillar);
                    pillar.setLife(this.pillars.get(user).getLife());
                } else {
                    this.pillars.put(user, pillar);
                }
            } else {
                user.showCooldown(this);
            }
        }
    }

    private class Pillar
    implements Listener {
        private Map<UUID, Location> inside;
        private Map<UUID, Location> outside;
        private final List<Block> blocks;
        private final Block core;
        private boolean isSuper;
        private long life;
        private final int task;
        private final PowerUser user;
        private Runnable manage = new BukkitRunnable(){

            public void run() {
                if (Pillar.this.life > System.currentTimeMillis()) {
                    double range = Pillar.this.isSuper ? (double)((Integer)Pillar.this.user.getOption(CelestialPillars.this.sPRange)).intValue() : (double)((Integer)Pillar.this.user.getOption(CelestialPillars.this.pRange)).intValue();
                    for (Entity entity : PowerTools.getNearbyEntities(Entity.class, Pillar.this.core.getLocation(), range + 2.0)) {
                        if (entity == Pillar.this.user.getPlayer() || CelestialPillars.this.falling.containsKey(entity) || CelestialPillars.this.superFalling.contains(entity)) continue;
                        Location checkLoc = Pillar.this.core.getLocation().clone();
                        checkLoc.setY(entity.getLocation().getY());
                        if (!Pillar.this.inside.containsKey(entity.getUniqueId()) && !Pillar.this.outside.containsKey(entity.getUniqueId())) {
                            if (entity.getLocation().distanceSquared(checkLoc) > range * range) {
                                Pillar.this.outside.put(entity.getUniqueId(), entity.getLocation().clone());
                            } else {
                                Pillar.this.inside.put(entity.getUniqueId(), entity.getLocation().clone());
                            }
                        }
                        if (Pillar.this.inside.containsKey(entity.getUniqueId()) && checkLoc.distanceSquared(entity.getLocation()) > range * range) {
                            entity.teleport((Location)Pillar.this.inside.get(entity.getUniqueId()));
                            continue;
                        }
                        if (Pillar.this.outside.containsKey(entity.getUniqueId()) && checkLoc.distanceSquared(entity.getLocation()) <= range * range) {
                            entity.teleport((Location)Pillar.this.outside.get(entity.getUniqueId()));
                            continue;
                        }
                        if (Pillar.this.inside.containsKey(entity.getUniqueId())) {
                            Pillar.this.inside.put(entity.getUniqueId(), entity.getLocation().clone());
                            continue;
                        }
                        if (!Pillar.this.outside.containsKey(entity.getUniqueId())) continue;
                        Pillar.this.outside.put(entity.getUniqueId(), entity.getLocation().clone());
                    }
                } else {
                    Pillar.this.shatter();
                }
            }
        };

        public Pillar(PowerUser user, Block core, boolean isSuper) {
            this.user = user;
            this.blocks = new ArrayList<Block>();
            this.core = core;
            this.isSuper = isSuper;
            this.life = System.currentTimeMillis() + (Long)user.getOption(CelestialPillars.this.pDur);
            this.inside = new HashMap<UUID, Location>();
            this.outside = new HashMap<UUID, Location>();
            this.task = CelestialPillars.this.runTaskTimer(this.manage, 0L, 0L).getTaskId();
            CelestialPillars.this.registerEvents(this);
        }

        public void addBlock(Block block) {
            this.blocks.add(block);
        }

        public Block getCore() {
            return this.core;
        }

        public long getLife() {
            return this.life;
        }

        public void setLife(long life) {
            this.life = life;
        }

        public void shatter() {
            for (int i = 0; i < this.blocks.size(); ++i) {
                Block block = this.blocks.get(i);
                block.setType(Material.AIR);
                block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, (Object)Material.SEA_LANTERN);
            }
            if (CelestialPillars.this.pillars.containsKey(this.user) && CelestialPillars.this.pillars.get(this.user) == this) {
                CelestialPillars.this.pillars.remove(this.user);
            }
            if (CelestialPillars.this.sPillars.containsKey(this.user) && CelestialPillars.this.sPillars.get(this.user) == this) {
                CelestialPillars.this.sPillars.remove(this.user);
            }
            PowerTools.blockUpdate(this.core);
            this.blocks.clear();
            this.inside.clear();
            this.outside.clear();
            CelestialPillars.this.unregisterEvents(this);
            CelestialPillars.this.cancelTask(this.task);
        }

        @EventHandler(ignoreCancelled=true)
        private void onBreak(BlockBreakEvent event) {
            if (this.blocks.contains(event.getBlock())) {
                event.setCancelled(true);
            }
        }
    }
}

