/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import java.util.HashMap;
import java.util.Map;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

@PowerManifest(name="Bulwark", type=PowerType.DEFENSE, author="sirrus86", concept="Neubulae", icon=Material.SHIELD, description="Blocking with a shield [parry-window] before being hit will parry melee attacks, or deflect arrows back at the shooter. [effects.enable]Entities that are parried will also be afflicted with status effects. [/effects.enable][cooldown] cooldown.")
public final class Bulwark
extends Power {
    private Map<PowerUser, Long> parryWindow;
    private PowerOption<Boolean> doEffects;
    private PowerOption<Double> knockback;
    private PowerOption<Long> parryTime;
    private String didDeflect;
    private String didParry;
    private String wasParried;

    @Override
    protected void onEnable() {
        this.parryWindow = new HashMap<PowerUser, Long>();
    }

    @Override
    protected void config() {
        this.cooldown = this.option("cooldown", PowerTime.toMillis(3, 0), "Amount of time after a successful parry before an attack can be parried again.");
        this.doEffects = this.option("effects.enable", true, "Whether to afflict the parried entity with status effects.");
        this.item = this.option("item", new ItemStack(Material.SHIELD), "Item used for blocking.", true);
        this.knockback = this.option("knockback", 1.3, "Velocity modifier for knockback when an attack is parried.");
        this.parryTime = this.option("parry-window", PowerTime.toMillis(1, 0), "Maximum amount of time after blocking to successfully parry an attack.");
        this.didDeflect = this.locale("message.you-deflected", ChatColor.GREEN + "You deflected [name]'s projectile!");
        this.didParry = this.locale("message.you-parried", ChatColor.GREEN + "You parried [name]'s attack!");
        this.wasParried = this.locale("message.you-were-parried", ChatColor.RED + "Your attack was parried by [name]!");
        this.supplies(new ItemStack(Material.SHIELD));
    }

    @EventHandler
    private void onBlock(PlayerInteractEvent event) {
        PowerUser user;
        if (event.getAction().name().startsWith("RIGHT") && (user = this.getUser((OfflinePlayer)event.getPlayer())).allowPower(this) && event.getItem() != null && event.getItem().getType() == Material.SHIELD) {
            this.parryWindow.put(user, System.currentTimeMillis() + user.getOption(this.parryTime));
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onDamage(EntityDamageByEntityEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this) && user.getPlayer().isBlocking() && this.parryWindow.containsKey(user) && this.parryWindow.get(user) > System.currentTimeMillis() && user.getCooldown(this) <= 0L) {
            if (event.getDamager() instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)event.getDamager();
                Vector difference = target.getLocation().clone().subtract(user.getPlayer().getLocation()).toVector();
                target.setVelocity(difference.multiply(user.getOption(this.knockback).doubleValue()));
                if (target instanceof Player) {
                    this.getUser((OfflinePlayer)((Player)target)).sendMessage(this.wasParried.replace("[name]", user.getName() + ChatColor.RED));
                }
                user.sendMessage(this.didParry.replace("[name]", PowerTools.getFriendlyName((Entity)target) + ChatColor.GREEN));
                if (user.getOption(this.doEffects).booleanValue()) {
                    target.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, PowerTime.toTicks(5, 0), 0, false, false, true));
                }
            } else if (event.getDamager() instanceof Arrow && ((Arrow)event.getDamager()).getShooter() != null && ((Arrow)event.getDamager()).getShooter() instanceof LivingEntity) {
                Arrow proj = (Arrow)event.getDamager();
                LivingEntity target = (LivingEntity)proj.getShooter();
                if (proj.getWorld() == target.getWorld()) {
                    double speed = proj.getVelocity().length();
                    Vector direction = target.getEyeLocation().toVector().subtract(new Vector(0.0, 0.25, 0.0)).subtract(proj.getLocation().toVector()).normalize();
                    Arrow newProj = proj.getWorld().spawnArrow(proj.getLocation(), direction, (float)speed * 0.9f, 0.0f);
                    proj.remove();
                    newProj.getWorld().playSound(newProj.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
                    newProj.setShooter((ProjectileSource)target);
                    user.sendMessage(this.didDeflect.replace("[name]", PowerTools.getFriendlyName((Entity)target) + ChatColor.GREEN));
                    user.setCooldown(this, (Long)user.getOption(this.cooldown));
                    event.setCancelled(true);
                }
            }
        }
    }
}

