/*
 * Decompiled with CFR 0.152.
 */
package me.sirrus86.s86powers.powers.internal.defense;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.sirrus86.s86powers.events.PowerUseOnEntityEvent;
import me.sirrus86.s86powers.events.UserMaxedStatEvent;
import me.sirrus86.s86powers.powers.Power;
import me.sirrus86.s86powers.powers.PowerManifest;
import me.sirrus86.s86powers.powers.PowerOption;
import me.sirrus86.s86powers.powers.PowerStat;
import me.sirrus86.s86powers.powers.PowerType;
import me.sirrus86.s86powers.tools.PowerTools;
import me.sirrus86.s86powers.users.PowerUser;
import me.sirrus86.s86powers.utils.PowerTime;
import org.bukkit.EntityEffect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Spider;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

@PowerManifest(name="Arachnophile", type=PowerType.DEFENSE, author="sirrus86", concept="vashvhexx", icon=Material.COBWEB, usesPackets=true, description="Hostile spiders, cave spiders, silverfish, and endermites will no longer attack you[poison-immunity], you become immune to poison[/poison-immunity], and fall damage is reduced by [fall-damage-reduction]%. [act:item]ing a spider while holding [item] will allow you to tame it. Tamed spiders will follow and defend you.")
public final class Arachnophile
extends Power {
    private PowerOption<Double> fallRed;
    private PowerOption<List<String>> ignoreTypes;
    private PowerOption<Boolean> noPoison;
    private Map<PowerUser, TamedSpider> spiders;
    private PowerStat spiderDmg;
    private PowerOption<Long> webCooldown;
    private PowerOption<List<PotionEffect>> webEffects;
    private PowerOption<ItemStack> webItem;

    @Override
    protected void onEnable() {
        this.spiders = new HashMap<PowerUser, TamedSpider>();
    }

    @Override
    protected void onDisable(PowerUser user) {
        if (this.spiders.containsKey(user)) {
            this.spiders.get(user).unTame();
            this.spiders.remove(user);
        }
    }

    @Override
    protected void config() {
        this.fallRed = this.option("fall-damage-reduction", 50.0, "Percentage of fall damage to negate.");
        this.ignoreTypes = this.option("ignoring-entity-types", List.of("CAVE_SPIDER", "ENDERMITE", "SILVERFISH", "SPIDER"), "Entity types which will ignore users.");
        this.item = this.option("item", new ItemStack(Material.STICK), "Item used to tame and direct spiders.");
        this.noPoison = this.option("poison-immunity", true, "Whether user should be immune to poison.");
        this.spiderDmg = this.stat("damage-by-tamed-spiders", 50, "Damage caused by tamed spiders", "Tamed spiders will occassionally shoot webs at targets, slowing them down.");
        this.webCooldown = this.option("web-cooldown", PowerTime.toMillis(5, 0), "Amount of time between webs shot by tamed spiders.");
        this.webEffects = this.option("web-effects", List.of(new PotionEffect(PotionEffectType.SLOW, (int)PowerTime.toMillis(3, 0), 1)), "Effects caused when spider webs hit targets.");
        this.webItem = this.option("web-item", new ItemStack(Material.COBWEB, 1), "Item used to show the projectile shot by tamed spiders.");
        this.supplies(new ItemStack(this.getRequiredItem().getType(), 1));
    }

    @EventHandler(ignoreCancelled=true)
    private void onDmg(EntityDamageEvent event) {
        PowerUser user;
        if (event.getEntity() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getEntity()))).allowPower(this)) {
            if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
                event.setDamage(event.getDamage() * (1.0 - user.getOption(this.fallRed) / 100.0));
            } else if (event.getCause() == EntityDamageEvent.DamageCause.POISON && user.getOption(this.noPoison).booleanValue()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void noTarget(EntityTargetLivingEntityEvent event) {
        PowerUser user;
        if (event.getTarget() instanceof Player && (user = this.getUser((OfflinePlayer)((Player)event.getTarget()))).allowPower(this) && user.getOption(this.ignoreTypes).contains(event.getEntityType().name())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onUse(PowerUseOnEntityEvent event) {
        if (event.getPower() == this && event.getEntity() instanceof Spider && !(event.getEntity() instanceof CaveSpider)) {
            PowerUser user = event.getUser();
            if (this.spiders.containsKey(user)) {
                this.spiders.get(user).unTame();
            }
            TamedSpider spider = new TamedSpider(user, (Spider)event.getEntity());
            this.spiders.put(user, spider);
        }
    }

    private class TamedSpider
    implements Listener {
        private final PowerUser owner;
        private final Spider spider;
        private int task = -1;
        private List<Snowball> webs = new ArrayList<Snowball>();
        private Runnable shootWeb = new BukkitRunnable(){

            public void run() {
                if (TamedSpider.this.spider.getTarget() != null) {
                    Snowball web = (Snowball)TamedSpider.this.spider.launchProjectile(Snowball.class);
                    PowerTools.addDisguise((Entity)web, (ItemStack)TamedSpider.this.owner.getOption(Arachnophile.this.webItem));
                    TamedSpider.this.webs.add(web);
                }
                TamedSpider.this.task = Arachnophile.this.getInstance().runTaskLater(TamedSpider.this.shootWeb, PowerTime.toTicks((Long)TamedSpider.this.owner.getOption(Arachnophile.this.webCooldown))).getTaskId();
            }
        };

        public TamedSpider(PowerUser owner, Spider spider) {
            Arachnophile.this.getInstance().registerEvents(this);
            this.owner = owner;
            this.spider = spider;
            PowerTools.setTamed((Creature)spider, owner);
            spider.playEffect(EntityEffect.WOLF_HEARTS);
            if (owner.hasStatMaxed(Arachnophile.this.spiderDmg)) {
                this.task = Arachnophile.this.getInstance().runTask(this.shootWeb).getTaskId();
            }
        }

        public void unTame() {
            PowerTools.setTamed((Creature)this.spider, null);
            if (this.task >= 0) {
                Arachnophile.this.cancelTask(this.task);
            }
            Arachnophile.this.unregisterEvents(this);
        }

        @EventHandler(ignoreCancelled=true)
        private void onDamage(EntityDamageByEntityEvent event) {
            if (event.getDamager() == this.spider) {
                this.owner.increaseStat(Arachnophile.this.spiderDmg, (int)event.getDamage());
            } else if (this.webs.contains(event.getEntity())) {
                event.setCancelled(true);
            }
        }

        @EventHandler
        private void onDeath(EntityDeathEvent event) {
            if (event.getEntity() == this.spider) {
                Arachnophile.this.spiders.remove(this.owner);
            }
        }

        @EventHandler
        private void onHit(ProjectileHitEvent event) {
            if (this.webs.contains(event.getEntity())) {
                if (event.getHitEntity() != null && event.getHitEntity() instanceof LivingEntity) {
                    LivingEntity entity = (LivingEntity)event.getHitEntity();
                    entity.addPotionEffects((Collection)this.owner.getOption(Arachnophile.this.webEffects));
                }
                this.webs.remove(event.getEntity());
            }
        }

        @EventHandler
        private void onStatMax(UserMaxedStatEvent event) {
            if (event.getUser() == this.owner && event.getStat() == Arachnophile.this.spiderDmg) {
                this.task = Arachnophile.this.getInstance().runTask(this.shootWeb).getTaskId();
            }
        }
    }
}

